/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryDetailBillApplyInfoXbj4IncomeCalcService;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoXbj4IncomeCalcReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO;
import com.tydic.pfsc.api.busi.bo.Xbj4IncomeCalcRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.WorkFlowDataMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.enums.CompanyType;
import com.tydic.pfsc.enums.InquiryMailStatus;
import com.tydic.pfsc.enums.InquiryPayPass;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryDetailBillApplyInfoXbj4IncomeCalcServiceImpl
implements BusiQueryDetailBillApplyInfoXbj4IncomeCalcService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailBillApplyInfoXbj4IncomeCalcServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;

    public BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO queryEntryDetails(BusiQueryDetailBillApplyInfoXbj4IncomeCalcReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546\u7f34\u8d39\u6536\u5165\u8ba1\u7b97\u5355\u8be6\u60c5\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = null;
        if (applyNo.startsWith("KPSQ") && (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo)) == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        List<InquiryPayOrder> payOrderList = null;
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        BigDecimal applyAmt = BigDecimal.ZERO;
        InquiryPayOrderExt record = new InquiryPayOrderExt();
        if (applyNo.startsWith("KPSQ")) {
            record.setApplyNo(applyNo);
            payOrderList = this.inquiryPayOrderMapper.getListByPage(record, (Page<Map<String, Object>>)page);
        } else if (applyNo.startsWith("SRJS")) {
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setBillNo(applyNo);
            List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
            LinkedList<String> applyNoList = new LinkedList<String>();
            Iterator iterator = billApplyInfoList.iterator();
            while (iterator.hasNext()) {
                BillApplyInfo billApply = (BillApplyInfo)iterator.next();
                applyAmt = applyAmt.add(billApply.getAmt());
                applyNoList.add(billApply.getApplyNo());
            }
            if (!CollectionUtils.isEmpty(applyNoList)) {
                record.setApplyNoList(applyNoList);
                payOrderList = this.inquiryPayOrderMapper.getListByPage(record, (Page<Map<String, Object>>)page);
            }
        }
        ArrayList<Xbj4IncomeCalcRspBO> orderList = new ArrayList<Xbj4IncomeCalcRspBO>();
        if (!CollectionUtils.isEmpty(payOrderList)) {
            for (InquiryPayOrder inquiryPayOrder : payOrderList) {
                Xbj4IncomeCalcRspBO order = new Xbj4IncomeCalcRspBO();
                BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)order);
                String operUnitName = this.organizationInfoService.queryOrgName(inquiryPayOrder.getOperUnitNo());
                order.setOperUnitName(operUnitName);
                String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                order.setSupplierName(supplierName);
                order.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
                order.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
                order.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(inquiryPayOrder.getOrderStatus())));
                order.setMailStatusDesc(this.enumsService.getDescr(InquiryMailStatus.getInstance(inquiryPayOrder.getMailStatus())));
                order.setCompanyTypeDesc(this.enumsService.getDescr(CompanyType.convert(inquiryPayOrder.getCompanyType())));
                orderList.add(order);
            }
        }
        BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO rspBO = new BusiQueryDetailBillApplyInfoXbj4IncomeCalcRspBO();
        if (applyNo.startsWith("KPSQ")) {
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
            rspBO.setSupplierName(billApplyInfo == null ? "" : billApplyInfo.getOperUnitName());
            rspBO.setInvoiceTypeName(billApplyInfo == null ? "" : this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType()))));
        } else if (applyNo.startsWith("SRJS")) {
            rspBO.setApplyNo(applyNo);
            WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
            workFlowDataInfo.setBillNo(applyNo);
            workFlowDataInfo = this.workFlowDataMapper.getModelBy(workFlowDataInfo);
            rspBO.setApplyDate(workFlowDataInfo.getApplyDate());
            rspBO.setAmt(applyAmt);
            rspBO.setSupplierName(this.organizationInfoService.queryOrgName(reqBO.getCompanyId()));
        }
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

