/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.trade.impl;

import com.tydic.pfsc.api.deal.bo.SaleInvoiceInfoBO;
import com.tydic.pfsc.api.trade.SaleInvoiceInfoService;
import com.tydic.pfsc.api.trade.bo.SaleInvoiceDetailBO;
import com.tydic.pfsc.api.trade.bo.SaleInvoiceInfoRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.enums.InvoiceStatus;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.trade.SaleInvoiceInfoService"})
public class SaleInvoiceInfoServiceImpl
implements SaleInvoiceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(SaleInvoiceInfoServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"qrySaleInvoiceInfoDetail"})
    public SaleInvoiceInfoRspBO qrySaleInvoiceInfoDetail(@RequestBody SaleInvoiceInfoBO saleInvoiceInfoBO) {
        if (saleInvoiceInfoBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleInvoiceInfoRspBO saleInvoiceInfoRspBO = new SaleInvoiceInfoRspBO();
        try {
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectByApplyNo(saleInvoiceInfoBO.getApplyNo());
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleInvoiceInfoBO.getApplyNo());
            if (billApplyInfo != null) {
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)saleInvoiceInfoRspBO);
            }
            if (saleInvoiceInfos != null && saleInvoiceInfos.size() > 0) {
                List<SaleInvoiceDetail> saleInvoiceDetails;
                BeanUtils.copyProperties((Object)saleInvoiceInfos.get(0), (Object)saleInvoiceInfoRspBO);
                if (saleInvoiceInfoRspBO.getInvoiceStatus() != null) {
                    saleInvoiceInfoRspBO.setInvoiceStatusStr(InvoiceStatus.getInstance(saleInvoiceInfoRspBO.getInvoiceStatus()).getDescr());
                }
                if (saleInvoiceInfoRspBO.getInvoiceType() != null) {
                    saleInvoiceInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(saleInvoiceInfoRspBO.getInvoiceType()).getDescr());
                }
                if ((saleInvoiceDetails = this.saleInvoiceDetailMapper.selectByInvoiceNo(saleInvoiceInfoRspBO.getInvoiceNo())) != null) {
                    ArrayList<SaleInvoiceDetailBO> saleInvoiceDetailBOs = new ArrayList<SaleInvoiceDetailBO>();
                    for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetails) {
                        SaleInvoiceDetailBO saleInvoiceDetailBO = new SaleInvoiceDetailBO();
                        BeanUtils.copyProperties((Object)saleInvoiceDetail, (Object)saleInvoiceDetailBO);
                        saleInvoiceDetailBOs.add(saleInvoiceDetailBO);
                    }
                    saleInvoiceInfoRspBO.setSaleInvoiceDetailBOs(saleInvoiceDetailBOs);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        return saleInvoiceInfoRspBO;
    }
}

