/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.po.AdvanceReceive;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.WFEventResult;
import com.tydic.pfsc.enums.AdvanceReceiveStatus;
import com.tydic.pfsc.enums.BusinessType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.ReceiveType;
import com.tydic.pfsc.enums.SubAccountServiceType;
import com.tydic.pfsc.service.atom.AccountantEngineService;
import com.tydic.pfsc.service.atom.SubAccountService;
import com.tydic.pfsc.service.atom.WorkFlowFinishEvent;
import com.tydic.pfsc.service.atom.bo.AccountantEngineReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handmadeCollectionWorkFlowFinshEventImpl")
public class HandmadeCollectionWorkFlowFinshEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(HandmadeCollectionWorkFlowFinshEventImpl.class);
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private AccountantEngineService accountantEngineService;

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u624b\u5de5\u6536\u6b3e\u5355\u5de5\u4f5c\u6d41\u5b8c\u6210\u540e\u5904\u7406\u670d\u52a1\u5165\u53c2\uff0cworkFlowDataInfo=" + workFlowDataInfo + ";billType=" + billType + ";billNo=" + billNo);
        }
        AccountantEngineReqBO accountantEngineReqBO = new AccountantEngineReqBO();
        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey(Long.valueOf(workFlowDataInfo.getBillNo()));
        SubAcctInfoExt subAcctInfoExt = this.subAccountService.getWithMainAccount(advanceReceive.getRecSubAcct());
        if (SubAccountServiceType.DEFAULT.getCode().equals(subAcctInfoExt.getServiceType()) && ReceiveType.BANK_RECEIVE.getCode().equals(advanceReceive.getRecType())) {
            accountantEngineReqBO.setBusinessType(BusinessType.MANUAL_RECEIVE.getCode());
        } else if (SubAccountServiceType.DEFAULT.getCode().equals(subAcctInfoExt.getServiceType()) && ReceiveType.BILL_RECEIVE.getCode().equals(advanceReceive.getRecType())) {
            accountantEngineReqBO.setBusinessType(BusinessType.BILL_RECEIVE.getCode());
        } else if (SubAccountServiceType.DISTRIBUTE_BUSINESS.getCode().equals(subAcctInfoExt.getServiceType()) && ReceiveType.BANK_RECEIVE.getCode().equals(advanceReceive.getRecType())) {
            accountantEngineReqBO.setBusinessType(BusinessType.XBJ_DISTRIBUTE_FEE_MANUAL_RECEIVE.getCode());
        } else if (SubAccountServiceType.DISTRIBUTE_BUSINESS.getCode().equals(subAcctInfoExt.getServiceType()) && ReceiveType.BILL_RECEIVE.getCode().equals(advanceReceive.getRecType())) {
            accountantEngineReqBO.setBusinessType(BusinessType.XBJ_DISTRIBUTE_FEE_MANUAL_BILL_RECEIVE.getCode());
        }
        if (!OrderSource.ELECTRIC_AREA.getCode().equals(subAcctInfoExt.getSource())) {
            ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
            amounts.add(advanceReceive.getTranAmt());
            accountantEngineReqBO.setAmounts(amounts);
            accountantEngineReqBO.setClientAcctNo(advanceReceive.getRecSubAcct());
            accountantEngineReqBO.setSource(subAcctInfoExt.getSource());
            accountantEngineReqBO.setOperUnit(advanceReceive.getRecOrgId());
            accountantEngineReqBO.setRemark(advanceReceive.getTranRemark());
            List<Long> txnNo = this.accountantEngineService.executeAccountantEngine(accountantEngineReqBO);
            AdvanceReceive advanceReceive1 = new AdvanceReceive();
            advanceReceive1.setSeq(advanceReceive.getSeq());
            advanceReceive1.setTxnNo(String.valueOf(txnNo.get(0)));
            advanceReceive1.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            this.advanceReceiveMapper.updateByPrimaryKeySelective(advanceReceive1);
        }
        WFEventResult eventResult = new WFEventResult();
        eventResult.setSuccess(true);
        eventResult.setRespCode("0000");
        eventResult.setRespDesc("\u624b\u5de5\u6536\u6b3e\u5355\u5ba1\u6279\u5b8c\u6210\u540e\u5904\u7406\u6210\u529f");
        return eventResult;
    }
}

