/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfsc.api.busi.BusiApplyElectronicInvoiceService;
import com.tydic.pfsc.api.busi.bo.BusiApplyElectronicInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiApplyElectronicInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.enums.WFBillType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.FscWfStartAtomService;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomReqBO;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomRspBO;
import com.tydic.pfsc.utils.holytax.SeqUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiApplyElectronicInvoiceServiceImpl
implements BusiApplyElectronicInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyElectronicInvoiceServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    private String url;
    private String appid;
    private String appsecret;
    private static final String RESP_CODE_SUCCESS = "0000";

    public BusiApplyElectronicInvoiceRspBO processApplyInvoice(BusiApplyElectronicInvoiceReqBO reqBO) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processReturnData(Map<String, String> returnData) {
        String responseVal = returnData.get("response");
        logger.debug("\u5408\u529b\u4e2d\u7a0e\u8fd4\u56de\u6570\u636e=" + responseVal);
        JSONObject jObject = JSONObject.parseObject((String)responseVal);
        String code = (String)jObject.get((Object)"code");
        String msg = (String)jObject.get((Object)"msg");
        if (!RESP_CODE_SUCCESS.equals(code)) throw new PfscExtBusinessException("18000", msg);
        Date invoiceDate = null;
        try {
            Document document = DocumentHelper.parseText((String)msg);
            Element rootElement = document.getRootElement();
            Element returndata = rootElement.element("body").element("returndata");
            String fpdm = returndata.element("fpdm").getText();
            String fphm = returndata.element("fphm").getText();
            String kprq = returndata.element("kprq").getText();
            String jmbbh = returndata.element("jmbbh").getText();
            String hjje = returndata.element("hjje").getText();
            String hjse = returndata.element("hjse").getText();
            String jshj = returndata.element("jshj").getText();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                invoiceDate = sdf.parse(kprq);
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u65e5\u671f[" + kprq + "]\u89e3\u6790\u51fa\u9519");
            }
            SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
            saleInvoiceInfo.setInvoiceNo(fphm);
            saleInvoiceInfo.setInvoiceCode(fpdm);
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            String invoiceDateStr = sdf.format(invoiceDate);
            saleInvoiceInfo.setInvoiceDate(sdf.parse(invoiceDateStr));
            String applyNo = SeqUtil.unpack(jmbbh);
            saleInvoiceInfo.setApplyNo(applyNo);
            saleInvoiceInfo.setUntaxAmt(new BigDecimal(hjje));
            saleInvoiceInfo.setTaxAmt(new BigDecimal(hjse));
            saleInvoiceInfo.setAmt(new BigDecimal(jshj));
            saleInvoiceInfo.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
            List groups = returndata.element("fyxm").elements();
            if (null != groups && groups.size() > 0) {
                for (Object o : groups) {
                    Element group = (Element)o;
                    String spmc = group.element("spmc").getText();
                    String ggxh = group.element("ggxh").getText();
                    String dw = group.element("dw").getText();
                    String spsl = group.element("spsl").getText();
                    String je = group.element("je").getText();
                    String se = group.element("se").getText();
                    String sl = group.element("sl").getText();
                    String spbm = group.element("spbm").getText();
                    SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                    saleInvoiceDetail.setItemName(spmc);
                    saleInvoiceDetail.setSpecModel(ggxh);
                    saleInvoiceDetail.setUnitName(dw);
                    if (!StringUtils.hasText((String)spsl)) {
                        spsl = "1";
                    }
                    saleInvoiceDetail.setQuantity(new BigDecimal(spsl));
                    saleInvoiceDetail.setTaxAmt(new BigDecimal(se));
                    saleInvoiceDetail.setAmount(new BigDecimal(je));
                    saleInvoiceDetail.setUntaxAmt(saleInvoiceDetail.getAmount().subtract(saleInvoiceDetail.getTaxAmt()));
                    saleInvoiceDetail.setTaxRate(new BigDecimal(sl));
                    saleInvoiceDetail.setTaxClassCode("");
                    saleInvoiceDetail.setInspectionId(null);
                    saleInvoiceDetail.setItemNo(null);
                    saleInvoiceDetail.setInvoiceNo(fphm);
                    saleInvoiceDetail.setSaleUnitPrice(saleInvoiceDetail.getAmount().divide(saleInvoiceDetail.getQuantity(), 4));
                    this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                }
            }
            BillApplyInfo billApplyInfo1 = new BillApplyInfo();
            billApplyInfo1.setApplyNo(applyNo);
            billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
            InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
            inquiryPayOrderExt.setApplyNo(applyNo);
            List<InquiryPayOrder> orders = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
            for (InquiryPayOrder order : orders) {
                BigDecimal payMoney = order.getPayMoney();
                BigDecimal taxAmt = payMoney.divide(saleInvoiceInfo.getAmt(), 4, 4).multiply(saleInvoiceInfo.getTaxAmt());
                taxAmt = taxAmt.setScale(2, 4);
                BigDecimal untaxAmt = payMoney.subtract(taxAmt);
                inquiryPayOrderExt = new InquiryPayOrderExt();
                inquiryPayOrderExt.setPayOrderNo(order.getPayOrderNo());
                inquiryPayOrderExt.setOrderStatus(OrderStatus.SEND_BILL.getCode());
                inquiryPayOrderExt.setTaxAmt(taxAmt);
                inquiryPayOrderExt.setUntaxAmt(untaxAmt);
                this.inquiryPayOrderMapper.updateByPrimaryKeySelective(inquiryPayOrderExt);
            }
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
            FscWfStartAtomReqBO req = new FscWfStartAtomReqBO();
            req.setUserId(this.enumsService.querySupplierPayIncomeCalcUserId(billApplyInfo.getOperUnitNo()));
            req.setBillNo(applyNo);
            req.setBillType(WFBillType.SUPPLIER_PAY_INCOME_CALC);
            req.setFinishEvtServiceId("supplierPayIncomeCalcWorkFlowFinishEventImpl");
            FscWfStartAtomRspBO rspBO = null;
            try {
                rspBO = this.fscWfStartAtomService.dealStartApproval(req);
            }
            catch (Exception e) {
                logger.error("\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25\u3002\u5165\u53c2=" + (Object)((Object)req), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25");
            }
            if (!RESP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
                logger.error("\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25\u3002\u5165\u53c2=" + (Object)((Object)req));
                throw new PfscExtBusinessException("18000", "\u53d1\u8d77\u5ba1\u6279\u6d41\u5931\u8d25");
            }
            Element pdfUrlElement = returndata.element("pdfUrl");
            if (null == pdfUrlElement) return;
            String pdfUrl = pdfUrlElement.getText();
            HttpGet httpGet = new HttpGet(pdfUrl);
            String newFileName = null;
            InputStream inputStream = null;
            String electronicInvoiceName = fpdm + "-" + fphm + ".pdf";
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                HttpEntity httpEntity = httpResponse.getEntity();
                if (null != httpEntity) {
                    inputStream = httpEntity.getContent();
                    newFileName = FileProcessing.uploadFileByInputStream((String)electronicInvoiceName, (InputStream)inputStream, (String)"", (String)"PAY", (boolean)false);
                }
            }
            catch (Exception e) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5931\u8d25\u3002", (Throwable)e);
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519", (Throwable)e);
                    }
                }
            }
            if (!StringUtils.hasText(newFileName)) return;
            SaleInvoiceInfo record = new SaleInvoiceInfo();
            record.setInvoiceNo(fphm);
            record.setElectronicInvoiceName(electronicInvoiceName);
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(record);
            return;
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u5408\u529b\u4e2d\u7a0e\u8fd4\u56de\u7684\u7535\u5b50\u53d1\u7968\u4fe1\u606f\u5f02\u5e38", e);
        }
    }
}

