/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.InvoiceReturnApplyRedInvoiceService;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyRedInvoiceAtomReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyRedInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyRedInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.ElectronicInvoiceAtomService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.InvoiceReturnAtomService;
import com.tydic.pfsc.service.atom.UserInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceReturnApplyRedInvoiceServiceImpl
implements InvoiceReturnApplyRedInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnApplyRedInvoiceServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private ElectronicInvoiceAtomService electronicInvoiceAtomService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InvoiceReturnAtomService invoiceReturnAtomService;

    public InvoiceReturnApplyRedInvoiceRspBO process(InvoiceReturnApplyRedInvoiceReqBO reqBO) {
        int maxThreadSize;
        Object vo;
        String billNo;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ea2\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        if (billNos.size() > 1) {
            throw new PfscExtBusinessException("0001", "\u76ee\u524d\u5efa\u8bae\u4e00\u4e2a\u4e00\u4e2a\u7533\u8bf7\u7ea2\u5b57\u53d1\u7968\uff0c\u5f85\u7a0e\u63a7\u7a33\u5b9a\u540e\u6279\u91cf\u64cd\u4f5c");
        }
        InvoiceReturnVO invoiceReturnVO = new InvoiceReturnVO();
        invoiceReturnVO.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(invoiceReturnVO);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            if (!InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) {
                throw new PfscExtBusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
            }
            vo = new InvoiceReturnDetailVO();
            ((InvoiceReturnDetail)vo).setBillNo(billNo);
            List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                BillApplyInfo apply = this.billApplyInfoMapper.selectByPrimaryKey(invoiceReturnDetail.getApplyNo1());
                if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(apply.getInvoiceClasses())) continue;
                throw new PfscExtBusinessException("0001", "\u539f\u7968\u7684\u53d1\u7968\u7c7b\u522b\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceClasses.ELECTRONIC_INVOICE));
            }
        }
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            vo = new InvoiceReturnDetailVO();
            ((InvoiceReturnDetail)vo).setBillNo(billNo);
            ((InvoiceReturnDetailVO)vo).setInvoiceNo2IsNull("1");
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
            if (details.isEmpty()) continue;
            HashMap<String, InvoiceReturnApplyRedInvoiceAtomReqBO> atomReqBOs = new HashMap<String, InvoiceReturnApplyRedInvoiceAtomReqBO>();
            for (InvoiceReturnDetail detail : details) {
                if (atomReqBOs.containsKey(detail.getApplyNo1())) {
                    ((InvoiceReturnApplyRedInvoiceAtomReqBO)atomReqBOs.get(detail.getApplyNo1())).getInvoiceNo1s().add(detail.getInvoiceNo1());
                    continue;
                }
                InvoiceReturnApplyRedInvoiceAtomReqBO atomReqBO = new InvoiceReturnApplyRedInvoiceAtomReqBO();
                atomReqBO.setBillNo(detail.getBillNo());
                atomReqBO.setApplyNo1(detail.getApplyNo1());
                ArrayList<String> invoiceNo1s = new ArrayList<String>();
                invoiceNo1s.add(detail.getInvoiceNo1());
                atomReqBO.setInvoiceNo1s(invoiceNo1s);
                atomReqBO.setUserId(reqBO.getUserId());
                atomReqBOs.put(detail.getApplyNo1(), atomReqBO);
            }
            ArrayList<InvoiceReturnApplyRedInvoiceAtomReqBO> arrayList = new ArrayList<InvoiceReturnApplyRedInvoiceAtomReqBO>(atomReqBOs.values());
            this.electronicInvoiceAtomService.applyRedInvoice(arrayList);
        }
        int size = invoiceReturns.size();
        ExecutorService executorService = Executors.newFixedThreadPool(size > (maxThreadSize = this.enumsService.queryMaxThreadSize()) ? maxThreadSize : size);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            final InvoiceReturnVO invoiceReturnVO2 = new InvoiceReturnVO();
            invoiceReturnVO2.setBillNo(invoiceReturn.getBillNo());
            invoiceReturnVO2.setStatus(InvoiceReturnStatus.RETURNED.getCode());
            invoiceReturnVO2.setProcessUser(this.userInfoService.queryUserNameByUserId(reqBO.getUserId()));
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    InvoiceReturnApplyRedInvoiceServiceImpl.this.invoiceReturnAtomService.updateStatus(invoiceReturnVO2);
                }
            });
        }
        executorService.shutdown();
        InvoiceReturnApplyRedInvoiceRspBO rspBO = new InvoiceReturnApplyRedInvoiceRspBO();
        String msg = "\u6210\u529f\u3002\u5982\u679c\u90e8\u5206\u539f\u7968\u7533\u8bf7\u7ea2\u5b57\u53d1\u7968\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
        rspBO.setMsg(msg);
        return rspBO;
    }
}

