/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.job;

import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.enums.InquiryPayPass;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.service.atom.IAmMasterAppService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PayTimeoutCheckJob {
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public void execute() {
        if (!IAmMasterAppService.isMasterApp()) {
            return;
        }
        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
        inquiryPayOrderExt.setPaymentStatus(InquiryPaymentStatus.IN_PAYMENT.getCode());
        List<InquiryPayOrder> payOrderList = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
        for (InquiryPayOrder inquiryPayOrder : payOrderList) {
            Date begin = inquiryPayOrder.getPayStartTime();
            Date end = new Date();
            long time = (end.getTime() - begin.getTime()) / 1000L / 60L;
            if (!(InquiryPayPass.B2CBANK.getCode().equals(inquiryPayOrder.getPayPass()) && time > 30L || InquiryPayPass.B2CDEBITBANK.getCode().equals(inquiryPayOrder.getPayPass()) && time > 30L) && (!InquiryPayPass.B2BBANK.getCode().equals(inquiryPayOrder.getPayPass()) || time <= 2880L)) continue;
            InquiryPayOrderExt payOrderExt = new InquiryPayOrderExt();
            payOrderExt.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
            payOrderExt.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
            this.inquiryPayOrderMapper.updateState(payOrderExt);
        }
    }
}

