/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.config.FscProperties;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PingAnCustIDService {
    private static final Log LOGGER = LogFactory.getLog(PingAnCustIDService.class);
    private String custID;
    private String directLinkCustID;
    @Autowired
    @Qualifier(value="pinganReq")
    private OrderSequence orderSequence;
    @Autowired
    private FscProperties fscProperties;

    String getCustID() {
        if (StringUtils.isEmpty((Object)this.custID)) {
            this.custID = this.fscProperties.getConfig("accounting.pingan.custID");
        }
        return this.custID;
    }

    public void setCustID(String custID) {
        this.custID = custID;
    }

    public String getDirectLinkCustID() {
        return this.directLinkCustID;
    }

    public void setDirectLinkCustID(String directLinkCustID) {
        this.directLinkCustID = directLinkCustID;
    }

    String genReqSn() {
        String enpCode = this.fscProperties.getConfig("accounting.pingan.custID");
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        String dtFmt = sdf.format(new Date());
        long seqNo = 0L;
        try {
            seqNo = this.orderSequence.nextId();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("\u4ea7\u751f20\u4f4d\u8bf7\u6c42\u6d41\u6c34\u53f7\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        return String.format("%s%s%08d", enpCode, dtFmt, seqNo);
    }
}

