/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoReqBO;
import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoRspBO;
import com.tydic.contract.api.supplier.service.QueryContractSupplierService;
import com.tydic.pfsc.api.busi.BusiAddCreditLineService;
import com.tydic.pfsc.api.busi.BusiApplyPayService;
import com.tydic.pfsc.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfsc.api.busi.bo.ApplyPayBO;
import com.tydic.pfsc.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfsc.dao.ApplyDetailMapper;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.PayableDetailMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.ApplyDetail;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.PayableDetailPO;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.PayableDetailVO;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.PayResultStatus;
import com.tydic.pfsc.enums.PayablePayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.FscWfStartAtomService;
import com.tydic.pfsc.service.atom.PayableService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiApplyPayService"})
public class BusiApplyPayServiceImpl
implements BusiApplyPayService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyPayServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private QueryContractSupplierService queryContractSupplierService;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"applyPay"})
    public BusiApplyPayServiceRspBO applyPay(@RequestBody BusiApplyPayServiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getSupplierName())) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReceiptAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getRecAcctName())) {
            throw new PfscExtBusinessException("18000", "\u6536\u6b3e\u65b9\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new PfscExtBusinessException("18000", "\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPayChannel()) && "1" == reqBO.getPayChannel() && !StringUtils.hasText((String)reqBO.getPayVoucher())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
        logger.info("\u6d41\u6c34\u53f7\uff1a" + payno);
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        List applyPayBOList = reqBO.getApplyPayBOList();
        for (Object applyPayBO : applyPayBOList) {
            if (!StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
        }
        String firstSource = (String)sourceList.get(0);
        for (String source : sourceList) {
            if (firstSource.compareTo(source) == 0) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u4e0d\u80fd\u4e00\u8d77\u6c47\u603b");
        }
        PayableDetailVO payableDetailVO = new PayableDetailVO();
        payableDetailVO.setPayableNos(payableNoList);
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
        Long branchCompany = null;
        Long supplierId = null;
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            if (supplierId == null) {
                supplierId = payableDetailPO.getSupplierId();
            } else if (!supplierId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u4ed8\u6b3e");
            }
            if (branchCompany != null) continue;
            branchCompany = payableDetailPO.getBranchCompany();
        }
        for (PayableDetailPO payableDetailPO : payableDetailPOs) {
            AddCreditLineFscReqBo addCreditLineFscReqBo = new AddCreditLineFscReqBo();
            addCreditLineFscReqBo.setChangeType("3");
            addCreditLineFscReqBo.setChangeInfo(((ApplyPayBO)reqBO.getApplyPayBOList().get(0)).getPayAmt());
            addCreditLineFscReqBo.setPayApplyCode(String.valueOf(payno));
            if (payableDetailPO.getPayableType() == 1) {
                String notificationNo = payableDetailPO.getNotificationNo();
                List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                    addCreditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                    this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
                }
            } else if (payableDetailPO.getPayableType() == 6) {
                String applyNo = payableDetailPO.getApplyNo();
                List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    addCreditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                    this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
                }
            } else if (payableDetailPO.getPayableType() == 2 || payableDetailPO.getPayableType() == 3) {
                addCreditLineFscReqBo.setOrderCode(payableDetailPO.getPurchaseOrderCode());
                this.busiAddCreditLineService.addCreditLine(addCreditLineFscReqBo);
            }
            logger.error("##############################\uff1a" + addCreditLineFscReqBo.toString());
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.CONSULT_PRICE.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
            HashSet<Long> orders = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                orders.add(payableDetailPO.getOrderId());
            }
            if (orders.size() > 1) {
                if (OrderSource.ELECTRIC_AREA.getCode().equals(firstSource) || OrderSource.COAL_AREA.getCode().equals(firstSource) || OrderSource.PRICE_FRAME.getCode().equals(firstSource)) {
                    Object var12_16 = null;
                    for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                        void var12_17;
                        if (!StringUtils.hasText((String)payableDetailPO.getPlaAgreementCode())) {
                            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u7684\u5e94\u4ed8\u8bb0\u5f55\u4e0a\u6ca1\u6709\u8bb0\u5f55\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\uff0c\u4e0d\u80fd\u4ed8\u6b3e");
                        }
                        if (var12_17 == null) {
                            String string = payableDetailPO.getPlaAgreementCode();
                            continue;
                        }
                        if (var12_17.equals(payableDetailPO.getPlaAgreementCode())) continue;
                        throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5408\u540c\u7f16\u53f7\u4e0d\u540c\u7684\u8ba2\u5355\u4e0d\u80fd\u5408\u5e76\u4ed8\u6b3e");
                    }
                } else {
                    BigDecimal bigDecimal = this.enumsService.queryUnionPayAmountLimit();
                }
                ArrayList<Long> arrayList = new ArrayList<Long>(orders);
                payableDetailVO = new PayableDetailVO();
                payableDetailVO.setOrderIdList(arrayList);
                payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
                for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                    String payType = payableDetailPO.getPayType();
                    if (!PayablePayType.PREPAY.getCode().equals(payType)) continue;
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff08\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\uff1a" + payableDetailPO.getPurchaseOrderCode() + "\uff09\u6709" + PayablePayType.getInstance(payType).getDescr() + "\uff0c\u4e0d\u80fd\u548c\u5176\u4ed6\u8ba2\u5355\u5408\u5e76\u4ed8\u6b3e");
                }
            }
        }
        BigDecimal payAmtCount = new BigDecimal(0);
        for (ApplyPayBO applyPayBO : applyPayBOList) {
            payAmtCount = applyPayBO.getPayAmt().add(payAmtCount);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payno.toString());
            applyDetail.setPayableNo(applyPayBO.getPayableNo());
            applyDetail.setOperatorId(reqBO.getUserId());
            applyDetail.setSource(applyPayBO.getSource());
            applyDetail.setSupplierId(reqBO.getSupplierId());
            applyDetail.setStatus(PayResultStatus.PAY_CONFIRMED.getCode());
            applyDetail.setAmt(applyPayBO.getPayAmt());
            applyDetail.setCompanyId(reqBO.getCompanyId());
            this.applyDetailMapper.insert(applyDetail);
            this.payableService.applyForNew(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
        }
        Date date = new Date();
        Long l = payableDetailPOs.get(0).getContractId();
        QueryContractSupplierInfoReqBO queryContractSupplierInfoReqBO = new QueryContractSupplierInfoReqBO();
        queryContractSupplierInfoReqBO.setContractId(l);
        QueryContractSupplierInfoRspBO queryContractSupplierInfoRspBO = this.queryContractSupplierService.queryContratSupplierByContractId(queryContractSupplierInfoReqBO);
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)applyPayInfoPO);
        if (queryContractSupplierInfoRspBO.getCode().equals("0000") && null != queryContractSupplierInfoRspBO.getContractCode()) {
            applyPayInfoPO.setContactNo(queryContractSupplierInfoRspBO.getContractCode());
        }
        applyPayInfoPO.setPayAmt(payAmtCount);
        applyPayInfoPO.setPayno(payno.toString());
        applyPayInfoPO.setSource(firstSource);
        applyPayInfoPO.setApplyDate(date);
        applyPayInfoPO.setOperatorId(reqBO.getUserId());
        applyPayInfoPO.setPayStatus(PayResultStatus.PAY_CONFIRMED.getCode());
        applyPayInfoPO.setBranchCompany(branchCompany);
        applyPayInfoPO.setPayChannel("1");
        applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
        applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
        this.applyPayInfoMapper.insert(applyPayInfoPO);
        BusiApplyPayServiceRspBO rspBO = new BusiApplyPayServiceRspBO();
        return rspBO;
    }
}

