/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryInquiryPayOrderRelateAllInfoService;
import com.tydic.pfsc.api.busi.bo.BusiInquiryPayOrderRelateAllInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiInquiryPayOrderRelateAllInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiInquiryPayOrderRelateDetailInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceReturnInfoRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InquiryApprovalStatus;
import com.tydic.pfsc.enums.InquiryPayPass;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.InvoiceReturnType;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQryInquiryPayOrderRelateAllInfoServiceImpl
implements BusiQryInquiryPayOrderRelateAllInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryInquiryPayOrderRelateAllInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;

    public BusiInquiryPayOrderRelateAllInfoRspBO queryInquiryPayOrderRelateAllInfo(BusiInquiryPayOrderRelateAllInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u8be2\u6bd4\u4ef7\u8ba2\u5355\u76f8\u5173\u8054\u5168\u90e8\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        BeanUtils.copyProperties((Object)reqBO, (Object)payOrderInfoExt);
        payOrderInfoExt.setSortOrder("ORDER_TIME DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.getListByPage(payOrderInfoExt, (Page<Map<String, Object>>)page);
        ArrayList<BusiInquiryPayOrderRelateDetailInfoRspBO> detailInfoRspBOList = new ArrayList<BusiInquiryPayOrderRelateDetailInfoRspBO>();
        BusiInquiryPayOrderRelateDetailInfoRspBO detailInfoRspBO = null;
        for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
            detailInfoRspBO = new BusiInquiryPayOrderRelateDetailInfoRspBO();
            BeanUtils.copyProperties((Object)inquiryPayOrder, (Object)detailInfoRspBO);
            detailInfoRspBO.setSupplierName(this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId()));
            detailInfoRspBO.setPaymentStatusDescr(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(inquiryPayOrder.getPaymentStatus())));
            detailInfoRspBO.setApprovalStatusDescr(this.enumsService.getDescr(InquiryApprovalStatus.getInstance(inquiryPayOrder.getApprovalStatus())));
            detailInfoRspBO.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(inquiryPayOrder.getPayPass())));
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(inquiryPayOrder.getApplyNo());
            ArrayList<BusiInvoiceReturnInfoRspBO> invoiceReturnInfoList = new ArrayList<BusiInvoiceReturnInfoRspBO>();
            if (null != billApplyInfo) {
                detailInfoRspBO.setApplyNo(billApplyInfo.getApplyNo());
                detailInfoRspBO.setApplyDate(billApplyInfo.getApplyDate());
                detailInfoRspBO.setBillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyInfo.getBillStatus())));
                detailInfoRspBO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                detailInfoRspBO.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleInvoiceInfo> allSaleInvoice = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                BusiInvoiceReturnInfoRspBO invoiceReturnInfoRspBO = null;
                for (SaleInvoiceInfo eachSaleInvoice : allSaleInvoice) {
                    invoiceReturnInfoRspBO = new BusiInvoiceReturnInfoRspBO();
                    invoiceReturnInfoRspBO.setInvoiceNo(eachSaleInvoice.getInvoiceNo());
                    InvoiceReturnDetail invoiceReturnDetail = new InvoiceReturnDetail();
                    invoiceReturnDetail.setApplyNo1(billApplyInfo.getApplyNo());
                    invoiceReturnDetail.setInvoiceNo1(eachSaleInvoice.getInvoiceNo());
                    List<InvoiceReturnDetail> invoiceReturnDetailList = this.invoiceReturnDetailMapper.getList(invoiceReturnDetail);
                    if (!CollectionUtils.isEmpty(invoiceReturnDetailList)) {
                        InvoiceReturnDetail firstInvoiceReturnDetail = invoiceReturnDetailList.get(0);
                        invoiceReturnInfoRspBO.setReturnBillNo(firstInvoiceReturnDetail.getBillNo());
                        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(firstInvoiceReturnDetail.getBillNo());
                        invoiceReturnInfoRspBO.setTypeDescr(this.enumsService.getDescr(InvoiceReturnType.getInstance(invoiceReturn.getType())));
                        invoiceReturnInfoRspBO.setReturnStatusDescr(this.enumsService.getDescr(InvoiceReturnStatus.getInstance(invoiceReturn.getStatus())));
                        if (StringUtils.hasText((String)firstInvoiceReturnDetail.getApplyNo3())) {
                            invoiceReturnInfoRspBO.setApplyNo3(firstInvoiceReturnDetail.getApplyNo3());
                            invoiceReturnInfoRspBO.setApplyNo3InvoiceNo(firstInvoiceReturnDetail.getInvoiceNo3());
                            BillApplyInfo billApplyNo3 = this.billApplyInfoMapper.selectByPrimaryKey(firstInvoiceReturnDetail.getApplyNo3());
                            invoiceReturnInfoRspBO.setApplyNo3BillStatusDescr(this.enumsService.getDescr(BillStatus.getInstance(billApplyNo3.getBillStatus())));
                            invoiceReturnInfoRspBO.setApplyNo3InvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyNo3.getInvoiceType()))));
                            invoiceReturnInfoRspBO.setApplyNo3InvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyNo3.getInvoiceClasses())));
                        }
                    }
                    invoiceReturnInfoRspBO.setInvoiceUrl(FileUtils.obtainOSSUrl(eachSaleInvoice.getElectronicInvoiceName()));
                    invoiceReturnInfoRspBO.setElectronicInvoiceName(eachSaleInvoice.getElectronicInvoiceName());
                    invoiceReturnInfoList.add(invoiceReturnInfoRspBO);
                }
            }
            detailInfoRspBO.setInvoiceReturnInfoList(invoiceReturnInfoList);
            detailInfoRspBOList.add(detailInfoRspBO);
        }
        BusiInquiryPayOrderRelateAllInfoRspBO rspBO = new BusiInquiryPayOrderRelateAllInfoRspBO();
        rspBO.setRows(detailInfoRspBOList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

