/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiQryNtfInvoiceDetailDlzqService;
import com.tydic.pfsc.api.busi.bo.BusiQryNtfInvoiceDetailDlzqReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryNtfInvoiceDetailDlzqRspBO;
import com.tydic.pfsc.api.busi.vo.InvoiceDetailVO;
import com.tydic.pfsc.dao.PayInvoiceDetailMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.PayInvoiceDetail;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNtfInvoiceDetailDlzqServiceImpl
implements BusiQryNtfInvoiceDetailDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNtfInvoiceDetailDlzqServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;

    public BusiQryNtfInvoiceDetailDlzqRspBO query(BusiQryNtfInvoiceDetailDlzqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.info("\u67e5\u8be2\u914d\u9001\u7c7b\u4e1a\u52a1\u5f00\u7968\u901a\u77e5\u4e0b\u7684\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u670d\u52a1\u5165\u53c2");
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PayInvoiceInfo> invoiceList = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
        BusiQryNtfInvoiceDetailDlzqRspBO rspBO = new BusiQryNtfInvoiceDetailDlzqRspBO();
        LinkedList<InvoiceDetailVO> detailsOut = new LinkedList<InvoiceDetailVO>();
        rspBO.setDataList(detailsOut);
        if (invoiceList == null || invoiceList.isEmpty()) {
            logger.debug("\u4ed8\u6b3e\u901a\u77e5\u5355\u53f7\u4e3a:" + reqBO.getNotificationNo() + "\u7684\u4ed8\u6b3e\u901a\u77e5\u627e\u4e0d\u5230\u53d1\u7968\u4fe1\u606f");
            return rspBO;
        }
        for (PayInvoiceInfo singleInvoice : invoiceList) {
            List<PayInvoiceDetail> invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(singleInvoice.getInvoiceCode(), singleInvoice.getInvoiceNo(), singleInvoice.getInvoiceDate());
            if (invoiceDetails == null || invoiceDetails.isEmpty()) {
                logger.info("\u67e5\u8be2\u8be5\u53d1\u7968\u5bf9\u5e94\u7684\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a\uff0c\u53d1\u7968\u4fe1\u606f\uff1a" + singleInvoice.getInvoiceCode() + "," + singleInvoice.getInvoiceNo() + "," + singleInvoice.getInvoiceDate());
                return rspBO;
            }
            for (PayInvoiceDetail singleDetail : invoiceDetails) {
                InvoiceDetailVO invoiceDetailOut = new InvoiceDetailVO();
                BeanUtils.copyProperties((Object)singleDetail, (Object)invoiceDetailOut);
                invoiceDetailOut.setOrderId(singleDetail.getOrderId() == null ? "" : String.valueOf(singleDetail.getOrderId()));
                detailsOut.add(invoiceDetailOut);
            }
        }
        rspBO.setDataList(detailsOut);
        return rspBO;
    }
}

