/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.DzcsInvoiceReturnApplyRedInvoiceService;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnApplyRedInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnApplyRedInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.enums.YesNo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.EnumsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.DzcsInvoiceReturnApplyRedInvoiceService"})
public class DzcsInvoiceReturnApplyRedInvoiceServiceImpl
implements DzcsInvoiceReturnApplyRedInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyRedInvoiceServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;

    @PostMapping(value={"process"})
    public DzcsInvoiceReturnApplyRedInvoiceRspBO process(@RequestBody DzcsInvoiceReturnApplyRedInvoiceReqBO reqBO) {
        String billNo;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ea2\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO invoiceReturnVO = new InvoiceReturnVO();
        invoiceReturnVO.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(invoiceReturnVO);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            if (InvoiceReturnStatus.TO_RETURN.getCode().equals(invoiceReturn.getStatus())) continue;
            throw new PfscExtBusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_RETURN));
        }
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            vo.setApplyNo2IsNull("1");
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
            if (details.isEmpty()) continue;
            HashMap applyNo1Map = new HashMap();
            for (InvoiceReturnDetail invoiceReturnDetail : details) {
                if (applyNo1Map.containsKey(invoiceReturnDetail.getApplyNo1())) {
                    ((List)applyNo1Map.get(invoiceReturnDetail.getApplyNo1())).add(invoiceReturnDetail.getInvoiceNo1());
                    continue;
                }
                ArrayList<String> invoiceNo1s = new ArrayList<String>();
                invoiceNo1s.add(invoiceReturnDetail.getInvoiceNo1());
                applyNo1Map.put(invoiceReturnDetail.getApplyNo1(), invoiceNo1s);
            }
            for (Map.Entry entry : applyNo1Map.entrySet()) {
                String applyNo1 = (String)entry.getKey();
                List invoiceNo1s = (List)entry.getValue();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
                List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                if (invoices.size() != invoiceNo1s.size()) {
                    throw new PfscExtBusinessException("0001", "\u539f\u53d1\u7968\u6570\u636e\u6709\u8bef");
                }
                BigDecimal amt = BigDecimal.ZERO;
                for (SaleInvoiceInfo invoice : invoices) {
                    amt = amt.add(invoice.getAmt());
                }
                BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                String applyNo2 = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
                BillApplyInfo billApplyInfo2 = new BillApplyInfo();
                BeanUtils.copyProperties((Object)billApplyInfo1, (Object)billApplyInfo2);
                billApplyInfo2.setApplyNo(applyNo2);
                billApplyInfo2.setApplyDate(new Date());
                billApplyInfo2.setAmt(amt.negate());
                billApplyInfo2.setBillStatus(BillStatus.APPLIED.getCode());
                billApplyInfo2.setUserId(reqBO.getUserId());
                billApplyInfo2.setReturnBillNo(billNo);
                billApplyInfo2.setRedBlue(RedBlue.RED.getCode());
                billApplyInfo2.setUrgedInvoice(YesNo.NO.getCode());
                billApplyInfo2.setRemark(null);
                this.billApplyInfoMapper.insert(billApplyInfo2);
                InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                whereRecord.setBillNo(billNo);
                whereRecord.setApplyNo1(applyNo1);
                InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                valueRecord.setApplyNo2(applyNo2);
                this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            }
            invoiceReturn = new InvoiceReturn();
            invoiceReturn.setBillNo(billNo);
            invoiceReturn.setStatus(InvoiceReturnStatus.RETURNING.getCode());
            this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        }
        DzcsInvoiceReturnApplyRedInvoiceRspBO rspBO = new DzcsInvoiceReturnApplyRedInvoiceRspBO();
        return rspBO;
    }
}

