/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.tydic.pfsc.api.deal.BusiPayItemService;
import com.tydic.pfsc.api.deal.bo.BusiPayItemReqBO;
import com.tydic.pfsc.api.deal.bo.BusiPayItemRspBO;
import com.tydic.pfsc.api.deal.bo.PayItemInfoBO;
import com.tydic.pfsc.api.deal.bo.PayItemInfoExtBO;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.vo.PayItemInfoExt;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.BusiPayItemService"})
public class BusiPayItemServiceImpl
implements BusiPayItemService {
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    @PostMapping(value={"selectListByNotificationNo"})
    public BusiPayItemRspBO selectListByNotificationNo(@RequestBody BusiPayItemReqBO busiPayItemReqBO) {
        if (null == busiPayItemReqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String notificationNo = busiPayItemReqBO.getNotificationNo();
        ArrayList<PayItemInfoExtBO> boList = new ArrayList<PayItemInfoExtBO>();
        List<PayItemInfoExt> list = this.payItemInfoMapper.selectListByNotificationNo(notificationNo);
        for (PayItemInfoExt payItemInfoExt : list) {
            PayItemInfoExtBO bo = new PayItemInfoExtBO();
            BeanUtils.copyProperties((Object)payItemInfoExt, (Object)bo);
            boList.add(bo);
        }
        BusiPayItemRspBO busiPayItemRspBO = new BusiPayItemRspBO();
        busiPayItemRspBO.setPayItemInfoExtBOs(boList);
        return busiPayItemRspBO;
    }

    @PostMapping(value={"selectByNotifNo"})
    public BusiPayItemRspBO selectByNotifNo(@RequestBody BusiPayItemReqBO busiPayItemReqBO) {
        if (null == busiPayItemReqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String notificationNo = busiPayItemReqBO.getNotificationNo();
        ArrayList<PayItemInfoBO> boList = new ArrayList<PayItemInfoBO>();
        List<PayItemInfo> infoList = this.payItemInfoMapper.selectByNotifNo(notificationNo);
        if (null != infoList && infoList.size() > 0) {
            for (PayItemInfo payItemInfo : infoList) {
                PayItemInfoBO bo = new PayItemInfoBO();
                BeanUtils.copyProperties((Object)payItemInfo, (Object)bo);
                boList.add(bo);
            }
        }
        BusiPayItemRspBO busiPayItemRspBO = new BusiPayItemRspBO();
        busiPayItemRspBO.setPayItemInfoBOs(boList);
        return busiPayItemRspBO;
    }
}

