/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.zm.impl;

import com.ohaotian.authority.user.service.SelectByOrgAndRoleWebService;
import com.tydic.pfsc.api.zm.GenerateBillsService;
import com.tydic.pfsc.api.zm.bo.AddBillReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.RoleConfigMapper;
import com.tydic.pfsc.dao.SaleBillInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.SaleBillInfoPO;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BillStatus1;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListAbilityReqBO;
import com.tydic.umcext.bo.base.UmcRspListBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.zm.GenerateBillsService"})
public class GenerateBillsServiceImpl
implements GenerateBillsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateBillsServiceImpl.class);
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private SelectByOrgAndRoleWebService selectByOrgAndRoleWebService;
    @Autowired
    private RoleConfigMapper roleConfigMapper;

    @PostMapping(value={"generateBills"})
    public PfscExtRspBaseBO generateBills(@RequestBody AddBillReqBO reqBo) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        if (null == reqBo) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBo.getPurchaseNos()) {
            throw new PfscExtBusinessException("0001", "\u5f53\u65e5\u65e0\u91c7\u8d2d\u5355\u4f4d\u9700\u8981\u751f\u6210\u8d26\u5355");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        Calendar calendar1 = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - 1, 23, 59, 59);
        long tt = calendar.getTime().getTime();
        if (calendar.get(2) + 1 == 1) {
            calendar1.set(calendar1.get(1) - 1, 11, calendar1.get(5), 0, 0, 0);
        } else {
            calendar1.set(calendar.get(1), calendar1.get(2) - 1, calendar1.get(5), 0, 0, 0);
        }
        long tt1 = calendar1.getTime().getTime();
        Date end = new Date(tt);
        Date start = new Date(tt1);
        Long account = 0L;
        for (Long purchaseNo : reqBo.getPurchaseNos()) {
            UmcQryEnterpriseAccountListAbilityReqBO umcQryUpOrgAccountAbilityReqBO = new UmcQryEnterpriseAccountListAbilityReqBO();
            umcQryUpOrgAccountAbilityReqBO.setOrgIdWeb(purchaseNo);
            umcQryUpOrgAccountAbilityReqBO.setQueryType("00");
            LOGGER.error("\u67e5\u8be2\u91c7\u8d2d\u5355\u4f4d\u4e0b\u7684\u6240\u6709\u8d26\u5957\u5165\u53c2" + umcQryUpOrgAccountAbilityReqBO.getQueryType() + umcQryUpOrgAccountAbilityReqBO.getOrgIdWeb());
            UmcRspListBO um = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountAll(umcQryUpOrgAccountAbilityReqBO);
            if (null != um) {
                if (null != um.getRows() && um.getRows().size() > 0) {
                    for (UmcEnterpriseAccountAbilityBO umcQryUpOrgAccountAbilityRspBO : um.getRows()) {
                        account = umcQryUpOrgAccountAbilityRspBO.getAccountId();
                        LOGGER.error("\u8981\u67e5\u8be2\u7684\u8d26\u5957ID" + account);
                        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                        saleOrderInfoVO.setPurchaseProjectId(account);
                        saleOrderInfoVO.setEndRecvDate(end);
                        saleOrderInfoVO.setBeginRecvDate(start);
                        LOGGER.error("\u5f00\u59cb\u67e5\u8be2\u8ba2\u5355" + saleOrderInfoVO.toString());
                        List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getOrderByAccountMonth(saleOrderInfoVO);
                        if (null == saleOrderInfos || saleOrderInfos.size() <= 0) continue;
                        this.insertBill(saleOrderInfos, account, purchaseNo);
                    }
                    pfscExtRspBaseBO.setRespCode("\u6210\u529f");
                    pfscExtRspBaseBO.setRespDesc("\u65b0\u589e\u6210\u529f");
                    continue;
                }
                pfscExtRspBaseBO.setRespCode("\u5931\u8d25");
                pfscExtRspBaseBO.setRespDesc("\u67e5\u8be2\u8d26\u5957\u4e3a\u7a7a");
                continue;
            }
            pfscExtRspBaseBO.setRespCode("\u5931\u8d25");
            pfscExtRspBaseBO.setRespDesc("\u67e5\u8be2\u8d26\u5957\u4e3a\u7a7a");
        }
        return pfscExtRspBaseBO;
    }

    public void insertBill(List<SaleOrderInfo> saleOrderInfos, Long account, Long purchaseNo) {
        BigDecimal billMoney = BigDecimal.ZERO;
        LOGGER.error("\u8ba2\u5355\u5217\u8868" + saleOrderInfos.toString());
        for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
            billMoney = billMoney.add(saleOrderInfo.getOrderAmt());
        }
        LOGGER.error("\u91d1\u989d" + billMoney);
        String billNo = this.insertBillNo(account, purchaseNo);
        SaleBillInfoPO saleBillInfoPO = new SaleBillInfoPO();
        saleBillInfoPO.setBillNo(billNo);
        saleBillInfoPO.setBillDate(new Date());
        saleBillInfoPO.setBillMoney(billMoney);
        saleBillInfoPO.setBillStatus(BillStatus1.NO_APPLY.getCode());
        saleBillInfoPO.setOrderNum(Long.valueOf(saleOrderInfos.size()));
        saleBillInfoPO.setPurchaseNo(String.valueOf(saleOrderInfos.get(0).getPurchaseNo()));
        saleBillInfoPO.setPurchaseName(saleOrderInfos.get(0).getPurchaseName());
        saleBillInfoPO.setPurchaseProjectId(String.valueOf(account));
        LOGGER.error("\u5f00\u59cb\u65b0\u589e\u8d26\u5355" + saleBillInfoPO.toString());
        int num = this.saleBillInfoMapper.insertSelective(saleBillInfoPO);
        if (num == 1) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                LOGGER.error("\u5f00\u59cb\u66f4\u65b0\u8ba2\u5355\u72b6\u6001");
                this.saleOrderInfoMapper.updateBillNoByPrimaryKey(saleOrderInfo.getOrderId(), saleOrderInfo.getInspectionId(), billNo);
            }
        }
    }

    public String insertBillNo(Long account, Long purchaseNo) {
        Calendar calendar = Calendar.getInstance();
        String month = String.valueOf(calendar.get(2) + 1);
        if (calendar.get(2) < 10) {
            month = "0" + month;
        }
        String day = String.valueOf(calendar.get(5));
        if (calendar.get(5) < 10) {
            day = "0" + day;
        }
        String sun = String.valueOf(calendar.get(1)) + month + day;
        UmcQryEnterpriseAccountDetailAbilityReqBO um = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        um.setAccountId(account);
        UmcQryEnterpriseAccountDetailAbilityRspBO umcQryEnterpriseAccountDetailAbilityRspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(um);
        String billNo = purchaseNo + umcQryEnterpriseAccountDetailAbilityRspBO.getUmcEnterpriseAccountBO().getAccountCode() + sun;
        return billNo;
    }
}

