/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.constants.FscCommonConstants;
import com.tydic.pfsc.dao.WorkFlowDataMapper;
import com.tydic.pfsc.dao.WorkFlowParamMapper;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.po.WorkFlowParamInfo;
import com.tydic.pfsc.enums.WFStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.FscWfStartAtomService;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomReqBO;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomRspBO;
import com.tydic.pfsc.utils.FscCommonUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscWFStartAtomService")
public class FscWfStartAtomServiceImpl
implements FscWfStartAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfStartAtomServiceImpl.class);
    private WorkFlowParamMapper workFlowParamMapper;
    private WorkFlowDataMapper workFlowDataMapper;
    @Value(value="${AUDIT_TACHE_CODE}")
    private String tacheCode;
    @Value(value="${AUDIT_DEPT_ID}")
    private String deptId;
    @Value(value="${AUDIT_ROLE_ID}")
    private String roleId;

    @Override
    public FscWfStartAtomRspBO dealStartApproval(FscWfStartAtomReqBO reqBO) {
        FscWfStartAtomRspBO rspBO = new FscWfStartAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        WorkFlowParamInfo workFlowParamInfo = new WorkFlowParamInfo();
        workFlowParamInfo.setBillType(reqBO.getBillType().getCode());
        WorkFlowParamInfo paramInfo = this.workFlowParamMapper.getModelBy(workFlowParamInfo);
        if (null == paramInfo) {
            LOGGER.info("\u5de5\u4f5c\u6d41\u53c2\u6570\u8868\u65e0\u5355\u636e\u7c7b\u578b" + (Object)((Object)reqBO.getBillType()) + "\u76f8\u5e94\u7684\u6570\u636e\u8bb0\u5f55");
            throw new PfscExtBusinessException("18001", "\u5de5\u4f5c\u6d41\u53c2\u6570\u8868\u672a\u914d\u7f6e\u6d41\u7a0b\u53c2\u6570");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u6d41\u7a0b\u542f\u52a8\u6210\u529f");
        return rspBO;
    }

    private void insertWorkFlowData(FscWfStartAtomReqBO reqBO, Long orderId) {
        Date date = new Date();
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setProcInstId(FscCommonUtils.long2String((Long)orderId));
        workFlowDataInfo.setBillType(reqBO.getBillType().getCode());
        workFlowDataInfo.setBillNo(reqBO.getBillNo());
        workFlowDataInfo.setReceiveDate(date);
        workFlowDataInfo.setLastOperator(reqBO.getUserId());
        workFlowDataInfo.setStatus(WFStatus.IN_THE_AUDIT.getCode());
        workFlowDataInfo.setFinishEvtService(reqBO.getFinishEvtServiceId());
        workFlowDataInfo.setTryCount(FscCommonConstants.APPROVAL_TRY_COUNT);
        workFlowDataInfo.setApplyDate(date);
        this.workFlowDataMapper.insert(workFlowDataInfo);
    }

    private String validateArg(FscWfStartAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBO.getBillNo())) {
            return "\u5355\u636e\u7f16\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getBillType()) {
            return "\u5355\u636e\u7c7b\u578b[billType]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

