/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryBackMoneyByNotificationNoService;
import com.tydic.pfsc.api.busi.bo.BusiBackMoney;
import com.tydic.pfsc.api.busi.bo.BusiQryBackMoneyByNotificationNoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryBackMoneyByNotificationNoRspBO;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BusiBackMoneyPO;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.utils.AmountUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQryBackMoneyByNotificationNoService"})
public class BusiQryBackMoneyByNotificationNoServiceImpl
implements BusiQryBackMoneyByNotificationNoService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"qryBackMoneyByNotificationNo"})
    public BusiQryBackMoneyByNotificationNoRspBO qryBackMoneyByNotificationNo(@RequestBody BusiQryBackMoneyByNotificationNoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiQryBackMoneyByNotificationNoRspBO rspBO = new BusiQryBackMoneyByNotificationNoRspBO();
        rspBO.setNotificationNo(reqBO.getNotificationNo());
        ArrayList<BusiBackMoney> backMonies = new ArrayList<BusiBackMoney>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<BusiBackMoneyPO> moneyPOS = this.saleOrderInfoMapper.getListPageForBackMoney(reqBO.getNotificationNo(), (Page<Map<String, Object>>)page);
        if (!CollectionUtils.isEmpty(moneyPOS)) {
            BigDecimal receiptAmt = new BigDecimal(0);
            String receiptProp = null;
            BigDecimal realAmt = new BigDecimal(0);
            for (BusiBackMoneyPO po : moneyPOS) {
                BusiBackMoney busiBackMoney = new BusiBackMoney();
                BeanUtils.copyProperties((Object)po, (Object)busiBackMoney);
                backMonies.add(busiBackMoney);
                rspBO.setSupplierName(po.getSupplierName());
                if (StringUtils.isNotEmpty((String)po.getPayStatus()) && "02".equals(po.getPayStatus())) {
                    realAmt.add(po.getOrderAmt());
                }
                receiptAmt.add(po.getOrderAmt());
            }
            receiptProp = AmountUtils.calcTaxRateEndWithPercentage(realAmt, receiptAmt);
            rspBO.setReceiptProp(receiptProp);
            rspBO.setRealAmt(realAmt);
            rspBO.setReceiptAmt(receiptAmt);
        }
        rspBO.setRows(backMonies);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

