/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    public static Date strToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(strDate, pos);
        return date;
    }

    public static Date strToDateLong(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date strToDateLong(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static Date strToDateyyyyMMddHHmmss(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(YYYYMMDDHHMMSS);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.dateToStrLong(DateUtil.strToDateLong("20161021230956", YYYYMMDDHHMMSS)));
        System.out.println(DateUtil.getCurrentMaxDate("2016-10-27 23:59:57"));
    }

    public static String dateToStrLong(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dateToStrYYYYMMdd(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dateToMonthDay(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static Date strToDate(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String getTimeShort() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date currentTime = new Date();
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String dateToStr(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static String strTostr(String str, String newPattern, String oldPattern) {
        Date date = DateUtil.strToDate(str, oldPattern);
        String newStr = DateUtil.dateToStr(date, newPattern);
        return newStr;
    }

    public static Date getDate(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (days != null) {
            calendar.add(5, days);
        }
        return calendar.getTime();
    }

    public static boolean isValidDate(String dateStr, String datePattern) {
        if (!StringUtils.isBlank((CharSequence)dateStr) && !StringUtils.isBlank((CharSequence)datePattern)) {
            boolean convertSuccess = true;
            SimpleDateFormat format = new SimpleDateFormat(datePattern);
            try {
                format.setLenient(false);
                format.parse(dateStr);
            }
            catch (ParseException var5) {
                convertSuccess = false;
            }
            return convertSuccess;
        }
        return false;
    }

    public static String getCurrentMaxDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(date, pos);
        String dateString = formatter.format(strtodate) + " 23:59:59";
        return dateString;
    }

    public static String getCurrentMinDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(date, pos);
        String dateString = formatter.format(strtodate) + " 00:00:00";
        return dateString;
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }
}

