/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.api.busi.bo.DownloadElectronicInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceReturnApplyRedInvoiceAtomReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.SmsService;
import com.tydic.pfsc.service.atom.bo.BusiApplyElectronicInvoiceExtRspBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ElectronicInvoiceAtomService {
    private static final Logger logger = LoggerFactory.getLogger(ElectronicInvoiceAtomService.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private SmsService smsService;
    @Value(value="${PORTAL_ETHERNET_URL}")
    private String portalEthernetUrl;
    @Value(value="${PERFORM_NOTIC_URL}")
    private String shopUrl;
    private static final int ERR_MSG_MAX_LENGTH = 150;
    private static final int HTTP_SUCCESS = 200;

    private String getShopUrl() {
        return this.shopUrl.replace("http://", "").replace("https://", "");
    }

    public PfscExtRspBaseBO applyBlueInvoice(List<String> applyNos) {
        return null;
    }

    public BusiApplyElectronicInvoiceExtRspBO applyBlueInvoice(String applyNo, boolean isSendMessage) {
        return null;
    }

    public void applyRedInvoice(List<InvoiceReturnApplyRedInvoiceAtomReqBO> reqBOs) {
    }

    public String applyRedInvoice(InvoiceReturnApplyRedInvoiceAtomReqBO reqBO) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadElectronicInvoice(DownloadElectronicInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e0b\u8f7d\u7535\u5b50\u53d1\u7968\u5165\u53c2\uff1a" + reqBO);
        }
        boolean success = false;
        String downloadUrl = reqBO.getDownloadUrl();
        String ossFilename = reqBO.getOssFilename();
        if (!StringUtils.hasText((String)downloadUrl)) {
            logger.error("\u7535\u5b50\u53d1\u7968\u7684\u4e0b\u8f7d\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            return success;
        }
        if (!StringUtils.hasText((String)ossFilename)) {
            logger.error("\u7535\u5b50\u53d1\u7968\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return success;
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String url = this.portalEthernetUrl + "/rest/download/downloadElectronicInvoiceController";
        logger.debug("\u63a7\u5236\u5668\u5730\u5740\uff1a" + url);
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("downloadUrl", downloadUrl));
        params.add(new BasicNameValuePair("ossFilename", ossFilename));
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject jsonResult;
            String respCode;
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            logger.debug("\u8fd4\u56de\u72b6\u6001\uff1a" + httpResponse.getStatusLine().getStatusCode());
            String result = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            logger.debug("\u8fd4\u56de\u62a5\u6587\uff1a" + result);
            if (httpResponse.getStatusLine().getStatusCode() == 200 && "0000".equals(respCode = (String)(jsonResult = JSONObject.fromObject((Object)result)).get("respCode"))) {
                success = true;
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a7\u5236\u5668\u5931\u8d25\u3002\u5165\u53c2\uff1a" + reqBO, (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edhttp\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return success;
    }

    private void recordErrorLog(String applyNo, String errorMsg) {
        BillApplyInfo record = new BillApplyInfo();
        record.setApplyNo(applyNo);
        if (errorMsg.length() > 150) {
            errorMsg = errorMsg.substring(0, 150);
        }
        record.setRemark(errorMsg);
        this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
    }

    class ApplyRedInvoiceRunnable
    implements Runnable {
        private final CountDownLatch latch;
        private final InvoiceReturnApplyRedInvoiceAtomReqBO reqBO;

        public ApplyRedInvoiceRunnable(CountDownLatch latch, InvoiceReturnApplyRedInvoiceAtomReqBO reqBO) {
            this.latch = latch;
            this.reqBO = reqBO;
        }

        @Override
        public void run() {
            try {
                ElectronicInvoiceAtomService.this.applyRedInvoice(this.reqBO);
            }
            catch (Exception e) {
                logger.error("\u7533\u8bf7\u7ea2\u5b57\u53d1\u7968\u5931\u8d25\u3002\u5165\u53c2\uff1a" + this.reqBO, (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u7533\u8bf7\u7ea2\u5b57\u53d1\u7968\u5931\u8d25");
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    class TaskRunnable
    implements Runnable {
        private final CountDownLatch latch;
        private final boolean isSendMessage;
        private final String applyNo;

        public TaskRunnable(CountDownLatch latch, boolean isSendMessage, String applyNo) {
            this.latch = latch;
            this.isSendMessage = isSendMessage;
            this.applyNo = applyNo;
        }

        @Override
        public void run() {
            try {
                ElectronicInvoiceAtomService.this.applyBlueInvoice(this.applyNo, this.isSendMessage);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355" + this.applyNo + "\u5f00\u5177\u7535\u5b50\u53d1\u7968\u51fa\u9519");
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

