/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.RecAmtConfirmMapper;
import com.tydic.pfsc.dao.RecvAbleInfoMapper;
import com.tydic.pfsc.dao.RecvAmtDetailMapper;
import com.tydic.pfsc.dao.po.RecAmtConfirm;
import com.tydic.pfsc.dao.po.RecvAbleInfo;
import com.tydic.pfsc.dao.po.RecvAmtDetail;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.BusinessType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.RecAmtConfirmStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvType;
import com.tydic.pfsc.service.atom.AccountantEngineService;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.SequenceNoService;
import com.tydic.pfsc.service.atom.SourceMappingService;
import com.tydic.pfsc.service.atom.bo.AccountantEngineReqBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="receivableService")
public class ReceivableService {
    private static final Logger logger = LoggerFactory.getLogger(ReceivableService.class);
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired(required=false)
    private AccountantEngineService accountantEngineService;
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;

    private void receivableAccountBook(String saleOrderCode, String purchaseAcctNo, BigDecimal amount, Long operUnitNo, String remark, String source) {
        AccountantEngineReqBO accBo = new AccountantEngineReqBO();
        accBo.setBusinessType(BusinessType.ORDER_PAY.getCode());
        accBo.setSource(source);
        accBo.setClientAcctNo(purchaseAcctNo);
        accBo.setOperUnit(operUnitNo);
        accBo.setServiceNo(saleOrderCode);
        accBo.setRemark(remark);
        accBo.setAmounts(Collections.singletonList(amount));
        this.accountantEngineService.executeAccountantEngine(accBo);
    }

    public RecvAbleInfo createPreReceivableBill(Long saleOrderId, String saleOrderCode, Long operUnitNo, Long purchaseNo, Long projectId, Long supNo, BigDecimal recvAmt, String payAcctNo, String recvAcctNo, Long recConfirDocNum, Long oprLoginId, String source) {
        RecvAbleInfo recv = new RecvAbleInfo();
        recv.setRecvType(RecvAbleInfoRecvType.ADVANCE_RECV.getCode());
        recv.setRecvStatus(RecvAbleInfoRecvStatus.RECEIVED.getCode());
        recv.setSource(source);
        recv.setSupplierNo(supNo);
        recv.setOperUnitNo(operUnitNo);
        recv.setPurchaseNo(purchaseNo);
        recv.setOrderId(saleOrderId);
        recv.setSaleOrderCode(saleOrderCode);
        recv.setPurchaseProjectId(projectId);
        recv.setRecvableAmt(recvAmt);
        recv.setNeedAgainstAmt(recvAmt);
        recv.setCreateDate(new Date());
        recv.setWriteoffAmt(BigDecimal.ZERO);
        this.createReceivable(recv);
        this.createRecvDetail(recv, payAcctNo, recvAcctNo, recConfirDocNum, oprLoginId);
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(source);
        this.receivableAccountBook(saleOrderCode, payAcctNo, recvAmt, operUnitNo, "\u9500\u552e\u8ba2\u5355\u9884\u6536\u6838\u9500", targetSource);
        return recv;
    }

    private void createReceivable(RecvAbleInfo recv) {
        recv.setCreateDate(new Date());
        String sn = this.billSNService.getSnAsString(BillType.RECVABLE_ACCOUNT);
        recv.setRecvableNo(sn);
        this.recvAbleInfoMapper.insert(recv);
        logger.info("\u4ea7\u751f\u5e94\u6536\u5355\u6210\u529f,\u5e94\u6536\u5355\u53f7=" + recv.getRecvableNo() + ",\u91d1\u989d=" + recv.getRecvableAmt());
    }

    private List<RecvAmtDetail> createRecvDetail(RecvAbleInfo recvable, String paySubAcctNo, String recvAcctNo, Long docNum, Long oprLoginId) {
        return null;
    }

    public RecAmtConfirm createReceiveConfirm(Integer detailCount, BigDecimal totalAmt, String remark, Long operUnitNo, Long oprLoginId, OrderSource source) {
        Long docNum = Long.valueOf(this.recAmtConfirmSeqNoService.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date())));
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setSumCount(detailCount);
        recAmtConfirm.setSumAmt(totalAmt);
        recAmtConfirm.setOrgId(operUnitNo);
        recAmtConfirm.setLoginId(oprLoginId);
        recAmtConfirm.setRemark(remark);
        recAmtConfirm.setCreateDate(new Date());
        recAmtConfirm.setStatus(RecAmtConfirmStatus.VALID.getCode());
        recAmtConfirm.setSource(source.getCode());
        this.recAmtConfirmMapper.insert(recAmtConfirm);
        return recAmtConfirm;
    }
}

