/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiExportOutstockTotalService;
import com.tydic.pfsc.api.busi.FscQryAuditDetailBusiService;
import com.tydic.pfsc.api.busi.bo.AuditLogDetailBO;
import com.tydic.pfsc.api.busi.bo.BusiExportCostRowOutstockTotalRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportHeadOutstockTotalRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportOutstockTotalReqBO;
import com.tydic.pfsc.api.busi.bo.BusiExportOutstockTotalRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportRevRowOutstockTotalRspBO;
import com.tydic.pfsc.api.busi.bo.FscQryAuditDetailBusiReqBO;
import com.tydic.pfsc.api.busi.bo.FscQryAuditDetailBusiRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.OutstockTotalMapper;
import com.tydic.pfsc.dao.PurchaseUnitInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.WorkFlowDataMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.OutstockDetail;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.OutstockTotal;
import com.tydic.pfsc.dao.po.PurchaseUnitInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.OutstockInfoVO;
import com.tydic.pfsc.dao.vo.OutstockTotalVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.YuanGuangType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.QueryDictKeyValueService;
import com.tydic.pfsc.service.atom.SourceMappingService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.AmountUtils;
import com.tydic.pfsc.utils.BeanUtils;
import com.tydic.pfsc.utils.ContactUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportOutstockTotalServiceImpl
implements BusiExportOutstockTotalService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportOutstockTotalServiceImpl.class);
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private PurchaseUnitInfoMapper purchaseUnitInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private QueryDictKeyValueService queryDictKeyValueService;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private FscQryAuditDetailBusiService fscQryAuditDetailBusiService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;

    public BusiExportOutstockTotalRspBO exportOutstockTotal(BusiExportOutstockTotalReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u51fa\u5e93\u6c47\u603b\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        BusiExportOutstockTotalRspBO rspBO = new BusiExportOutstockTotalRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTotalNo() == null) {
            throw new PfscExtBusinessException("0001", "\u51fa\u5e93\u6c47\u603b\u5355\u53f7[totalNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutstockTotal outstockTotal1 = this.outstockTotalMapper.selectByPrimaryKey(reqBO.getTotalNo());
        String targetSource = this.sourceMappingService.queryYuanguangTargetSource(outstockTotal1.getSource());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumProductCost = BigDecimal.ZERO;
        LinkedList<BusiExportRevRowOutstockTotalRspBO> revRows = new LinkedList<BusiExportRevRowOutstockTotalRspBO>();
        LinkedList<BusiExportCostRowOutstockTotalRspBO> costRows = new LinkedList<BusiExportCostRowOutstockTotalRspBO>();
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        outstockInfoVO.setTotalNo(reqBO.getTotalNo());
        List<OutstockInfo> list = this.outstockInfoMapper.selectByCondition(outstockInfoVO);
        for (OutstockInfo outstockInfo : list) {
            BusiExportRevRowOutstockTotalRspBO revRow = new BusiExportRevRowOutstockTotalRspBO();
            revRow.setTaxAmt(AmountUtils.format(outstockInfo.getTaxAmt()));
            revRow.setUntaxAmt(AmountUtils.format(outstockInfo.getUntaxAmt()));
            Long projectId = this.organizationInfoService.queryParentAccountId(outstockInfo.getPurchaseProjectId());
            PurchaseUnitInfo purchaseUnitInfo = this.purchaseUnitInfoMapper.selectByPrimaryKey(projectId);
            String companyName = "";
            companyName = purchaseUnitInfo != null ? purchaseUnitInfo.getPurchaseProjectName() : this.organizationInfoService.queryProjectName(projectId).getAccountName();
            String xshth = "";
            BigDecimal amt = null;
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfo.getSource())) {
                if (purchaseUnitInfo == null) {
                    String projectName = this.organizationInfoService.queryProjectName(outstockInfo.getPurchaseProjectId()).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u8fdc\u5149\u8d22\u52a1\u91c7\u8d2d\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u914d\u7f6e");
                    throw new PfscExtBusinessException("18001", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u8fdc\u5149\u8d22\u52a1\u91c7\u8d2d\u5355\u4f4d\u4fe1\u606f\uff0c\u8bf7\u914d\u7f6e");
                }
                amt = BigDecimal.ZERO;
                revRow.setAmt(AmountUtils.format(amt));
                xshth = purchaseUnitInfo.getSaleContactNo();
                revRow.setContractCode(xshth);
                revRow.setAdvanceAccount(AmountUtils.format(outstockInfo.getAmount()));
            } else {
                amt = outstockInfo.getAmount().subtract(outstockInfo.getWriteoffAmt());
                revRow.setAmt(AmountUtils.format(amt));
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNo(outstockInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(saleItemInfoVO);
                xshth = ContactUtils.obtainXshthDlzq(saleItemInfoList.get(0).getSaleOrderCode());
                revRow.setContractCode(xshth);
                revRow.setAdvanceAccount(AmountUtils.format(BigDecimal.ZERO));
            }
            revRow.setContent("\u5e94\u6536" + companyName + "\u300a\u9500\u552e\u5408\u540c\u300b" + revRow.getContractCode() + "\u7269\u8d44\u6b3e");
            revRow.setUnit(companyName);
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(outstockInfo.getApplyNo());
            revRow.setBankName(billApplyInfo.getBankName());
            revRow.setBankAcctNo(billApplyInfo.getBankAcctNo());
            revRow.setTaxNo(billApplyInfo.getTaxNo());
            revRow.setAddr(billApplyInfo.getAddr());
            Map<String, String> map = this.queryDictKeyValueService.queryDictKeyValue(targetSource, YuanGuangType.OUT_REVENUE_SHEET.getCode());
            revRow.setBusinessMatters(map.get("\u4e1a\u52a1\u4e8b\u9879"));
            revRow.setTaxPercent(this.enumsService.queryDefaultTaxRate());
            revRow.setPreAccountBalance(AmountUtils.format(BigDecimal.ZERO));
            revRow.setMarginDeduction(AmountUtils.format(BigDecimal.ZERO));
            sumTaxAmt = sumTaxAmt.add(outstockInfo.getTaxAmt());
            sumUntaxAmt = sumUntaxAmt.add(outstockInfo.getUntaxAmt());
            sumAmt = sumAmt.add(amt);
            List<OutstockDetail> list1 = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
            if (list1 == null || list1.isEmpty()) {
                logger.info("\u6839\u636e\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo() + "\u67e5\u8be2\u51fa\u5e93\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
                throw new PfscExtBusinessException("18001", "\u6839\u636e\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo() + "\u67e5\u8be2\u51fa\u5e93\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            }
            for (OutstockDetail outstockDetail : list1) {
                BusiExportCostRowOutstockTotalRspBO costRow = new BusiExportCostRowOutstockTotalRspBO();
                StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
                if (stocksDetail != null && stocksDetail.getUntaxAmt() != null) {
                    BigDecimal costAmount = stocksDetail.getUntaxAmt();
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                        saleItemInfoVO.setInspectionId(outstockDetail.getInspectionId());
                        saleItemInfoVO.setItemNo(outstockDetail.getItemNo());
                        saleItemInfoVO.setApplyNo(outstockInfo.getApplyNo());
                        List<SaleItemInfo> itemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(saleItemInfoVO);
                        if (!CollectionUtils.isEmpty(itemInfoList)) {
                            SaleItemInfo saleItemInfo = itemInfoList.get(0);
                            costAmount = costAmount.multiply(outstockDetail.getQuantity()).divide(saleItemInfo.getQuantity(), 2, 4);
                        }
                    }
                    costRow.setProductCost(AmountUtils.format(costAmount));
                    sumProductCost = sumProductCost.add(costAmount);
                }
                costRow.setUnit(outstockDetail.getUnitName());
                costRow.setQuantity(AmountUtils.format(outstockDetail.getQuantity()));
                costRow.setPerunitCost(AmountUtils.format(outstockDetail.getUntaxAmt().divide(outstockDetail.getQuantity(), 2, 4)));
                costRow.setContent("\u7ed3\u8f6c" + companyName + "\u300a\u9500\u552e\u5408\u540c\u300b" + xshth + "\u7269\u8d44\u6210\u672c");
                map = this.queryDictKeyValueService.queryDictKeyValue(targetSource, YuanGuangType.OUT_INVENTORY_STATEMENT.getCode());
                costRow.setProductCategories(map.get("\u5546\u54c1\u79cd\u7c7b"));
                costRow.setStorehouse(map.get("\u4ed3\u5e93"));
                costRow.setBusinessMatters(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                BeanUtils.null2DefaultValue(costRow);
                costRows.add(costRow);
            }
            BeanUtils.null2DefaultValue(revRow);
            revRows.add(revRow);
        }
        rspBO.setRevRows(revRows);
        rspBO.setCostRows(costRows);
        BusiExportHeadOutstockTotalRspBO head = new BusiExportHeadOutstockTotalRspBO();
        OutstockTotalVO outstockTotalVO = new OutstockTotalVO();
        outstockTotalVO.setTotalNo(reqBO.getTotalNo());
        outstockTotalVO.setOrgId(reqBO.getCompanyId());
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectSelective(outstockTotalVO);
        if (outstockTotal == null) {
            logger.error("\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\uff0c\u548c\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7\uff1a" + reqBO.getCompanyId() + "\u5728\u51fa\u5e93\u6c47\u603b\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\uff0c\u548c\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7\uff1a" + reqBO.getCompanyId() + "\u5728\u51fa\u5e93\u6c47\u603b\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
        }
        head.setOrgName(this.orgService.queryOrgName(outstockTotal.getOrgId()));
        head.setCreateDate(sdf.format(outstockTotal.getCreateDate()));
        head.setTotalNo(reqBO.getTotalNo());
        head.setNum("");
        head.setBusiOperators(this.userInfoService.queryUserNameByUserId(outstockTotal.getUserId()));
        WorkFlowDataInfo workFlowDataInfo1 = new WorkFlowDataInfo();
        workFlowDataInfo1.setBillNo(reqBO.getTotalNo());
        WorkFlowDataInfo workFlowDataInfo = this.workFlowDataMapper.getModelBy(workFlowDataInfo1);
        if (workFlowDataInfo == null) {
            logger.error("\u6839\u636e\u5355\u636e\u7f16\u53f7" + reqBO.getTotalNo() + "\u5728\u5ba1\u6279\u6d41\u6570\u636e\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u5355\u636e\u7f16\u53f7" + reqBO.getTotalNo() + "\u5728\u5ba1\u6279\u6d41\u6570\u636e\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
        }
        FscQryAuditDetailBusiReqBO qryAuditDetailBusiReqBO = new FscQryAuditDetailBusiReqBO();
        qryAuditDetailBusiReqBO.setProcInstId(workFlowDataInfo.getProcInstId());
        FscQryAuditDetailBusiRspBO qryAuditDetailBusiRspBO = this.fscQryAuditDetailBusiService.qryAuditDetail(qryAuditDetailBusiReqBO);
        List wfList = qryAuditDetailBusiRspBO.getRows();
        int size = wfList.size();
        head.setProManager(size >= 2 ? ((AuditLogDetailBO)wfList.get(1)).getOperName() : "");
        head.setManagement(size >= 3 ? ((AuditLogDetailBO)wfList.get(2)).getOperName() : "");
        head.setSumTaxAmt(AmountUtils.format(sumTaxAmt));
        head.setSumUntaxAmt(AmountUtils.format(sumUntaxAmt));
        head.setSumAmt(AmountUtils.format(sumAmt));
        head.setSumProductCost(AmountUtils.format(sumProductCost));
        head.setUpSumProductCost(AmountUtils.upper(sumProductCost));
        head.setSource(outstockTotal.getSource());
        BeanUtils.null2DefaultValue(head);
        rspBO.setHead(head);
        return rspBO;
    }
}

