/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryBillApplyInfoListAService;
import com.tydic.pfsc.api.busi.bo.BusiQryBillApplyInfoListAReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryBillApplyInfoListARspBO;
import com.tydic.pfsc.api.busi.bo.QryBillApplyInfoABO;
import com.tydic.pfsc.api.busi.bo.SaleInvoiceInfoBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfoForOper;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoForOperVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.AfterSaleStatus;
import com.tydic.pfsc.enums.BillApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.PaySataus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.service.atom.EnumsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQryBillApplyInfoListAService"})
public class BusiQryBillApplyInfoListAServiceImpl
implements BusiQryBillApplyInfoListAService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryBillApplyInfoListAServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    @PostMapping(value={"qryBillApplyInfoList"})
    public BusiQryBillApplyInfoListARspBO qryBillApplyInfoList(@RequestBody BusiQryBillApplyInfoListAReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO);
        }
        BusiQryBillApplyInfoListARspBO rspBO = new BusiQryBillApplyInfoListARspBO();
        ArrayList<QryBillApplyInfoABO> billList = new ArrayList<QryBillApplyInfoABO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        BillApplyInfoForOperVO billApplyInfoForOperVO = new BillApplyInfoForOperVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoForOperVO);
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            billApplyInfoForOperVO.setOperUnitNo(reqBO.getCompanyId());
        } else {
            billApplyInfoForOperVO.setOperUnitNo(null);
        }
        List<BillApplyInfoForOper> billApplyInfoForOperList = this.billApplyInfoMapper.getListForOperPage(billApplyInfoForOperVO, (Page<Map<String, Object>>)page);
        if (billApplyInfoForOperList != null && billApplyInfoForOperList.size() > 0) {
            ArrayList ids = new ArrayList();
            for (BillApplyInfoForOper saleVO : billApplyInfoForOperList) {
                QryBillApplyInfoABO saleExtBO = new QryBillApplyInfoABO();
                BeanUtils.copyProperties((Object)saleVO, (Object)saleExtBO);
                saleExtBO.setBillStatusStr(this.enumsService.getDescr(BillStatus.getInstance(saleExtBO.getBillStatus())));
                saleExtBO.setPayStatusStr(this.enumsService.getDescr(PaySataus.getInstance(saleExtBO.getPayStatus())));
                saleExtBO.setBillApplyTypeStr(this.enumsService.getDescr(BillApplyType.getInstance(saleExtBO.getBillApplyType())));
                saleExtBO.setAfterSaleStatusStr(this.enumsService.getDescr(AfterSaleStatus.getInstance(saleExtBO.getAfterSaleStatus())));
                saleExtBO.setApplyUserName(reqBO.getUsername());
                if (!StringUtils.isEmpty((Object)saleExtBO.getInvoiceType())) {
                    saleExtBO.setInvoiceTypeStr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(saleExtBO.getInvoiceType()))));
                }
                this.queryInvoice(saleExtBO, saleVO.getApplyNo());
                billList.add(saleExtBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            rspBO.setRows(billList);
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        return rspBO;
    }

    public QryBillApplyInfoABO queryInvoice(QryBillApplyInfoABO qryBillApplyInfoABO, String applyNo) {
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        Page page = new Page(1, 50);
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectListPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page);
        qryBillApplyInfoABO.setIsExistsInvoice("1");
        if (saleInvoiceInfoList.isEmpty()) {
            qryBillApplyInfoABO.setIsExistsInvoice("0");
        }
        ArrayList<SaleInvoiceInfoBO> saleInvoiceInfoBOS = new ArrayList<SaleInvoiceInfoBO>();
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
            SaleInvoiceInfoBO saleInvoiceInfoBO = new SaleInvoiceInfoBO();
            BeanUtils.copyProperties((Object)saleInvoiceInfo, (Object)saleInvoiceInfoBO);
            saleInvoiceInfoBO.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
            saleInvoiceInfoBOS.add(saleInvoiceInfoBO);
        }
        qryBillApplyInfoABO.setSaleInvoiceInfoBOS(saleInvoiceInfoBOS);
        return qryBillApplyInfoABO;
    }
}

