/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.ReconcilitionSubmitInvoiceService;
import com.tydic.pfsc.api.busi.bo.ReconcilitionSubmitInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.ReconcilitionSubmitInvoiceRspBO;
import com.tydic.pfsc.dao.ReconcilitionHisMapper;
import com.tydic.pfsc.dao.po.ReconcilitionSubmitInvoicePO;
import com.tydic.pfsc.enums.ReconciliationStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.busi.impl.QueryEntryInfoServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.ReconcilitionSubmitInvoiceService"})
public class ReconcilitionSubmitInvoiceServiceImpl
implements ReconcilitionSubmitInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    private ReconcilitionHisMapper reconcilitionHisMapper;

    @Autowired
    public ReconcilitionSubmitInvoiceServiceImpl(ReconcilitionHisMapper reconcilitionHisMapper) {
        this.reconcilitionHisMapper = reconcilitionHisMapper;
    }

    @PostMapping(value={"submitInvoice"})
    public ReconcilitionSubmitInvoiceRspBO submitInvoice(@RequestBody ReconcilitionSubmitInvoiceReqBO reqBO) {
        ReconcilitionSubmitInvoicePO reconcilitionSubmitInvoicePO;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7ed3\u7b97\u5bf9\u8d26\u63d0\u4ea4\u5f00\u7968\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBO.getBatchNo());
        }
        ReconcilitionSubmitInvoiceRspBO rspBO = new ReconcilitionSubmitInvoiceRspBO();
        if (!StringUtils.hasText((String)reqBO.getBatchNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u672a\u8fdb\u884c\u5bf9\u8d26\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
            return rspBO;
        }
        List<Integer> supplierNo = this.reconcilitionHisMapper.selectSupplierNo(Integer.valueOf(reqBO.getBatchNo()));
        if (supplierNo.size() > 1) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4e0d\u662f\u540c\u4e00\u4f9b\u5e94\u5546\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
            return rspBO;
        }
        try {
            reconcilitionSubmitInvoicePO = this.reconcilitionHisMapper.selectAccount(Integer.valueOf(reqBO.getBatchNo()), ReconciliationStatus.AGREEMENT.getCode());
        }
        catch (Exception e) {
            LOGGER.error("\u7ed3\u7b97\u5bf9\u8d26\u63d0\u4ea4\u5f00\u7968\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getBatchNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u7ed3\u7b97\u5bf9\u8d26\u63d0\u4ea4\u5f00\u7968\u5931\u8d25");
        }
        if (null == reconcilitionSubmitInvoicePO || null == reconcilitionSubmitInvoicePO.getOrderNum() || null == reconcilitionSubmitInvoicePO.getOrderAmt()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        if (0 == reconcilitionSubmitInvoicePO.getOrderNum()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u4e00\u81f4\u6570\u636e\u6216\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u672a\u63d0\u4ea4\uff0c\u4e0d\u80fd\u63d0\u4ea4\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAmountCount(reconcilitionSubmitInvoicePO.getOrderNum());
        rspBO.setAmountPrice(reconcilitionSubmitInvoicePO.getOrderAmt());
        rspBO.setSupplierNo(supplierNo.get(0).toString());
        return rspBO;
    }
}

