/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.api.deal.GetElectronicInvoiceService;
import com.tydic.pfsc.api.deal.bo.InvoiceInfoBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.enums.InvoiceMailStatus;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payInvoiceService")
public class PayInvoiceService {
    private static final Log log = LogFactory.getLog(PayInvoiceService.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private GetElectronicInvoiceService getElectronicInvoiceService;

    public void createInvoice(PayInvoiceInfo invoiceInfo) {
        String supplierNo;
        String notificationNo = invoiceInfo.getNotificationNo();
        BigDecimal amt = BigDecimal.ZERO;
        HashSet<String> invoiceNos = new HashSet<String>();
        Date invoiceDate = null;
        if (invoiceInfo.getInvoiceCode() == null || invoiceInfo.getInvoiceNo() == null) {
            log.error((Object)("InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo));
            throw new PfscExtBusinessException("0001", "InvoiceCode\u6216InvoiceNo\u4e3a\u7a7a\uff0c\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo);
        }
        BillNotificationInfo billNotificationInfo = this.notificationInfomapper.selectByPrimaryKey(notificationNo);
        if (billNotificationInfo == null) {
            log.error((Object)("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011"));
            throw new PfscExtBusinessException("18001", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011");
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        for (PayInvoiceInfo invoice : payInvoiceInfoList) {
            if (invoice.getInvoiceNo().contains(invoiceInfo.getInvoiceNo())) {
                this.payInvoiceInfoMapper.deleteByPrimaryKey(invoice.getInvoiceCode(), invoice.getInvoiceNo(), invoice.getInvoiceDate());
                continue;
            }
            amt = amt.add(invoice.getAmt());
            invoiceNos.add(invoice.getInvoiceNo());
            if (invoiceDate != null && !invoiceDate.before(invoice.getInvoiceDate())) continue;
            invoiceDate = invoice.getInvoiceDate();
        }
        amt = amt.add(invoiceInfo.getAmt());
        invoiceNos.add(invoiceInfo.getInvoiceNo());
        if (invoiceDate == null || invoiceDate.before(invoiceInfo.getInvoiceDate())) {
            invoiceDate = invoiceInfo.getInvoiceDate();
        }
        if (invoiceInfo.getInvoiceType() == 3 && !(supplierNo = "100055").equals(invoiceInfo.getSupplierNo())) {
            InvoiceInfoBO invoiceInfoBO = new InvoiceInfoBO();
            invoiceInfoBO.setSupplierId(invoiceInfo.getSupplierNo());
            invoiceInfoBO.setNotificationNo(notificationNo);
            invoiceInfoBO.setFlag(Integer.valueOf(1));
            invoiceInfoBO.setElectronicInvoiceUrl(invoiceInfo.getElectronicInvoiceUrl());
            InvoiceInfoBO invoiceInfoRspBO = this.getElectronicInvoiceService.getElectronicInvoice(invoiceInfoBO);
            if (invoiceInfoRspBO != null && "0000".equals(invoiceInfoRspBO.getRespCode())) {
                invoiceInfo.setElectronicInvoiceName(invoiceInfoRspBO.getElectronicInvoiceName());
                invoiceInfo.setElectronicInvoiceUrl(invoiceInfoRspBO.getElectronicInvoiceUrl());
            } else {
                log.error((Object)("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u5931\u8d25 \u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011"));
                throw new PfscExtBusinessException("18001", "\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u5931\u8d25 \u3010\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + "\u3011");
            }
        }
        this.payInvoiceInfoMapper.insert(invoiceInfo);
        if (amt.compareTo(billNotificationInfo.getAmt()) >= 0) {
            billNotificationInfo = new BillNotificationInfo();
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            billNotificationInfo.setInvoiceDate(invoiceDate);
            billNotificationInfo.setNotificationNo(notificationNo);
            billNotificationInfo.setInvoiceResult("");
            int cnt = this.notificationInfomapper.updateByPrimaryKeySelective(billNotificationInfo);
            log.debug((Object)("\u4fee\u6539\u901a\u77e5\u5355\u53f7\u7684\u72b6\u6001\u4e3a\u5df2\u5f00\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo + " \u66f4\u65b0\u6570=" + cnt));
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            String invoiceNo = FscStringUtils.list2String(new ArrayList(invoiceNos), ",");
            payItemUpd.setInvoiceNo(invoiceNo);
            cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            log.debug((Object)("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u4e3a\u5df2\u5f00\u7968(02),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u6570\u91cf=" + cnt));
        }
    }

    public void updateMailSendStatus(PayInvoiceInfo updateInvoice, String mailInfo) {
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setNotificationNo(updateInvoice.getNotificationNo());
        billNotificationInfo.setMailDesc(mailInfo);
        this.notificationInfomapper.updateByConditions(billNotificationInfo);
        updateInvoice.setMailStatus(InvoiceMailStatus.NOT_SIGNED.getCode());
        this.payInvoiceInfoMapper.updateMailStatus(updateInvoice);
    }
}

