/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAfterSaleService;
import com.tydic.pfsc.api.busi.bo.BusiAfterSaleDetailReqBO;
import com.tydic.pfsc.api.busi.bo.BusiAfterSaleHeadReqBO;
import com.tydic.pfsc.api.busi.bo.BusiAfterSaleReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.AfterSaleDetailMapper;
import com.tydic.pfsc.dao.AfterSaleMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.AfterSale;
import com.tydic.pfsc.dao.po.AfterSaleDetail;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.enums.AfterSaleMessageType;
import com.tydic.pfsc.enums.AfterSaleProcessStatus;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.SequenceNoService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiAfterSaleServiceImpl
implements BusiAfterSaleService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAfterSaleServiceImpl.class);
    @Autowired
    private SequenceNoService publicSeqNoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public PfscExtRspBaseBO process(BusiAfterSaleReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u552e\u540e\u6d88\u606f\u767b\u8bb0\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        this.validParam(reqBO);
        BusiAfterSaleHeadReqBO head = reqBO.getHead();
        List details = reqBO.getDetails();
        Long inspectionId = head.getInspectionId();
        Long purchaseOrderId = head.getPurchaseOrderId();
        Long saleOrderId = head.getSaleOrderId();
        PayPurchaseOrderInfo purchaseOrder = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(purchaseOrderId, inspectionId);
        if (purchaseOrder == null) {
            logger.error("\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("0001", "\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        SaleOrderInfo saleOrder = this.saleOrderInfoMapper.getModelByPrimaryKey(saleOrderId, inspectionId);
        if (saleOrder == null) {
            logger.error("\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("0001", "\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + inspectionId + "]\u548c\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u5728\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
        }
        if (!CollectionUtils.isEmpty((Collection)details)) {
            BigDecimal purchaseAmount = BigDecimal.ZERO;
            BigDecimal saleAmount = BigDecimal.ZERO;
            for (BusiAfterSaleDetailReqBO detail : details) {
                purchaseAmount = purchaseAmount.add(detail.getPurchaseAmount());
                saleAmount = saleAmount.add(detail.getSaleAmount());
            }
            if (head.getPurchaseOrderAmt1().add(purchaseAmount).compareTo(head.getPurchaseOrderAmt2()) != 0) {
                logger.error("\u91c7\u8d2d\u8ba2\u5355\u7684\u9000\u8d27\u91d1\u989d\u548c\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u76f8\u7b49\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355\u7684\u9000\u8d27\u91d1\u989d\u548c\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u76f8\u7b49");
            }
            if (head.getSaleOrderAmt1().add(saleAmount).compareTo(head.getSaleOrderAmt2()) != 0) {
                logger.error("\u9500\u552e\u8ba2\u5355\u7684\u9000\u8d27\u91d1\u989d\u548c\u9500\u552e\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u76f8\u7b49\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u9500\u552e\u8ba2\u5355\u7684\u9000\u8d27\u91d1\u989d\u548c\u9500\u552e\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u76f8\u7b49");
            }
        }
        Long seq = Long.valueOf(this.publicSeqNoService.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date())));
        AfterSale afterSale = new AfterSale();
        BeanUtils.copyProperties((Object)head, (Object)afterSale);
        afterSale.setSeq(seq);
        afterSale.setMessageType(AfterSaleMessageType.START.getCode());
        afterSale.setProcessStatus(AfterSaleProcessStatus.NO_PROCESS.getCode());
        afterSale.setCreateDate(new Date());
        this.afterSaleMapper.insert(afterSale);
        if (details != null) {
            for (BusiAfterSaleDetailReqBO detail : details) {
                AfterSaleDetail afterSaleDetail = new AfterSaleDetail();
                BeanUtils.copyProperties((Object)detail, (Object)afterSaleDetail);
                afterSaleDetail.setRefSeq(seq);
                this.afterSaleDetailMapper.insert(afterSaleDetail);
            }
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(purchaseOrder.getNotificationNo());
        String notificationInvoiceStatus = null;
        if (null != billNotificationInfo) {
            notificationInvoiceStatus = billNotificationInfo.getInvoiceStatus();
        }
        PayPurchaseOrderInfo updatePurchaseOrder = new PayPurchaseOrderInfo();
        updatePurchaseOrder.setInspectionId(inspectionId);
        if (NotificationInvoiceStatus.SUBMITED.getCode().equals(notificationInvoiceStatus) || NotificationInvoiceStatus.HAS_MAKE.getCode().equals(notificationInvoiceStatus)) {
            BillNotificationInfo updateBill = new BillNotificationInfo();
            updateBill.setNotificationNo(purchaseOrder.getNotificationNo());
            updateBill.setInvoiceStatus(NotificationInvoiceStatus.HANGING.getCode());
            updateBill.setInvoiceResult("\u7531\u8d85\u5e02\u552e\u540e\u5f15\u8d77");
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
        }
        if (null == billNotificationInfo) {
            updatePurchaseOrder.setOrderStatus(OrderStatus.AFTER_SALE.getCode());
        }
        if (StringUtils.hasText((String)head.getRemark())) {
            updatePurchaseOrder.setRemark(head.getRemark().length() > 200 ? head.getRemark().substring(0, 200) : head.getRemark());
        }
        if (!details.isEmpty()) {
            updatePurchaseOrder.setOrderAmt(head.getPurchaseOrderAmt2());
        }
        if (StringUtils.hasText((String)updatePurchaseOrder.getOrderStatus()) || StringUtils.hasText((String)updatePurchaseOrder.getRemark()) || null != updatePurchaseOrder.getOrderAmt()) {
            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(updatePurchaseOrder);
        }
        saleOrder = new SaleOrderInfo();
        saleOrder.setInspectionId(inspectionId);
        saleOrder.setOrderStatus(OrderStatus.AFTER_SALE.getCode());
        if (StringUtils.hasText((String)head.getRemark())) {
            saleOrder.setRemark(head.getRemark().length() > 200 ? head.getRemark().substring(0, 200) : head.getRemark());
        }
        if (!details.isEmpty()) {
            saleOrder.setOrderAmt(head.getSaleOrderAmt2());
        }
        this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrder);
        return new PfscExtRspBaseBO();
    }

    private void validParam(BusiAfterSaleReqBO reqBO) {
        BusiAfterSaleHeadReqBO head = reqBO.getHead();
        List details = reqBO.getDetails();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (head == null) {
            throw new PfscExtBusinessException("0001", "\u552e\u540e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long inspectionId = head.getInspectionId();
        Long purchaseOrderId = head.getPurchaseOrderId();
        Long saleOrderId = head.getSaleOrderId();
        if (inspectionId == null) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saleOrderId == null) {
            throw new PfscExtBusinessException("0001", "\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)details)) {
            if (head.getPurchaseOrderAmt1() == null) {
                logger.error("\u6709\u552e\u540e\u660e\u7ec6\u65f6\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u6709\u552e\u540e\u660e\u7ec6\u65f6\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20");
            }
            if (head.getPurchaseOrderAmt2() == null) {
                logger.error("\u6709\u552e\u540e\u660e\u7ec6\u65f6\u65b0\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u6709\u552e\u540e\u660e\u7ec6\u65f6\u65b0\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20");
            }
            if (head.getSaleOrderAmt1() == null) {
                logger.error("\u6709\u552e\u540e\u660e\u7ec6\u65f6\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u6709\u552e\u540e\u660e\u7ec6\u65f6\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20");
            }
            if (head.getSaleOrderAmt2() == null) {
                logger.error("\u6709\u552e\u540e\u660e\u7ec6\u65f6\u65b0\u9500\u552e\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("0001", "\u6709\u552e\u540e\u660e\u7ec6\u65f6\u65b0\u9500\u552e\u8ba2\u5355\u91d1\u989d\u5fc5\u4f20");
            }
            for (BusiAfterSaleDetailReqBO detail : details) {
                if (detail.getPurchaseItemNo() == null) {
                    throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u7684\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getPurchaseQuantity() == null) {
                    throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getPurchaseAmount() == null) {
                    throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getSaleItemNo() == null) {
                    throw new PfscExtBusinessException("0001", "\u9500\u552e\u5546\u54c1\u660e\u7ec6\u7684\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getSaleQuantity() == null) {
                    throw new PfscExtBusinessException("0001", "\u9500\u552e\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (detail.getSaleAmount() != null) continue;
                throw new PfscExtBusinessException("0001", "\u9500\u552e\u5546\u54c1\u660e\u7ec6\u7684\u9000\u8d27\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

