/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourReqBO;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourRspBO;
import com.tydic.pfsc.api.busi.bo.InvoiceDetailsBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BusiOutstockService;
import com.tydic.pfsc.service.atom.InvoiceReturnAtomService;
import com.tydic.pfsc.service.busi.impl.BusiBackInvoiceDzcsInvoiceReturnService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService"})
public class BusiBackInvoiceAtourServiceImpl
implements BusiBackInvoiceAtourService {
    private static final Logger log = LoggerFactory.getLogger(BusiBackInvoiceAtourServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired(required=false)
    private BusiOutstockService busiOutstockService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private InvoiceReturnAtomService invoiceReturnAtomService;
    @Autowired(required=false)
    private BusiBackInvoiceDzcsInvoiceReturnService busiBackInvoiceDzcsInvoiceReturnService;

    @PostMapping(value={"busiBackInvoiceAtour"})
    public BusiBackInvoiceAtourRspBO busiBackInvoiceAtour(@RequestBody BusiBackInvoiceAtourReqBO reqBO) {
        Object vo;
        BillApplyInfo billApplyInfo1;
        SaleInvoiceInfoVO saleInvoiceInfoVO;
        BusiBackInvoiceAtourRspBO rspBO = new BusiBackInvoiceAtourRspBO();
        String applyNo = reqBO.getInvoiceMain().getSalesbillNo();
        String invoiceStatus = reqBO.getInvoiceMain().getStatus().toString();
        String invoiceNo = reqBO.getInvoiceMain().getInvoiceNo();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            log.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]");
        }
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        String returnBillNo = billApplyInfo.getReturnBillNo();
        SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
        if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoiceStatus)) {
            List<String> invoiceNos;
            if (saleInvoiceInfo == null) {
                log.error("\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("18000", "\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002");
            }
            SaleInvoiceInfo record = new SaleInvoiceInfo();
            record.setInvoiceNo(invoiceNo);
            record.setInvoiceStatus(invoiceStatus);
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(record);
            if (BillStatus.SEND_BILL.getCode().equals(billApplyInfo.getBillStatus()) && CollectionUtils.isEmpty(invoiceNos = this.saleInvoiceInfoMapper.getInvoiceNoByApplyNo(applyNo))) {
                BillApplyInfo billApply = new BillApplyInfo();
                billApply.setApplyNo(applyNo);
                billApply.setBillStatus(BillStatus.INVOICE_INVALID.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
            }
            return rspBO;
        }
        if (BillStatus.INVOICE_INVALID.getCode().equals(billApplyInfo.getBillStatus())) {
            BillApplyInfo billApply = new BillApplyInfo();
            billApply.setApplyNo(applyNo);
            billApply.setBillStatus(BillStatus.SEND_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        }
        if (saleInvoiceInfo != null) {
            log.error("\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18000", "\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002");
        }
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        for (InvoiceDetailsBO detailReqBO : reqBO.getInvoiceDetails()) {
            sumUntaxAmt = sumUntaxAmt.add(detailReqBO.getAmountWithoutTax());
            sumTaxAmt = sumTaxAmt.add(detailReqBO.getTaxAmount());
        }
        if (sumUntaxAmt.compareTo(reqBO.getInvoiceMain().getAmountWithoutTax()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (sumTaxAmt.compareTo(reqBO.getInvoiceMain().getAmountWithoutTax()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        saleInvoiceInfo = new SaleInvoiceInfo();
        saleInvoiceInfo.setInvoiceNo(invoiceNo);
        saleInvoiceInfo.setInvoiceCode(reqBO.getInvoiceMain().getInvoiceCode());
        saleInvoiceInfo.setInvoiceDate(reqBO.getInvoiceMain().getPaperDrewDate());
        saleInvoiceInfo.setApplyNo(applyNo);
        saleInvoiceInfo.setUntaxAmt(reqBO.getInvoiceMain().getAmountWithoutTax());
        saleInvoiceInfo.setTaxAmt(reqBO.getInvoiceMain().getTaxAmount());
        saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
        saleInvoiceInfo.setInvoiceStatus(invoiceStatus);
        this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
        for (InvoiceDetailsBO detailBO : reqBO.getInvoiceDetails()) {
            Long itemNo = detailBO.getId();
            BigDecimal taxAmt = detailBO.getTaxAmount();
            BigDecimal untaxAmt = detailBO.getAmountWithoutTax();
            BigDecimal amount = taxAmt.add(untaxAmt);
            SaleItemInfoVO saleItemInfoVO = null;
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNo(applyNo);
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
            } else {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVO(saleItemInfoVO);
            }
            SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
            saleInvoiceDetail.setItemName(detailBO.getItemName());
            saleInvoiceDetail.setSpecModel(detailBO.getItemSpec());
            saleInvoiceDetail.setUnitName(detailBO.getQuantityUnit());
            saleInvoiceDetail.setQuantity(detailBO.getQuantity());
            saleInvoiceDetail.setUntaxAmt(untaxAmt);
            saleInvoiceDetail.setTaxAmt(taxAmt);
            saleInvoiceDetail.setAmount(amount);
            saleInvoiceDetail.setTaxRate(detailBO.getTaxRate());
            saleInvoiceDetail.setTaxClassCode(detailBO.getGoodsTaxNo());
            saleInvoiceDetail.setItemNo(itemNo);
            saleInvoiceDetail.setInvoiceNo(invoiceNo);
            saleInvoiceDetail.setSaleUnitPrice(saleItemInfoVO.getSaleUnitPrice());
            this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
            SaleInvoiceDetailVO saleInvoiceDetailVO = new SaleInvoiceDetailVO();
            saleInvoiceDetailVO.setApplyNo(applyNo);
            saleInvoiceDetailVO.setItemNo(itemNo);
            saleInvoiceDetail = this.saleInvoiceDetailMapper.selectSumOfItem(saleInvoiceDetailVO);
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
                saleItemApplyInfoVO.setApplyNo(applyNo);
                saleItemApplyInfoVO.setSeq(saleItemInfoVO.getSeq());
                saleItemApplyInfoVO.setTaxAmt(saleInvoiceDetail.getTaxAmt());
                saleItemApplyInfoVO.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
                this.saleItemApplyInfoMapper.updateByVO(saleItemApplyInfoVO);
                continue;
            }
            this.saleItemInfoMapper.updateByConditions(saleInvoiceDetail.getTaxAmt(), saleInvoiceDetail.getUntaxAmt(), saleInvoiceDetail.getAmount(), saleItemInfoVO.getSeq());
        }
        if (BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) {
            saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceInfoVO);
            if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                billApplyInfo1 = new BillApplyInfo();
                billApplyInfo1.setApplyNo(applyNo);
                billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
            }
        }
        if (StringUtils.hasText((String)returnBillNo)) {
            saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            vo = new InvoiceReturnDetailVO();
            ((InvoiceReturnDetail)vo).setBillNo(returnBillNo);
            ((InvoiceReturnDetail)vo).setApplyNo3(applyNo);
            List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
            int index = 0;
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                if (saleInvoiceInfos.size() > index) {
                    InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                    whereRecord.setBillNo(invoiceReturnDetail.getBillNo());
                    whereRecord.setApplyNo3(invoiceReturnDetail.getApplyNo3());
                    whereRecord.setInvoiceNo1(invoiceReturnDetail.getInvoiceNo1());
                    InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                    valueRecord.setInvoiceNo3(saleInvoiceInfos.get(index).getInvoiceNo());
                    this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
                }
                ++index;
            }
        }
        if (BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) {
            saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceInfoVO);
            if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                billApplyInfo1 = new BillApplyInfo();
                billApplyInfo1.setApplyNo(applyNo);
                billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
                if (StringUtils.hasText((String)returnBillNo)) {
                    vo = new InvoiceReturnVO();
                    ((InvoiceReturn)vo).setBillNo(returnBillNo);
                    ((InvoiceReturn)vo).setStatus(InvoiceReturnStatus.BILLED.getCode());
                    this.invoiceReturnAtomService.updateStatus((InvoiceReturnVO)vo);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

