/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiExportNotificationInvoiceListService;
import com.tydic.pfsc.api.busi.bo.BusiExportNotificationInvoiceListReqBO;
import com.tydic.pfsc.api.busi.bo.BusiExportNotificationInvoiceListRspBO;
import com.tydic.pfsc.api.busi.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.pfsc.api.busi.vo.BusiExportNotificationInvoiceInfoVO;
import com.tydic.pfsc.api.busi.vo.NotificationInvoiceVO;
import com.tydic.pfsc.base.PfscExtReqPageBaseBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfoExt;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.dao.vo.Statis;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.PurchaseSaleType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.BusinessUtils;
import com.tydic.pfsc.utils.DatesUtils;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiExportNotificationInvoiceListServiceImpl
implements BusiExportNotificationInvoiceListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportNotificationInvoiceListServiceImpl.class);
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    private static final String NON_INVOICE_TYPE = "0";

    public BusiExportNotificationInvoiceListRspBO notifiInvoiceList(BusiExportNotificationInvoiceListReqBO reqBO) {
        String invoiceType;
        String source;
        String invoiceStatus;
        Long companyId;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1\u5165\u53c2:" + reqBO);
        }
        if ((companyId = reqBO.getCompanyId()) == null) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u9519\u8bef");
        }
        Long operUnitNo = reqBO.getOperUnitNo();
        String notificationNo = reqBO.getNotificationNo();
        operUnitNo = BusinessUtils.judgeOperUnitNo(operUnitNo, companyId, false);
        Long supNo = reqBO.getSupplierNo();
        BusiExportNotificationInvoiceListRspBO resp = new BusiExportNotificationInvoiceListRspBO();
        resp.setRows(new ArrayList());
        String invoiceNo = reqBO.getInvoiceNo();
        if (StringUtils.hasText((String)invoiceNo)) {
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByInvoiceNo(invoiceNo);
            if (invoices.size() > 0) {
                notificationNo = invoices.get(0).getNotificationNo();
            } else {
                resp.setTotal(Integer.valueOf(0));
                resp.setRecordsTotal(Integer.valueOf(0));
                resp.setPageNo(Integer.valueOf(1));
                return resp;
            }
        }
        if ((invoiceStatus = reqBO.getInvoiceStatus()) != null && invoiceStatus.length() == 0) {
            invoiceStatus = null;
        }
        if (!StringUtils.hasText((String)(source = reqBO.getSource()))) {
            source = OrderSource.ELECTRIC_MARKET.getCode();
        }
        if (NON_INVOICE_TYPE.equals(invoiceType = reqBO.getInvoiceType())) {
            invoiceType = null;
        }
        BillNotificationInfoExt extInfo = new BillNotificationInfoExt();
        BeanUtils.copyProperties((Object)reqBO, (Object)extInfo);
        extInfo.setNotificationNo(notificationNo);
        if (StringUtils.hasText((String)invoiceType)) {
            extInfo.setInvoceType(Integer.valueOf(invoiceType));
        }
        extInfo.setInvoiceStatus(invoiceStatus);
        extInfo.setSupplierNo(supNo);
        extInfo.setSource(source);
        extInfo.setOperNo(operUnitNo);
        extInfo.setFromApplyDate(reqBO.getFromDate());
        extInfo.setToApplyDate(reqBO.getToDate());
        extInfo.setSignStartDate(reqBO.getSignStartDate());
        extInfo.setSignEndDate(reqBO.getSignEndDate());
        extInfo.setInvoiceDateStart(reqBO.getInvoiceDateStart());
        extInfo.setInvoiceDateEnd(reqBO.getInvoiceDateEnd());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            extInfo.setPurchaseSaleType(PurchaseSaleType.MINMARKET.getCode());
        }
        String defaultOrderBy = " APPLY_DATE desc,NOTIFICATION_NO desc ";
        String tableName = "d_bill_notification_info";
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, tableName, defaultOrderBy);
        extInfo.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<NotificationInvoiceVO> list = this.billNotificationInfoMapper.selectForPageAndFilter(extInfo, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isNotEmpty(list)) {
            for (NotificationInvoiceVO inf : list) {
                List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(inf.getNotificationNo());
                if (CollectionUtils.isNotEmpty(invoices)) {
                    for (PayInvoiceInfo payInvoiceInfo : invoices) {
                        resp.getRows().add(this.getExportInfo(inf, payInvoiceInfo));
                    }
                    continue;
                }
                resp.getRows().add(this.getExportInfo(inf, null));
            }
        }
        resp.setTotal(Integer.valueOf(page.getTotalPages()));
        resp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        resp.setPageNo(Integer.valueOf(page.getPageNo()));
        return resp;
    }

    private BusiExportNotificationInvoiceInfoVO getExportInfo(NotificationInvoiceVO inf, PayInvoiceInfo invoiceInfo) {
        Statis ordStatis;
        BusiExportNotificationInvoiceInfoVO vo = new BusiExportNotificationInvoiceInfoVO();
        BeanUtils.copyProperties((Object)inf, (Object)vo);
        vo.setSignDate(inf.getEntryDate());
        if (null != invoiceInfo) {
            vo.setInvoiceDate(invoiceInfo.getInvoiceDate());
            vo.setImportDate(invoiceInfo.getCreateDate());
            vo.setInvoiceNos(invoiceInfo.getInvoiceNo());
            vo.setInvoiceAmt(invoiceInfo.getAmt());
            vo.setInvoiceNotTaxAmt(invoiceInfo.getNotTaxAmt());
            vo.setInvoiceTaxAmt(invoiceInfo.getTaxAmt());
            InvoiceType vt = InvoiceType.getInstance(invoiceInfo.getInvoiceType());
            if (vt != null) {
                vo.setInvoiceTypeDescr(vt.getDescr());
            }
        }
        if (!StringUtils.isEmpty((Object)inf.getVerifyPersonId())) {
            vo.setReceiver(this.userInfoService.queryUserNameByUserId(inf.getVerifyPersonId()));
        }
        String supName = this.organizationInfoService.querySupplierName(inf.getSupplierNo());
        vo.setSupplierName(supName);
        NotificationInvoiceStatus nis = NotificationInvoiceStatus.getInstance(vo.getInvoiceStatus());
        if (nis != null) {
            vo.setInvoiceStatusDescr(nis.getDescr());
        }
        vo.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)vo.getSource())));
        LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
        LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
        LinkedList<String> invoiceNoList = new LinkedList<String>();
        PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
        purchaseOrderInfoVO.setNotificationNo(vo.getNotificationNo());
        List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
        PurchaseOrderDetailInfoRspBO detailRspBO = null;
        for (PayPurchaseOrderInfo purchaseOrder : purchaseOrderInfos) {
            detailRspBO = new PurchaseOrderDetailInfoRspBO();
            detailRspBO.setPurchaseOrderCode(purchaseOrder.getPurchaseOrderCode());
            detailRspBO.setInspectionId(purchaseOrder.getInspectionId());
            detailRspBO.setRecvDate(purchaseOrder.getRecvDate());
            purchaseOrderDetailList.add(detailRspBO);
            purchaseOrderNameList.add(purchaseOrder.getPurchaseOrderName());
        }
        List<PayInvoiceInfo> allInvoices = this.payInvoiceInfoMapper.selectByNotifyNo(vo.getNotificationNo());
        StringBuilder sb = new StringBuilder();
        for (PayInvoiceInfo payInvoiceInfo : allInvoices) {
            if (!StringUtils.isEmpty((Object)sb.toString()) && sb.toString().split(",").length >= 5) {
                invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                sb.delete(0, sb.length());
                sb.append(payInvoiceInfo.getInvoiceNo()).append(",");
                continue;
            }
            sb.append(payInvoiceInfo.getInvoiceNo()).append(",");
        }
        vo.setTicketDays(DatesUtils.obtainDaysBetween(vo.getApplyDate(), vo.getImportDate()));
        vo.setSignDays(DatesUtils.obtainDaysBetween(vo.getImportDate(), vo.getSignDate()));
        if (sb.length() >= 1) {
            invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
        }
        PurchaseSaleType purchaseSaleTypeEnum = PurchaseSaleType.getInstance(inf.getPurchaseSaleType());
        vo.setPurchaseSaleTypeStr(this.enumsService.getDescr(purchaseSaleTypeEnum));
        vo.setPurchaseSaleType(inf.getPurchaseSaleType());
        vo.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(vo.getProfessionalDepartId()));
        vo.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(vo.getServiceDepartId()));
        vo.setPurchaseOrderCodeList(purchaseOrderDetailList);
        vo.setPurchaseOrderNameList(purchaseOrderNameList);
        vo.setInvoiceNoList(invoiceNoList);
        Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(vo.getNotificationNo());
        if (null != ivStatis) {
            vo.setSumInvoiceAmt(ivStatis.getTotAmt());
        }
        if (null != (ordStatis = this.payItemInfoMapper.orderStatis(vo.getNotificationNo()))) {
            vo.setNotificationSumAmt(ordStatis.getTotAmt());
            vo.setNotificationSumNotTaxAmt(ordStatis.getTotUntaxAmt());
            vo.setNotificationSumTaxAmt(ordStatis.getTotTaxAmt());
        }
        return vo;
    }
}

