/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiOrderHandUpService;
import com.tydic.pfsc.api.busi.bo.BusiOrderHandUpReqBO;
import com.tydic.pfsc.api.busi.bo.BusiOrderHandUpRspBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiOrderHandUpService"})
public class BusiOrderHandUpServiceImpl
implements BusiOrderHandUpService {
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    @Autowired
    public BusiOrderHandUpServiceImpl(PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    @PostMapping(value={"updateHandUpOrder"})
    public BusiOrderHandUpRspBO updateHandUpOrder(@RequestBody BusiOrderHandUpReqBO reqBo) {
        PayInvoiceInfo invoiceInfo;
        if (CollectionUtils.isEmpty((Collection)reqBo.getInspectionIds())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009\u8ba2\u5355");
        }
        BusiOrderHandUpRspBO rspBo = new BusiOrderHandUpRspBO();
        List inspectionIds = reqBo.getInspectionIds();
        boolean flag = this.checkStatus(inspectionIds);
        if (!flag) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u72b6\u6001\u5fc5\u987b\u662f" + OrderStatus.APPLIED.getDescr());
        }
        String notificationNo = this.payPurchaseOrderInfoMapper.getNoficationNoByInspectionId((Long)inspectionIds.get(0));
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new PfscExtBusinessException("0001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7[" + inspectionIds.get(0) + "]\u83b7\u53d6\u5f00\u7968\u901a\u77e5\u5355\u53f7\u5931\u8d25\u3002");
        }
        int update = this.payPurchaseOrderInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.HANGING.getCode());
        if (update < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        int update1 = this.payItemInfoMapper.updateHandStatusByInspectionIds(inspectionIds, OrderStatus.NO_APPLY.getCode());
        if (update1 < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        int update3 = this.billNotificationInfoMapper.updateAmtByNotificationNo(notificationNo);
        if (update3 < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
        }
        BillNotificationInfo notification = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (notification.getAmt().compareTo(BigDecimal.ZERO) == 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
            int update4 = this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            if (update4 < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            return rspBo;
        }
        List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (!payInvoiceInfoList.isEmpty() && (invoiceInfo = payInvoiceInfoList.get(0)).getAmt().compareTo(notification.getAmt()) >= 0) {
            notification = new BillNotificationInfo();
            notification.setNotificationNo(notificationNo);
            notification.setInvoiceStatus(NotificationInvoiceStatus.HAS_MAKE.getCode());
            int update5 = this.billNotificationInfoMapper.updateByPrimaryKeySelective(notification);
            if (update5 < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
            payOrderUpd.setNotificationNo(notificationNo);
            payOrderUpd.setOrderStatus(OrderStatus.SEND_BILL.getCode());
            int update6 = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
            if (update6 < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            PayItemInfo payItemUpd = new PayItemInfo();
            payItemUpd.setNotificationNo(notificationNo);
            payItemUpd.setItemStatus(OrderStatus.SEND_BILL.getCode());
            payItemUpd.setInvoiceCode(invoiceInfo.getInvoiceCode());
            payItemUpd.setInvoiceNo(invoiceInfo.getInvoiceNo());
            int update7 = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemUpd);
            if (update7 < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
        }
        return rspBo;
    }

    private boolean checkStatus(List<Long> inspectionIds) {
        boolean flag = false;
        int count = this.payPurchaseOrderInfoMapper.getNotAppliedCountByInspectionIds(inspectionIds, OrderStatus.APPLIED.getCode());
        if (count == 0) {
            flag = true;
        }
        return flag;
    }
}

