/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiBackInvoiceService;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceDetailReqBO;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BusiOutstockService;
import com.tydic.pfsc.service.atom.InvoiceReturnAtomService;
import com.tydic.pfsc.service.atom.bo.OutstockReqBO;
import com.tydic.pfsc.service.busi.impl.BusiBackInvoiceDzcsInvoiceReturnService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiBackInvoiceService"})
public class BusiBackInvoiceServiceImpl
implements BusiBackInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBackInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired(required=false)
    private BusiOutstockService busiOutstockService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private InvoiceReturnAtomService invoiceReturnAtomService;
    @Autowired(required=false)
    private BusiBackInvoiceDzcsInvoiceReturnService busiBackInvoiceDzcsInvoiceReturnService;

    @PostMapping(value={"addInv"})
    public PfscExtRspBaseBO addInv(@RequestBody BusiBackInvoiceReqBO reqBO) {
        block43: {
            BillApplyInfo billApplyInfo1;
            Object saleInvoiceInfoVO;
            SaleInvoiceInfo saleInvoiceInfo;
            String returnBillNo;
            String source;
            BillApplyInfo billApplyInfo;
            String invoiceNo;
            String applyNo;
            block42: {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u7a0e\u63a7\u56de\u4f20\u5f00\u7968\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
                }
                if (!StringUtils.hasText((String)(applyNo = reqBO.getBill_no()))) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[bill_no]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)reqBO.getInvoice_code())) {
                    throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4ee3\u7801[invoice_code]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                invoiceNo = reqBO.getInvoice_num();
                if (!StringUtils.hasText((String)invoiceNo)) {
                    throw new PfscExtBusinessException("0001", "\u53d1\u7968\u53f7\u7801[invoice_num]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)reqBO.getInvoice_date())) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u65e5\u671f[invoice_date]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)reqBO.getInvoice_amount())) {
                    throw new PfscExtBusinessException("0001", "\u53d1\u7968\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09[invoice_amount]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)reqBO.getInvoice_tax())) {
                    throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7a0e\u989d[invoice_tax]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == reqBO.getInvoice_state()) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u72b6\u6001[invoice_state]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String invoiceStatus = String.valueOf(reqBO.getInvoice_state());
                billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
                if (billApplyInfo == null) {
                    logger.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("18005", "\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]");
                }
                source = billApplyInfo.getSource();
                String applyType = billApplyInfo.getApplyType();
                returnBillNo = billApplyInfo.getReturnBillNo();
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source) && StringUtils.hasText((String)returnBillNo)) {
                    this.busiBackInvoiceDzcsInvoiceReturnService.addInv(reqBO);
                    return new PfscExtRspBaseBO();
                }
                saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
                if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoiceStatus)) {
                    List<String> invoiceNos;
                    if (saleInvoiceInfo == null) {
                        logger.error("\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                        throw new PfscExtBusinessException("18000", "\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002");
                    }
                    SaleInvoiceInfo record = new SaleInvoiceInfo();
                    record.setInvoiceNo(invoiceNo);
                    record.setInvoiceStatus(invoiceStatus);
                    this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(record);
                    if (BillStatus.SEND_BILL.getCode().equals(billApplyInfo.getBillStatus()) && CollectionUtils.isEmpty(invoiceNos = this.saleInvoiceInfoMapper.getInvoiceNoByApplyNo(applyNo))) {
                        BillApplyInfo billApply = new BillApplyInfo();
                        billApply.setApplyNo(applyNo);
                        billApply.setBillStatus(BillStatus.INVOICE_INVALID.getCode());
                        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                    }
                    return new PfscExtRspBaseBO();
                }
                if (BillStatus.INVOICE_INVALID.getCode().equals(billApplyInfo.getBillStatus())) {
                    BillApplyInfo billApply = new BillApplyInfo();
                    billApply.setApplyNo(applyNo);
                    billApply.setBillStatus(BillStatus.SEND_BILL.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                }
                if (saleInvoiceInfo != null) {
                    logger.error("\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("18000", "\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002");
                }
                SaleInvoiceInfoVO saleInvoiceData = new SaleInvoiceInfoVO();
                saleInvoiceData.setApplyNo(applyNo);
                saleInvoiceData.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
                SaleInvoiceInfo saleInvoiceSumInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceData);
                if (saleInvoiceSumInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                    logger.error("\u56de\u4f20\u7684\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d,\u8bf7\u5148\u4f5c\u5e9f\u65e0\u6548\u53d1\u7968[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("18000", "\u56de\u4f20\u7684\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d,\u8bf7\u5148\u4f5c\u5e9f\u65e0\u6548\u53d1\u7968");
                }
                if (BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
                    BillApplyInfo billApplyInfo12 = new BillApplyInfo();
                    billApplyInfo12.setApplyNo(applyNo);
                    billApplyInfo12.setBillStatus(BillStatus.SENDING_BILL.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo12);
                    billApplyInfo.setBillStatus(BillStatus.SENDING_BILL.getCode());
                }
                BigDecimal sumUntaxAmt = BigDecimal.ZERO;
                BigDecimal sumTaxAmt = BigDecimal.ZERO;
                for (BusiBackInvoiceDetailReqBO detailReqBO : reqBO.getDetail()) {
                    if (!StringUtils.hasText((String)detailReqBO.getOrder_no())) {
                        throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7[order_no]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null == detailReqBO.getLines_number()) {
                        throw new PfscExtBusinessException("0001", "\u884c\u53f7[lines_number]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)detailReqBO.getMateriel_name())) {
                        throw new PfscExtBusinessException("0001", "\u7269\u6599\u540d\u79f0[materiel_name]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null == detailReqBO.getAmount()) {
                        throw new PfscExtBusinessException("0001", "\u91d1\u989d(\u4e0d\u542b\u7a0e) [amount]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null == detailReqBO.getTax()) {
                        throw new PfscExtBusinessException("0001", "\u7a0e\u989d [tax]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (null == detailReqBO.getTax_rate()) {
                        throw new PfscExtBusinessException("0001", "\u7a0e\u7387 [tax_rate]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)detailReqBO.getTax_class_code())) {
                        throw new PfscExtBusinessException("0001", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801 [tax_class_code]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    sumUntaxAmt = sumUntaxAmt.add(detailReqBO.getAmount());
                    sumTaxAmt = sumTaxAmt.add(detailReqBO.getTax());
                }
                if (sumUntaxAmt.compareTo(new BigDecimal(reqBO.getInvoice_amount())) != 0) {
                    logger.error("\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
                }
                if (sumTaxAmt.compareTo(new BigDecimal(reqBO.getInvoice_tax())) != 0) {
                    logger.error("\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff01");
                }
                saleInvoiceInfo = new SaleInvoiceInfo();
                saleInvoiceInfo.setInvoiceNo(invoiceNo);
                saleInvoiceInfo.setInvoiceCode(reqBO.getInvoice_code());
                try {
                    saleInvoiceInfo.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").parse(reqBO.getInvoice_date()));
                }
                catch (ParseException e) {
                    logger.error("\u5f00\u7968\u65e5\u671f[" + reqBO.getInvoice_date() + "]\u4e0d\u6b63\u786e\u3002\u5165\u53c2=" + reqBO, (Throwable)e);
                    throw new PfscExtBusinessException("18000", "\u5f00\u7968\u65e5\u671f[" + reqBO.getInvoice_date() + "]\u4e0d\u6b63\u786e");
                }
                saleInvoiceInfo.setApplyNo(applyNo);
                saleInvoiceInfo.setUntaxAmt(new BigDecimal(reqBO.getInvoice_amount()));
                saleInvoiceInfo.setTaxAmt(new BigDecimal(reqBO.getInvoice_tax()));
                saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                saleInvoiceInfo.setInvoiceStatus(invoiceStatus);
                this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
                if (!OrderSource.ELECTRIC_MARKET.getCode().equals(source) && !OrderSource.ELECTRIC_AREA.getCode().equals(source) && (!OrderSource.CONSULT_PRICE.getCode().equals(source) || StringUtils.hasText((String)billApplyInfo.getPayFeeType())) && !OrderSource.COAL_AREA.getCode().equals(source)) break block42;
                for (BusiBackInvoiceDetailReqBO detailBO : reqBO.getDetail()) {
                    Long inspectionId = Long.valueOf(detailBO.getOrder_no());
                    Long itemNo = detailBO.getLines_number();
                    BigDecimal taxAmt = detailBO.getTax();
                    BigDecimal untaxAmt = detailBO.getAmount();
                    BigDecimal amount = taxAmt.add(untaxAmt);
                    SaleItemInfoVO saleItemInfoVO = null;
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                        saleItemInfoVO = new SaleItemInfoVO();
                        saleItemInfoVO.setApplyNo(applyNo);
                        saleItemInfoVO.setInspectionId(inspectionId);
                        saleItemInfoVO.setItemNo(itemNo);
                        saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
                    } else {
                        saleItemInfoVO = new SaleItemInfoVO();
                        saleItemInfoVO.setInspectionId(inspectionId);
                        saleItemInfoVO.setItemNo(itemNo);
                        saleItemInfoVO = this.saleItemInfoMapper.selectVO(saleItemInfoVO);
                    }
                    SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                    saleInvoiceDetail.setItemName(detailBO.getMateriel_name());
                    saleInvoiceDetail.setSpecModel(detailBO.getMateriel_standard());
                    saleInvoiceDetail.setUnitName(detailBO.getMateriel_unit());
                    saleInvoiceDetail.setQuantity(detailBO.getQuantity());
                    saleInvoiceDetail.setUntaxAmt(untaxAmt);
                    saleInvoiceDetail.setTaxAmt(taxAmt);
                    saleInvoiceDetail.setAmount(amount);
                    saleInvoiceDetail.setTaxRate(detailBO.getTax_rate());
                    saleInvoiceDetail.setTaxClassCode(detailBO.getTax_class_code());
                    saleInvoiceDetail.setInspectionId(inspectionId);
                    saleInvoiceDetail.setItemNo(itemNo);
                    saleInvoiceDetail.setInvoiceNo(invoiceNo);
                    saleInvoiceDetail.setSaleUnitPrice(saleItemInfoVO.getSaleUnitPrice());
                    this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                    SaleInvoiceDetailVO saleInvoiceDetailVO = new SaleInvoiceDetailVO();
                    saleInvoiceDetailVO.setApplyNo(applyNo);
                    saleInvoiceDetailVO.setInspectionId(inspectionId);
                    saleInvoiceDetailVO.setItemNo(itemNo);
                    saleInvoiceDetail = this.saleInvoiceDetailMapper.selectSumOfItem(saleInvoiceDetailVO);
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                        SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
                        saleItemApplyInfoVO.setApplyNo(applyNo);
                        saleItemApplyInfoVO.setSeq(saleItemInfoVO.getSeq());
                        saleItemApplyInfoVO.setTaxAmt(saleInvoiceDetail.getTaxAmt());
                        saleItemApplyInfoVO.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
                        this.saleItemApplyInfoMapper.updateByVO(saleItemApplyInfoVO);
                        continue;
                    }
                    this.saleItemInfoMapper.updateByConditions(saleInvoiceDetail.getTaxAmt(), saleInvoiceDetail.getUntaxAmt(), saleInvoiceDetail.getAmount(), saleItemInfoVO.getSeq());
                }
                if (!BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) break block43;
                saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                ((SaleInvoiceInfo)saleInvoiceInfoVO).setApplyNo(applyNo);
                ((SaleInvoiceInfo)saleInvoiceInfoVO).setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
                saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum((SaleInvoiceInfoVO)saleInvoiceInfoVO);
                if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) < 0) break block43;
                billApplyInfo1 = new BillApplyInfo();
                billApplyInfo1.setApplyNo(applyNo);
                billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
                OutstockReqBO outstockReqBO = new OutstockReqBO();
                outstockReqBO.setApplyNo(applyNo);
                this.busiOutstockService.insertAndUpdate(outstockReqBO);
                break block43;
            }
            if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                Object vo;
                for (BusiBackInvoiceDetailReqBO detailBO : reqBO.getDetail()) {
                    BigDecimal taxAmt = detailBO.getTax();
                    BigDecimal untaxAmt = detailBO.getAmount();
                    BigDecimal amount = taxAmt.add(untaxAmt);
                    SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                    saleInvoiceDetail.setItemName(detailBO.getMateriel_name());
                    saleInvoiceDetail.setSpecModel(detailBO.getMateriel_standard());
                    saleInvoiceDetail.setUnitName(detailBO.getMateriel_unit());
                    saleInvoiceDetail.setQuantity(detailBO.getQuantity());
                    saleInvoiceDetail.setUntaxAmt(untaxAmt);
                    saleInvoiceDetail.setTaxAmt(taxAmt);
                    saleInvoiceDetail.setAmount(amount);
                    saleInvoiceDetail.setTaxRate(detailBO.getTax_rate());
                    saleInvoiceDetail.setTaxClassCode(detailBO.getTax_class_code());
                    saleInvoiceDetail.setInspectionId(null);
                    saleInvoiceDetail.setItemNo(null);
                    saleInvoiceDetail.setInvoiceNo(invoiceNo);
                    saleInvoiceDetail.setSaleUnitPrice(amount.divide(detailBO.getQuantity(), 2, 4));
                    this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                }
                if (StringUtils.hasText((String)returnBillNo)) {
                    saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                    ((SaleInvoiceInfo)saleInvoiceInfoVO).setApplyNo(applyNo);
                    ((SaleInvoiceInfo)saleInvoiceInfoVO).setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
                    List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy((SaleInvoiceInfoVO)saleInvoiceInfoVO);
                    vo = new InvoiceReturnDetailVO();
                    ((InvoiceReturnDetail)vo).setBillNo(returnBillNo);
                    ((InvoiceReturnDetail)vo).setApplyNo3(applyNo);
                    List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
                    int index = 0;
                    for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                        if (saleInvoiceInfos.size() > index) {
                            InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                            whereRecord.setBillNo(invoiceReturnDetail.getBillNo());
                            whereRecord.setApplyNo3(invoiceReturnDetail.getApplyNo3());
                            whereRecord.setInvoiceNo1(invoiceReturnDetail.getInvoiceNo1());
                            InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                            valueRecord.setInvoiceNo3(saleInvoiceInfos.get(index).getInvoiceNo());
                            this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
                        }
                        ++index;
                    }
                }
                if (BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) {
                    saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                    ((SaleInvoiceInfo)saleInvoiceInfoVO).setApplyNo(applyNo);
                    ((SaleInvoiceInfo)saleInvoiceInfoVO).setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
                    saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum((SaleInvoiceInfoVO)saleInvoiceInfoVO);
                    if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                        billApplyInfo1 = new BillApplyInfo();
                        billApplyInfo1.setApplyNo(applyNo);
                        billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
                        if (StringUtils.hasText((String)returnBillNo)) {
                            vo = new InvoiceReturnVO();
                            ((InvoiceReturn)vo).setBillNo(returnBillNo);
                            ((InvoiceReturn)vo).setStatus(InvoiceReturnStatus.BILLED.getCode());
                            this.invoiceReturnAtomService.updateStatus((InvoiceReturnVO)vo);
                        }
                        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
                        inquiryPayOrderExt.setApplyNo(applyNo);
                        List<InquiryPayOrder> orders = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
                        for (InquiryPayOrder order : orders) {
                            BigDecimal payMoney = order.getPayMoney();
                            BigDecimal taxAmt = payMoney.divide(saleInvoiceInfo.getAmt(), 4, 4).multiply(saleInvoiceInfo.getTaxAmt());
                            taxAmt = taxAmt.setScale(2, 4);
                            BigDecimal untaxAmt = payMoney.subtract(taxAmt);
                            inquiryPayOrderExt = new InquiryPayOrderExt();
                            inquiryPayOrderExt.setPayOrderNo(order.getPayOrderNo());
                            inquiryPayOrderExt.setOrderStatus(OrderStatus.SEND_BILL.getCode());
                            inquiryPayOrderExt.setTaxAmt(taxAmt);
                            inquiryPayOrderExt.setUntaxAmt(untaxAmt);
                            this.inquiryPayOrderMapper.updateByPrimaryKeySelective(inquiryPayOrderExt);
                        }
                    }
                }
            }
        }
        return new PfscExtRspBaseBO();
    }
}

