/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiCreateEntryInfoService;
import com.tydic.pfsc.api.busi.bo.BusiCreateEntryInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiCreateEntryInfoRspBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.EntryInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.ReceiptInfoMapper;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.EntryInfoPO;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.ReceiptInfoPO;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.dao.vo.Statis;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiCreateEntryInfoService"})
public class BusiCreateEntryInfoServiceImpl
implements BusiCreateEntryInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiCreateEntryInfoServiceImpl.class);
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"addEntryInfo"})
    public BusiCreateEntryInfoRspBO addEntryInfo(@RequestBody BusiCreateEntryInfoReqBO reqBO) {
        BusiCreateEntryInfoRspBO rspBO = new BusiCreateEntryInfoRspBO();
        if (reqBO.getNotificationNo() == null && !StringUtils.hasText((String)reqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PayItemInfo> itemList = this.payItemInfoMapper.selectByNotifNo(reqBO.getNotificationNo());
        if (null == itemList || itemList.isEmpty()) {
            log.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + reqBO.getNotificationNo());
            return null;
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        if (billNotificationInfo == null) {
            log.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + reqBO.getNotificationNo());
            return null;
        }
        Statis statis = this.payInvoiceInfoMapper.invoiceStatis(reqBO.getNotificationNo());
        PayPurchaseOrderInfoVO payVO = new PayPurchaseOrderInfoVO();
        payVO.setNotificationNo(reqBO.getNotificationNo());
        List<PayPurchaseOrderInfo> payOrderList = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(payVO);
        Date entryDate = new Date();
        String entryNo = this.billSNService.getSnAsString(BillType.PURCHASE_STORAGE);
        for (PayItemInfo payItemInfo : itemList) {
            ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
            BeanUtils.copyProperties((Object)payItemInfo, (Object)receiptInfoPO);
            receiptInfoPO.setOrderNo(payItemInfo.getOrderId());
            receiptInfoPO.setNotTaxAmt(payItemInfo.getUntaxAmt());
            receiptInfoPO.setTaxPercent(payItemInfo.getTaxRate());
            receiptInfoPO.setEntryDate(entryDate);
            receiptInfoPO.setEntryNo(entryNo);
            this.receiptInfoMapper.insert(receiptInfoPO);
            Long supplierNo = null;
            for (PayPurchaseOrderInfo orderInfo : payOrderList) {
                if (orderInfo.getPurchaseOrderCode() == null || !orderInfo.getPurchaseOrderCode().equals(payItemInfo.getPurchaseOrderCode())) continue;
                supplierNo = orderInfo.getSupplierNo();
                break;
            }
            StocksDetail stocksDetail2 = this.stocksDetailMapper.selectBypurchaseUnitPriceSkuId(payItemInfo.getPurchaseUnitPrice(), payItemInfo.getSkuId());
            StocksDetail stocksDetail = new StocksDetail();
            if (stocksDetail2 == null) {
                BeanUtils.copyProperties((Object)payItemInfo, (Object)stocksDetail);
                stocksDetail.setEntryNo(entryNo);
                stocksDetail.setRemainQuality(payItemInfo.getQuantity());
                stocksDetail.setQuantity(payItemInfo.getQuantity());
                stocksDetail.setEntryDate(entryDate);
                stocksDetail.setSupplierNo(supplierNo);
                this.stocksDetailMapper.insert(stocksDetail);
                continue;
            }
            BigDecimal quantity = stocksDetail2.getQuantity();
            quantity = quantity.add(payItemInfo.getQuantity());
            stocksDetail.setQuantity(quantity);
            stocksDetail.setRemainQuality(quantity);
            stocksDetail.setSeq(stocksDetail2.getSeq());
            this.stocksDetailMapper.updateByPrimaryKeySelective(stocksDetail);
        }
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setEntryDate(entryDate);
        entryInfoPO.setEntryNo(entryNo);
        entryInfoPO.setEntryType(reqBO.getEntryType());
        entryInfoPO.setNotificationNo(reqBO.getNotificationNo());
        entryInfoPO.setPurchaseId(billNotificationInfo.getSupplierNo());
        entryInfoPO.setNotTaxAmt(statis.getTotUntaxAmt());
        entryInfoPO.setTax(statis.getTotTaxAmt());
        entryInfoPO.setAmt(statis.getTotAmt());
        entryInfoPO.setStatus("01");
        entryInfoPO.setSource(billNotificationInfo.getSource());
        entryInfoPO.setOprCompanyId(billNotificationInfo.getOperNo());
        entryInfoPO.setCreateUser(reqBO.getUserId());
        entryInfoPO.setBranchCompany(billNotificationInfo.getBranchCompany());
        this.entryInfoMapper.insert(entryInfoPO);
        rspBO.setEntryNo(entryNo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

