/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiExportOutstockInfoService;
import com.tydic.pfsc.api.busi.bo.BusiExportHeadOutstockInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportOutstockInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiExportOutstockInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiExportRowOutstockInfoRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.OutstockTotalMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.SupplierInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.OutstockDetail;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.OutstockTotal;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.po.SupplierInfo;
import com.tydic.pfsc.dao.vo.OutstockInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.AmountUtils;
import com.tydic.pfsc.utils.BeanUtils;
import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportOutstockInfoServiceImpl
implements BusiExportOutstockInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportOutstockInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;
    @Autowired
    private UserInfoService userInfoService;

    public BusiExportOutstockInfoRspBO exportOutstockInfo(BusiExportOutstockInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u51fa\u5e93\u5355\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO);
        }
        BusiExportOutstockInfoRspBO rspBO = new BusiExportOutstockInfoRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOutstockNo() == null) {
            throw new PfscExtBusinessException("0001", "\u51fa\u5e93\u5355\u53f7[outstockNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal sum = BigDecimal.ZERO;
        Long inspectionId = null;
        LinkedList<BusiExportRowOutstockInfoRspBO> rows = new LinkedList<BusiExportRowOutstockInfoRspBO>();
        List<OutstockDetail> list = this.outstockDetailMapper.selectByCondition(reqBO.getOutstockNo());
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        outstockInfoVO.setOutstockNo(reqBO.getOutstockNo());
        OutstockInfo outstockInfo = this.outstockInfoMapper.selectSelective(outstockInfoVO);
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(outstockInfo.getApplyNo());
        for (OutstockDetail outstockDetail : list) {
            BusiExportRowOutstockInfoRspBO row = new BusiExportRowOutstockInfoRspBO();
            row.setSeq(outstockDetail.getSeq());
            row.setSkuName(outstockDetail.getSkuName());
            row.setSpecModel(FscStringUtils.valueOf(outstockDetail.getSpec()) + FscStringUtils.valueOf(outstockDetail.getModel()));
            row.setUnitName(outstockDetail.getUnitName());
            row.setQuantity(NumberFormat.getInstance().format(outstockDetail.getQuantity()));
            row.setSaleUnitPrice(AmountUtils.format(outstockDetail.getSaleUnitPrice()));
            row.setUntaxAmt(AmountUtils.format(outstockDetail.getUntaxAmt()));
            row.setTaxRate(outstockDetail.getTaxRate());
            row.setTaxAmt(AmountUtils.format(outstockDetail.getTaxAmt()));
            StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
            if (stocksDetail != null && stocksDetail.getUntaxAmt() != null) {
                BigDecimal costAmount = stocksDetail.getUntaxAmt();
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                    SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                    saleItemInfoVO.setInspectionId(outstockDetail.getInspectionId());
                    saleItemInfoVO.setItemNo(outstockDetail.getItemNo());
                    saleItemInfoVO.setApplyNo(outstockInfo.getApplyNo());
                    List<SaleItemInfo> itemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(saleItemInfoVO);
                    if (!CollectionUtils.isEmpty(itemInfoList)) {
                        SaleItemInfo saleItemInfo = itemInfoList.get(0);
                        costAmount = costAmount.multiply(outstockDetail.getQuantity()).divide(saleItemInfo.getQuantity(), 2, 4);
                    }
                }
                row.setAmt(AmountUtils.format(costAmount));
                sum = sum.add(costAmount);
            }
            BeanUtils.null2DefaultValue(row);
            rows.add(row);
            inspectionId = outstockDetail.getInspectionId();
        }
        rspBO.setRows(rows);
        BusiExportHeadOutstockInfoRspBO head = new BusiExportHeadOutstockInfoRspBO();
        head.setCompanyName(this.orgService.queryOrgName(outstockInfo.getCompanyOrg()));
        head.setOutstockDate(sdf.format(outstockInfo.getOutstockDate()));
        head.setOutstockNo(reqBO.getOutstockNo());
        head.setSupplierName(this.orgService.querySupplierName(outstockInfo.getSupplierNo()));
        head.setPurchaseName(this.orgService.queryProjectName(outstockInfo.getPurchaseProjectId()).getAccountName());
        if (outstockInfo.getTotalNo() != null) {
            OutstockTotal selectByPrimaryKey = this.outstockTotalMapper.selectByPrimaryKey(outstockInfo.getTotalNo());
            head.setUserName(this.userInfoService.queryUserNameByUserId(selectByPrimaryKey.getUserId()));
            head.setOutstockUserName(this.userInfoService.queryUserNameByUserId(selectByPrimaryKey.getUserId()));
        }
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfo.getSource())) {
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(outstockInfo.getSupplierNo());
            if (supplierInfo != null) {
                head.setContractNumber(supplierInfo.getEffectContactNo());
            }
        } else if (inspectionId != null) {
            PayPurchaseOrderInfo purchaseOrder = new PayPurchaseOrderInfo();
            purchaseOrder.setInspectionId(inspectionId);
            purchaseOrder = this.payPurchaseOrderInfoMapper.getModelBy(purchaseOrder);
            if (purchaseOrder != null) {
                String cghtbh = purchaseOrder.getPlaAgreementCode();
                head.setContractNumber(cghtbh);
            }
        }
        head.setSource(outstockInfo.getSource());
        head.setContNumber("");
        head.setSumUntaxAmt(AmountUtils.format(outstockInfo.getUntaxAmt()));
        head.setSumTaxAmt(AmountUtils.format(outstockInfo.getTaxAmt()));
        head.setSumCost(AmountUtils.format(sum));
        head.setSum(AmountUtils.format(sum));
        head.setSumAmt(AmountUtils.format(outstockInfo.getUntaxAmt().add(outstockInfo.getTaxAmt())));
        BeanUtils.null2DefaultValue(head);
        rspBO.setHead(head);
        return rspBO;
    }
}

