/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiForConfirmQryAdvanceRecXbjService;
import com.tydic.pfsc.api.busi.bo.BusiForConfirmQryAdvanceRecXbjListRspBO;
import com.tydic.pfsc.api.busi.bo.BusiForConfirmQryAdvanceRecXbjReqBO;
import com.tydic.pfsc.api.busi.bo.BusiForConfirmQryAdvanceRecXbjRspBO;
import com.tydic.pfsc.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfsc.dao.AdvanceReceiveExtMapper;
import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.bo.AdvanceReceiveExtBO;
import com.tydic.pfsc.dao.po.AdvanceReceive;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.AdvanceReceiveVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.AdvanceReceiveStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.ReceiveType;
import com.tydic.pfsc.enums.SubAccountServiceType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.SubAccountService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiForConfirmQryAdvanceRecXbjServiceImpl
implements BusiForConfirmQryAdvanceRecXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiForConfirmQryAdvanceRecXbjServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    public BusiForConfirmQryAdvanceRecXbjListRspBO query(BusiForConfirmQryAdvanceRecXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e3a\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u8ba2\u5355\u6536\u6b3e\u786e\u8ba4\u67e5\u8be2\u94f6\u884c\u6d41\u6c34\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SubAcctInfoExt subAccInfoExt = this.subAccountService.getWithMainAccount(reqBO.getCompanyId(), OrderSource.ELECTRIC_AREA.getCode(), reqBO.getCompanyId(), null, SubAccountServiceType.DISTRIBUTE_BUSINESS.getCode());
        if (subAccInfoExt == null) {
            throw new PfscExtBusinessException("0001", "\u7535\u529b\u4e13\u533a\u7684\u914d\u9001\u4e1a\u52a1\u8d27\u6b3e\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        AdvanceReceiveVO queryVO = new AdvanceReceiveVO();
        queryVO.setTransferAcctName(reqBO.getTransferAcctName());
        queryVO.setTranAmt(reqBO.getTranAmt());
        queryVO.setPostDateBegin(reqBO.getPostDateBegin());
        queryVO.setPostDateEnd(reqBO.getPostDateEnd());
        queryVO.setRecSubAcct(subAccInfoExt.getSubAcctNo());
        queryVO.setOrderBy(" UNWRITEOFF_AMT desc, post_date desc ");
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectByConditionsList(queryVO);
        List<SaleOrderInfo> saleOrderList = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
            SaleOrderInfoVO querySaleVO = new SaleOrderInfoVO();
            querySaleVO.setInspectionIdList(reqBO.getInspectionIdList());
            querySaleVO.setOrderBy("t.ORDER_ID DESC, t.INSPECTION_ID DESC");
            saleOrderList = this.saleOrderInfoMapper.getList(querySaleVO);
            if (!CollectionUtils.isEmpty(saleOrderList)) {
                Long purchaseProjectId = saleOrderList.get(0).getPurchaseProjectId();
                for (SaleOrderInfo saleOrderInfo : saleOrderList) {
                    if (purchaseProjectId.equals(saleOrderInfo.getPurchaseProjectId())) continue;
                    throw new PfscExtBusinessException("0001", "\u8bf7\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
                }
            }
        }
        BusiForConfirmQryAdvanceRecXbjListRspBO rspBO = new BusiForConfirmQryAdvanceRecXbjListRspBO();
        LinkedList<BusiForConfirmQryAdvanceRecXbjRspBO> dataList = new LinkedList<BusiForConfirmQryAdvanceRecXbjRspBO>();
        HashMap<String, Integer> matchMap = new HashMap<String, Integer>();
        for (AdvanceReceive row : rows) {
            BusiForConfirmQryAdvanceRecXbjRspBO detail = new BusiForConfirmQryAdvanceRecXbjRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            this.match(detail, saleOrderList, matchMap);
            detail.setWriteoffAmt(row.getOrderAmt());
            detail.setRecOrgName(this.organizationInfoService.queryOrgName(row.getRecOrgId()));
            detail.setRecTypeName(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            dataList.add(detail);
        }
        AdvanceReceiveExtBO advanceReceiveExtBO = new AdvanceReceiveExtBO();
        advanceReceiveExtBO.setTransferAcctName(reqBO.getTransferAcctName());
        advanceReceiveExtBO.setPostDateBegin(reqBO.getPostDateBegin());
        advanceReceiveExtBO.setPostDateEnd(reqBO.getPostDateEnd());
        advanceReceiveExtBO.setTranAmt(reqBO.getTranAmt());
        advanceReceiveExtBO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        advanceReceiveExtBO.setRecOrgId(reqBO.getCompanyId());
        advanceReceiveExtBO.setSource("40");
        List<AdvanceReceiveExtBO> advanceExtList = this.advanceReceiveExtMapper.selectByConditionsList(advanceReceiveExtBO);
        for (AdvanceReceiveExtBO advanceReceiveExtBO2 : advanceExtList) {
            BusiForConfirmQryAdvanceRecXbjRspBO detail = new BusiForConfirmQryAdvanceRecXbjRspBO();
            BeanUtils.copyProperties((Object)advanceReceiveExtBO2, (Object)detail);
            this.match(detail, saleOrderList, matchMap);
            detail.setRecOrgName(this.organizationInfoService.queryOrgName(advanceReceiveExtBO2.getRecOrgId()));
            dataList.add(detail);
        }
        Collections.sort(dataList);
        rspBO.setRecXbjList(dataList);
        return rspBO;
    }

    private void match(BusiForConfirmQryAdvanceRecXbjRspBO detail, List<SaleOrderInfo> saleOrderList, Map<String, Integer> matchMap) {
        detail.setMatchStatus(Integer.valueOf(0));
        if (StringUtils.isEmpty((CharSequence)detail.getTransferAcctName()) || CollectionUtils.isEmpty(saleOrderList)) {
            return;
        }
        Iterator<SaleOrderInfo> iter = saleOrderList.iterator();
        while (iter.hasNext() && detail.getMatchStatus() == 0) {
            SaleOrderInfo order = iter.next();
            String projectName = this.organizationInfoService.queryProjectName(order.getPurchaseProjectId()).getAccountName();
            if (StringUtils.isEmpty((CharSequence)projectName) || StringUtils.isEmpty((CharSequence)detail.getTransferAcctName()) || !projectName.contains(detail.getTransferAcctName()) && !detail.getTransferAcctName().contains(projectName) || order.getOrderAmt().compareTo(detail.getTranAmt()) != 0) continue;
            iter.remove();
            detail.setMatchStatus(Integer.valueOf(1));
        }
        this.sortBySomeCondition(detail, saleOrderList, matchMap);
    }

    private void sortBySomeCondition(BusiForConfirmQryAdvanceRecXbjRspBO detail, List<SaleOrderInfo> saleOrderList, Map<String, Integer> matchMap) {
        int length = saleOrderList.size();
        for (int index = 0; index < length && detail.getSupplierNameSort() == 0; ++index) {
            SaleOrderInfo order = saleOrderList.get(index);
            String projectName = this.organizationInfoService.queryProjectName(order.getPurchaseProjectId()).getAccountName();
            if (StringUtils.isEmpty((CharSequence)projectName) || StringUtils.isEmpty((CharSequence)detail.getTransferAcctName()) || !projectName.contains(detail.getTransferAcctName()) && !detail.getTransferAcctName().contains(projectName)) continue;
            if (matchMap.get(projectName) != null) {
                detail.setSupplierNameSort(matchMap.get(projectName));
                continue;
            }
            detail.setSupplierNameSort(Integer.valueOf(length - index));
            matchMap.put(projectName, length - index);
        }
    }
}

