/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.DzcsInvoiceReturnPreApplyService;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnInvoiceRspBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnPreApplyReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnPreApplyRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.DzcsInvoiceReturnPreApplyService"})
public class DzcsInvoiceReturnPreApplyServiceImpl
implements DzcsInvoiceReturnPreApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnPreApplyServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    @PostMapping(value={"process"})
    public DzcsInvoiceReturnPreApplyRspBO process(@RequestBody DzcsInvoiceReturnPreApplyReqBO reqBO) {
        List applyNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u9884\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(applyNos = reqBO.getApplyNos()))) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u52fe\u9009");
        }
        DzcsInvoiceReturnPreApplyRspBO rspBO = null;
        try {
            String invoiceClasses = null;
            String invoiceType = null;
            String applyNo1 = FscStringUtils.list2String(applyNos, ",");
            rspBO = new DzcsInvoiceReturnPreApplyRspBO();
            ArrayList<DzcsInvoiceReturnInvoiceRspBO> invoices = new ArrayList<DzcsInvoiceReturnInvoiceRspBO>();
            rspBO.setInvoices(invoices);
            for (String applyNo : applyNos) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
                invoiceClasses = billApplyInfo.getInvoiceClasses();
                invoiceType = billApplyInfo.getInvoiceType();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo);
                List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                    DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                    invoices.add(invoice);
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                    invoice.setMatchFlag("0");
                    invoice.setSupplierName(reqBO.getSupName());
                    invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                    invoice.setOperUnitName(reqBO.getCompanyName());
                    invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                    invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                    invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                    invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                    invoice.setAmt(saleInvoiceInfo.getAmt());
                    invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                    invoice.setPurchaseProjectName(reqBO.getPurchaserAccountName());
                }
            }
            rspBO.setCreateUser(reqBO.getUsername());
            rspBO.setCreatePhone(reqBO.getCellphone());
            rspBO.setCreateOrg(reqBO.getOrgName());
            rspBO.setInvoiceClasses(invoiceClasses);
            rspBO.setNoticeItem(this.enumsService.queryDzcsInvoiceReturnNoticeItem());
            ArrayList files = new ArrayList();
            rspBO.setFiles(files);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        return rspBO;
    }
}

