/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.DzcsInvoiceReturnPushTaxSystemService;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnPushTaxSystemReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnPushTaxSystemRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.InvoiceReturnDzcsAtomService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnPushTaxSystemServiceImpl
implements DzcsInvoiceReturnPushTaxSystemService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnPushTaxSystemServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InvoiceReturnDzcsAtomService invoiceReturnDzcsAtomService;

    public DzcsInvoiceReturnPushTaxSystemRspBO process(DzcsInvoiceReturnPushTaxSystemReqBO reqBO) {
        String billNo;
        List billNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a8\u9001\u7a0e\u63a7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(billNos = reqBO.getBillNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        InvoiceReturnVO invoiceReturnVO = new InvoiceReturnVO();
        invoiceReturnVO.setBillNos(billNos);
        List<InvoiceReturn> invoiceReturns = this.invoiceReturnMapper.selectListBy(invoiceReturnVO);
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            if (!InvoiceReturnStatus.TO_BILL.getCode().equals(invoiceReturn.getStatus())) {
                throw new PfscExtBusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.TO_BILL));
            }
            InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
            for (InvoiceReturnDetail detail : details) {
                if (!StringUtils.hasText((String)detail.getApplyNo3())) {
                    throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7" + billNo + "\u8fd8\u6ca1\u6709\u751f\u6210\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u63a8\u9001\u7a0e\u63a7");
                }
                BillApplyInfo apply3 = this.billApplyInfoMapper.selectByPrimaryKey(detail.getApplyNo3());
                if (apply3 == null) {
                    throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7" + billNo + "\u8fd8\u6ca1\u6709\u751f\u6210\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u63a8\u9001\u7a0e\u63a7");
                }
                if (BillStatus.NO_APPLY.getCode().equals(apply3.getBillStatus())) continue;
                throw new PfscExtBusinessException("0001", "\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(BillStatus.NO_APPLY));
            }
        }
        for (InvoiceReturn invoiceReturn : invoiceReturns) {
            billNo = invoiceReturn.getBillNo();
            String invoiceClasses = null;
            InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
            vo.setBillNo(billNo);
            List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
            HashSet<String> applyNo3s = new HashSet<String>();
            for (InvoiceReturnDetail detail : details) {
                applyNo3s.add(detail.getApplyNo3());
            }
            for (String applyNo3 : applyNo3s) {
                BillApplyInfo apply3 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo3);
                invoiceClasses = apply3.getInvoiceClasses();
                if (!InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) continue;
                BillApplyInfo apply3Update = new BillApplyInfo();
                apply3Update.setApplyNo(applyNo3);
                apply3Update.setBillStatus(BillStatus.APPLIED.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(apply3Update);
            }
            invoiceReturnVO = new InvoiceReturnVO();
            invoiceReturnVO.setBillNo(billNo);
            if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
                invoiceReturnVO.setStatus(InvoiceReturnStatus.BILLED.getCode());
            } else {
                invoiceReturnVO.setStatus(InvoiceReturnStatus.BILLING.getCode());
            }
            this.invoiceReturnDzcsAtomService.updateStatus(invoiceReturnVO);
        }
        return new DzcsInvoiceReturnPushTaxSystemRspBO();
    }
}

