/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.api.deal.CreatePayOrderInfoService;
import com.tydic.pfsc.api.deal.bo.CreatePayOrderInfoReqBO;
import com.tydic.pfsc.api.deal.bo.CreatePayOrderInfoRspBO;
import com.tydic.pfsc.dao.BusiErrorLogMapper;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayOrderInfoPO;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.enums.PayOrderInfoType;
import com.tydic.pfsc.enums.PayOrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.CreatePayOrderInfoService"})
public class CreatePayOrderInfoServiceImpl
implements CreatePayOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderInfoServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource(name="dealServiceFeeSeq")
    private OrderSequence dealServiceFeeSeqService;
    @Autowired
    private BusiErrorLogMapper busiErrorLogMapper;
    @Autowired
    DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    TransactionDefinition transactionDefinition;

    @PostMapping(value={"add"})
    public CreatePayOrderInfoRspBO add(@RequestBody CreatePayOrderInfoReqBO reqBO) {
        logger.debug("\u65b0\u589e\u670d\u52a1\u8d39\u7684\u7f34\u8d39\u5355\u670d\u52a1\u5165\u53c2CreatePayOrderInfoForMonthReqBO\uff1a" + reqBO.toString());
        CreatePayOrderInfoRspBO rspBO = new CreatePayOrderInfoRspBO();
        if (null == reqBO.getOrderCodes() || reqBO.getOrderCodes().isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[orderCodes]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierNo()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierName()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[supplierName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            logger.debug("\u67e5\u8be2\u672a\u5904\u7406\u7684\u8ba2\u5355\u4fe1\u606f\u5f00\u59cb ");
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            payPurchaseOrderInfoVO.setOrderCodes(reqBO.getOrderCodes());
            payPurchaseOrderInfoVO.setIsPayFlag("0");
            List<PayPurchaseOrderInfo> list = this.payPurchaseOrderInfoMapper.getListForDealServiceFee(payPurchaseOrderInfoVO);
            logger.debug("\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c:" + list.toString());
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (!list.isEmpty()) {
                for (PayPurchaseOrderInfo payPurchaseOrderInfo : list) {
                    bigDecimal = bigDecimal.add(payPurchaseOrderInfo.getOrderDealServiceFee());
                }
            }
            SimpleDateFormat simple = new SimpleDateFormat("yyyyMM");
            PayOrderInfoPO payOrderInfoPO = new PayOrderInfoPO();
            Long payOrderId = this.dealServiceFeeSeqService.nextId();
            payOrderInfoPO.setPayOrderId(payOrderId);
            String no = String.format("%6d", payOrderId).replace(" ", "0");
            StringBuffer payOrderCode = new StringBuffer(simple.format(new Date()));
            payOrderCode.append("-FWF-").append(no);
            payOrderInfoPO.setPayOrderCode(payOrderCode.toString());
            payOrderInfoPO.setPayOrderType(PayOrderInfoType.MONTH_SERVICE_FEE.getCode());
            payOrderInfoPO.setCreateTime(new Date());
            payOrderInfoPO.setOrderCount(Long.valueOf(list.size()));
            payOrderInfoPO.setDocumentAmount(bigDecimal);
            payOrderInfoPO.setActualAmount(bigDecimal);
            payOrderInfoPO.setDeductionAmount(BigDecimal.ZERO);
            payOrderInfoPO.setSupplierId(reqBO.getSupplierNo());
            payOrderInfoPO.setSupplierName(reqBO.getSupplierName());
            payOrderInfoPO.setPayOrderStatus(PayOrderStatus.PROCESSING.getCode());
            this.payOrderInfoMapper.insert(payOrderInfoPO);
            this.updateOrderInfoTOPay(list, payOrderId, payOrderCode.toString());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u5931\u8d25:" + e);
            throw new PfscExtBusinessException("18000", "\u65b0\u589e\u670d\u52a1\u8d39\u7f34\u8d39\u5355\u5931\u8d25");
        }
        return rspBO;
    }

    private void updateOrderInfoTOPay(List<PayPurchaseOrderInfo> list, Long payOrderId, String payOrderCode) {
        if (!list.isEmpty()) {
            try {
                this.payPurchaseOrderInfoMapper.updatePayOrderInfo(list, payOrderId, payOrderCode, "1");
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u8ba2\u5355\u6570\u636e\u5931\u8d25");
            }
        }
    }
}

