/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom;

import com.tydic.pfsc.dao.SubAcctInfoMapper;
import com.tydic.pfsc.dao.po.SubAcctInfo;
import com.tydic.pfsc.enums.SubAccountStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.SubAccountTransLogService;
import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="accountTransferService")
public class AccountTransferService {
    private static final Log logger = LogFactory.getLog(AccountTransferService.class);
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private SubAccountTransLogService acTransLog;

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
    public void tranProcess(String fromAcctNo, String toAcctNo, BigDecimal amount, long busiTxnNo, boolean canOverDraft) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--\u5b50\u8d26\u6237\u8f6c\u8d26(\u72ec\u7acb\u4e8b\u52a1),\u8f6c\u51fa:" + fromAcctNo + ",\u8f6c\u5165:" + toAcctNo + ",\u91d1\u989d:" + amount + ",\u4e1a\u52a1\u53f7:" + busiTxnNo));
        }
        this.withdrawal(fromAcctNo, amount, busiTxnNo, true);
        this.deposit(toAcctNo, amount, busiTxnNo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--\u5b50\u8d26\u6237\u8f6c\u8d26\u5b8c\u6210(\u72ec\u7acb\u4e8b\u52a1),\u4e1a\u52a1\u53f7:" + busiTxnNo));
        }
    }

    public void tranProcessWithoutTransactional(String fromAcctNo, String toAcctNo, BigDecimal amount, long busiTxnNo, boolean canOverDraft) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--\u5b50\u8d26\u6237\u8f6c\u8d26,\u8f6c\u51fa:" + fromAcctNo + ",\u8f6c\u5165:" + toAcctNo + ",\u91d1\u989d:" + amount + ",\u4e1a\u52a1\u53f7:" + busiTxnNo));
        }
        this.withdrawal(fromAcctNo, amount, busiTxnNo, true);
        this.deposit(toAcctNo, amount, busiTxnNo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--\u5b50\u8d26\u6237\u8f6c\u8d26\u5b8c\u6210,\u4e1a\u52a1\u53f7:" + busiTxnNo));
        }
    }

    private long deposit(String subAcctNo, BigDecimal amount, long txnNo) {
        BigDecimal newBal;
        if (!StringUtils.hasText((String)subAcctNo)) {
            throw new PfscExtBusinessException("0001", "\u5b58\u5165\u5931\u8d25,\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u5b58\u5165\u5931\u8d25,\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectLockPrimaryKey(subAcctNo);
        if (subAcctInfo == null) {
            logger.error((Object)("\u5b50\u8d26\u53f7\u5b58\u5165\u5904\u7406\u5931\u8d25,\u5b50\u8d26\u53f7" + subAcctNo + "\u4e0d\u5b58\u5728"));
            throw new PfscExtBusinessException("18001", "\u5b58\u5165\u5931\u8d25,\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!SubAccountStatus.ACTIVED.getCode().equals(subAcctInfo.getStatus())) {
            logger.error((Object)("\u5b50\u8d26\u53f7\u5b58\u5165\u5904\u7406\u5931\u8d25,\u5b50\u8d26\u53f7" + subAcctNo + "\u4e0d\u5728\u542f\u7528\u72b6\u6001"));
            throw new PfscExtBusinessException("18003", "\u5b58\u5165\u5931\u8d25,\u76ee\u524d" + subAcctInfo.getSubAcctName() + "\u8d26\u53f7\u4e0d\u5728\u542f\u7528\u72b6\u6001");
        }
        BigDecimal bal = subAcctInfo.getBalance();
        BigDecimal userdOverdraft = newBal = bal.add(amount);
        if (newBal.compareTo(BigDecimal.ZERO) >= 0) {
            userdOverdraft = BigDecimal.ZERO;
        }
        long acctingSn = this.acTransLog.addLog(subAcctNo, "CR", subAcctInfo.getCcy(), txnNo, amount, bal, newBal);
        SubAcctInfo forUpdate = new SubAcctInfo();
        forUpdate.setSubAcctNo(subAcctNo);
        forUpdate.setBalance(newBal);
        forUpdate.setUsedOverdraft(userdOverdraft);
        this.subAcctInfoMapper.updateByPrimaryKeySelective(forUpdate);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deposit(\u5b58\u6b3e) success,acNo=" + subAcctNo + ",amount=" + amount + ",acTransSeqNo=" + acctingSn));
        }
        return acctingSn;
    }

    private long withdrawal(String subAcctNo, BigDecimal amount, long txnNo, boolean allowOverdraft) {
        if (!StringUtils.hasText((String)subAcctNo)) {
            throw new PfscExtBusinessException("0001", "\u63d0\u53d6\u5931\u8d25,\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (null == amount || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u63d0\u53d6\u5931\u8d25,\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectLockPrimaryKey(subAcctNo);
        if (null == subAcctInfo) {
            logger.error((Object)("\u5b50\u8d26\u53f7\u63d0\u53d6\u5904\u7406\u5931\u8d25,\u5b50\u8d26\u53f7" + subAcctNo + "\u4e0d\u5b58\u5728"));
            throw new PfscExtBusinessException("18001", "\u63d0\u53d6\u5931\u8d25,\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!SubAccountStatus.ACTIVED.getCode().equals(subAcctInfo.getStatus())) {
            logger.error((Object)("\u5b50\u8d26\u53f7\u63d0\u53d6\u5904\u7406\u5931\u8d25,\u5b50\u8d26\u53f7" + subAcctNo + "\u4e0d\u5728\u542f\u7528\u72b6\u6001"));
            throw new PfscExtBusinessException("18003", "\u63d0\u53d6\u5931\u8d25,\u76ee\u524d" + subAcctInfo.getSubAcctName() + "\u8d26\u53f7\u4e0d\u5728\u542f\u7528\u72b6\u6001");
        }
        BigDecimal bal = subAcctInfo.getBalance();
        BigDecimal freeBal = subAcctInfo.getValidBalance(allowOverdraft);
        if (freeBal.compareTo(amount) < 0) {
            logger.error((Object)("\u5b50\u8d26\u53f7\u6263\u6b3e\u5931\u8d25,\u4f59\u989d\u4e0d\u8db3,acctNo=" + subAcctNo + ",\u53ef\u7528\u4f59\u989d=" + freeBal.toString() + ",\u6263\u6b3e=" + amount.toString()));
            throw new PfscExtBusinessException("18000", "\u63d0\u53d6\u5931\u8d25,\u53ef\u7528\u4f59\u989d\u4e0d\u8db3");
        }
        BigDecimal newBal = bal.subtract(amount);
        BigDecimal userdOverdraft = BigDecimal.ZERO;
        if (newBal.compareTo(BigDecimal.ZERO) < 0) {
            userdOverdraft = newBal.negate();
        }
        long acctingSn = this.acTransLog.addLog(subAcctNo, "DR", subAcctInfo.getCcy(), txnNo, amount, bal, newBal);
        SubAcctInfo forUpdate = new SubAcctInfo();
        forUpdate.setSubAcctNo(subAcctNo);
        forUpdate.setBalance(newBal);
        forUpdate.setUsedOverdraft(userdOverdraft);
        this.subAcctInfoMapper.updateByPrimaryKeySelective(forUpdate);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Withdrawal(\u63d0\u6b3e) success,acNo=" + subAcctNo + ",\u6263\u6b3e=" + amount + ",acTransSeqNo=" + acctingSn + ",\u65b0\u4f59\u989d=" + newBal + ",\u5df2\u900f\u652f=" + userdOverdraft));
        }
        return acctingSn;
    }
}

