/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiLoadMainAcctService;
import com.tydic.pfsc.api.busi.bo.BusiLoadMainAcctReqBO;
import com.tydic.pfsc.api.busi.bo.BusiLoadMainAcctRspBO;
import com.tydic.pfsc.dao.po.MainAcctInfo;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.MainAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiLoadMainAcctServiceImpl
implements BusiLoadMainAcctService {
    private static final Logger logger = LoggerFactory.getLogger(BusiLoadMainAcctServiceImpl.class);
    @Autowired
    private MainAccountService mainAccountService;
    @Autowired
    private EnumsService enumsService;

    public BusiLoadMainAcctRspBO loadMainAcct(BusiLoadMainAcctReqBO busiLoadMainAcctReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u52a0\u8f7d\u4e3b\u8d26\u53f7\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiLoadMainAcctReqBO.toString());
        }
        if (null == busiLoadMainAcctReqBO.getMainAcctNo() && (busiLoadMainAcctReqBO.getCompanyId() == null || busiLoadMainAcctReqBO.getSource() == null)) {
            throw new PfscExtBusinessException("18000", "\u4e3b\u8d26\u53f7\u548c\u673a\u6784\u53f7\u3001\u6765\u6e90\u5176\u4e2d\u4e00\u4e2a\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u4e3b\u8d26\u53f7\u6216\u673a\u6784\u53f7\u548c\u6765\u6e90\uff01");
        }
        MainAcctInfo mainAcctInfo = new MainAcctInfo();
        mainAcctInfo.setOrgId(busiLoadMainAcctReqBO.getCompanyId());
        mainAcctInfo.setSource(busiLoadMainAcctReqBO.getSource());
        mainAcctInfo.setMainAcctNo(busiLoadMainAcctReqBO.getMainAcctNo());
        MainAcctInfo loadMainAcct = this.mainAccountService.loadAccount(mainAcctInfo);
        BusiLoadMainAcctRspBO busiLoadMainAcctRspBO = new BusiLoadMainAcctRspBO();
        if (loadMainAcct != null) {
            busiLoadMainAcctRspBO.setCompanyId(loadMainAcct.getOrgId());
            busiLoadMainAcctRspBO.setSource(loadMainAcct.getSource());
            busiLoadMainAcctRspBO.setMainAcctNo(loadMainAcct.getMainAcctNo());
            busiLoadMainAcctRspBO.setMainAcctName(loadMainAcct.getMainAcctName());
            busiLoadMainAcctRspBO.setOpenBank(loadMainAcct.getOpenBank());
            busiLoadMainAcctRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)loadMainAcct.getSource())));
            logger.debug(busiLoadMainAcctRspBO.toString());
            return busiLoadMainAcctRspBO;
        }
        logger.error("\u52a0\u8f7d\u4e3b\u8d26\u53f7\u4fe1\u606f\u4e1a\u52a1\u670d\u52a1-\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728");
        throw new PfscExtBusinessException("18000", "\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728");
    }
}

