/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryBillApplyInfoListService;
import com.tydic.pfsc.api.busi.bo.BusiQryBillApplyInfoListReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryBillApplyInfoListRspBO;
import com.tydic.pfsc.api.busi.bo.QryBillApplyInfoBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfoForOper;
import com.tydic.pfsc.dao.vo.BillApplyInfoForOperVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.PaySataus;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQryBillApplyInfoListService"})
public class BusiQryBillApplyInfoListServiceImpl
implements BusiQryBillApplyInfoListService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryBillApplyInfoListServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;

    @PostMapping(value={"qryBillApplyInfoList"})
    public BusiQryBillApplyInfoListRspBO qryBillApplyInfoList(@RequestBody BusiQryBillApplyInfoListReqBO reqBO) {
        BusiQryBillApplyInfoListRspBO rspBO = new BusiQryBillApplyInfoListRspBO();
        log.error("\u8fd0\u8425\u65b9\u5f00\u7968\u7533\u8bf7\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2:" + reqBO);
        ArrayList<QryBillApplyInfoBO> billList = new ArrayList<QryBillApplyInfoBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        BillApplyInfoForOperVO billApplyInfoForOperVO = new BillApplyInfoForOperVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)billApplyInfoForOperVO);
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            billApplyInfoForOperVO.setOperUnitNo(reqBO.getCompanyId());
        } else {
            billApplyInfoForOperVO.setOperUnitNo(null);
        }
        List<BillApplyInfoForOper> billApplyInfoForOperList = this.billApplyInfoMapper.getListForOperPage(billApplyInfoForOperVO, (Page<Map<String, Object>>)page);
        if (billApplyInfoForOperList != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (BillApplyInfoForOper saleVO : billApplyInfoForOperList) {
                String supplierName;
                QryBillApplyInfoBO saleExtBO = new QryBillApplyInfoBO();
                BeanUtils.copyProperties((Object)saleVO, (Object)saleExtBO);
                saleExtBO.setBillStatusStr(this.enumsService.getDescr(BillStatus.getInstance(saleExtBO.getBillStatus())));
                saleExtBO.setPayStatusStr(this.enumsService.getDescr(PaySataus.getInstance(saleExtBO.getPayStatus())));
                saleExtBO.setApplyUserName(this.userInfoService.queryUserNameByUserId(saleExtBO.getUserId()));
                if (!StringUtils.isEmpty((Object)saleExtBO.getInvoiceType())) {
                    saleExtBO.setInvoiceTypeStr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.parseInt(saleExtBO.getInvoiceType()))));
                }
                if ((supplierName = this.organizationInfoService.querySupplierName(saleExtBO.getSupplierNo())) != null) {
                    saleExtBO.setSupplierName(supplierName);
                }
                if (!ids.contains(saleVO.getPurchaseProjectId())) {
                    ids.add(saleVO.getPurchaseProjectId());
                }
                billList.add(saleExtBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            rspBO.setRows(billList);
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        return rspBO;
    }
}

