/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryOutstockTotalService;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockTotalReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockTotalRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockTotalShowRspBO;
import com.tydic.pfsc.api.busi.bo.SaleOrderDetailInfoRspBO;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.OutstockTotalMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.OutstockInfoVO;
import com.tydic.pfsc.dao.vo.OutstockTotalVO;
import com.tydic.pfsc.dao.vo.QueryOutstockInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.WFStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.UserInfoService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQueryOutstockTotalService"})
public class BusiQueryOutstockTotalServiceImpl
implements BusiQueryOutstockTotalService {
    private final OutstockTotalMapper outstockTotalMapper;
    private final OrganizationInfoService organizationInfoService;
    private final EnumsService enumsService;
    private final UserInfoService userInfoService;
    private final OutstockInfoMapper outstockInfoMapper;
    private final SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryOutstockTotalServiceImpl(OutstockTotalMapper outstockTotalMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService, UserInfoService userInfoService, OutstockInfoMapper outstockInfoMapper, SaleOrderInfoMapper saleOrderInfoMapper) {
        this.outstockTotalMapper = outstockTotalMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
        this.userInfoService = userInfoService;
        this.outstockInfoMapper = outstockInfoMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
    }

    @PostMapping(value={"queryListPage"})
    public BusiQueryOutstockTotalRspBO queryListPage(@RequestBody BusiQueryOutstockTotalReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockTotalRspBO rspPageBO = new BusiQueryOutstockTotalRspBO();
        rspPageBO.setRespCode("0000");
        OutstockTotalVO outstockTotalVO = new OutstockTotalVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)outstockTotalVO);
        outstockTotalVO.setUserId(reqBO.getUserIdNew());
        outstockTotalVO.setOrgId(reqBO.getCompanyId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<OutstockTotalVO> list = this.outstockTotalMapper.getListPageExt(outstockTotalVO, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspPageBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u51fa\u5e93\u6c47\u603b\u5355");
            return rspPageBO;
        }
        LinkedList<BusiQueryOutstockTotalShowRspBO> outstockTotalList = new LinkedList<BusiQueryOutstockTotalShowRspBO>();
        for (OutstockTotalVO outstockTotal : list) {
            BusiQueryOutstockTotalShowRspBO showRspBO = new BusiQueryOutstockTotalShowRspBO();
            BeanUtils.copyProperties((Object)outstockTotal, (Object)showRspBO);
            showRspBO.setCompanyName(this.organizationInfoService.queryOrgName(outstockTotal.getOrgId()));
            showRspBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockTotal.getSource())));
            showRspBO.setAmount(outstockTotal.getTaxAmt().add(outstockTotal.getUntaxAmt()));
            if (StringUtils.hasText((String)showRspBO.getApprovalStatus())) {
                showRspBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(showRspBO.getApprovalStatus())));
            }
            showRspBO.setLastOperator(this.userInfoService.queryUserNameByUserId(outstockTotal.getLastOperator()));
            showRspBO.setUserIdNew(outstockTotal.getUserId());
            showRspBO.setUserName(this.userInfoService.queryUserNameByUserId(outstockTotal.getUserId()));
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(outstockTotal.getSource())) {
                OutstockInfoVO queryOutStockVO = new OutstockInfoVO();
                queryOutStockVO.setTotalNo(outstockTotal.getTotalNo());
                List<OutstockInfo> ostInfoList = this.outstockInfoMapper.selectByCondition(queryOutStockVO);
                LinkedList<String> outstockNoList = new LinkedList<String>();
                for (OutstockInfo ostInfo : ostInfoList) {
                    outstockNoList.add(ostInfo.getOutstockNo());
                }
                if (CollectionUtils.isNotEmpty(outstockNoList)) {
                    QueryOutstockInfoVO outstockVO = new QueryOutstockInfoVO();
                    outstockVO.setOutstockNoList(outstockNoList);
                    List<Long> inspectionIds = this.outstockInfoMapper.selectInspectionIdsByCondition(outstockVO);
                    if (!CollectionUtils.isEmpty(inspectionIds)) {
                        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                        saleOrderInfoVO.setInspectionIdList(inspectionIds);
                        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                        for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                            SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                            detailRspBO.setInspectionId(orderInfo.getInspectionId());
                            detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                            detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                            saleOrderDetailList.add(detailRspBO);
                        }
                    }
                }
            }
            showRspBO.setSaleOrderDetailList(saleOrderDetailList);
            outstockTotalList.add(showRspBO);
        }
        rspPageBO.setRespDesc("\u67e5\u8be2\u51fa\u5e93\u6c47\u603b\u5355\u6210\u529f");
        rspPageBO.setRows(outstockTotalList);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

