/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceDetailReqBO;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.InvoiceReturnDzcsAtomService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class BusiBackInvoiceDzcsInvoiceReturnService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBackInvoiceDzcsInvoiceReturnService.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private InvoiceReturnDzcsAtomService invoiceReturnDzcsAtomService;

    public PfscExtRspBaseBO addInv(BusiBackInvoiceReqBO reqBO) {
        Object invoiceReturnVO;
        InvoiceReturnDetail detail;
        Object vo;
        BillApplyInfo apply;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7a0e\u63a7\u56de\u4f20\u53d1\u7968\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        String applyNo = reqBO.getBill_no();
        String invoiceNo = reqBO.getInvoice_num();
        String invoiceStatus = String.valueOf(reqBO.getInvoice_state());
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            logger.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]");
        }
        String returnBillNo = billApplyInfo.getReturnBillNo();
        SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
        if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoiceStatus)) {
            List<String> invoiceNos;
            if (saleInvoiceInfo == null) {
                logger.error("\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("18000", "\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002");
            }
            SaleInvoiceInfo record = new SaleInvoiceInfo();
            record.setInvoiceNo(invoiceNo);
            record.setInvoiceStatus(invoiceStatus);
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(record);
            if (BillStatus.SEND_BILL.getCode().equals(billApplyInfo.getBillStatus()) && CollectionUtils.isEmpty(invoiceNos = this.saleInvoiceInfoMapper.getInvoiceNoByApplyNo(applyNo))) {
                BillApplyInfo apply2 = new BillApplyInfo();
                apply2.setApplyNo(applyNo);
                apply2.setBillStatus(BillStatus.INVOICE_INVALID.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(apply2);
            }
            return new PfscExtRspBaseBO();
        }
        if (saleInvoiceInfo != null) {
            logger.error("\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u56de\u4f20\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18000", "\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u56de\u4f20\u3002");
        }
        if (BillStatus.INVOICE_INVALID.getCode().equals(billApplyInfo.getBillStatus())) {
            apply = new BillApplyInfo();
            apply.setApplyNo(applyNo);
            apply.setBillStatus(BillStatus.SENDING_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(apply);
            billApplyInfo.setBillStatus(BillStatus.SENDING_BILL.getCode());
        }
        if (BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
            apply = new BillApplyInfo();
            apply.setApplyNo(applyNo);
            apply.setBillStatus(BillStatus.SENDING_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(apply);
            billApplyInfo.setBillStatus(BillStatus.SENDING_BILL.getCode());
        }
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        for (BusiBackInvoiceDetailReqBO detailReqBO : reqBO.getDetail()) {
            if (!StringUtils.hasText((String)detailReqBO.getOrder_no())) {
                throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7[order_no]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getLines_number()) {
                throw new PfscExtBusinessException("0001", "\u884c\u53f7[lines_number]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getMateriel_name())) {
                throw new PfscExtBusinessException("0001", "\u7269\u6599\u540d\u79f0[materiel_name]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getAmount()) {
                throw new PfscExtBusinessException("0001", "\u91d1\u989d(\u4e0d\u542b\u7a0e) [amount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTax()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u989d [tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTax_rate()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u7387 [tax_rate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getTax_class_code())) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801 [tax_class_code]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sumUntaxAmt = sumUntaxAmt.add(detailReqBO.getAmount());
            sumTaxAmt = sumTaxAmt.add(detailReqBO.getTax());
        }
        if (sumUntaxAmt.compareTo(new BigDecimal(reqBO.getInvoice_amount())) != 0) {
            logger.error("\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (sumTaxAmt.compareTo(new BigDecimal(reqBO.getInvoice_tax())) != 0) {
            logger.error("\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        saleInvoiceInfo = new SaleInvoiceInfo();
        saleInvoiceInfo.setInvoiceNo(invoiceNo);
        saleInvoiceInfo.setInvoiceCode(reqBO.getInvoice_code());
        try {
            saleInvoiceInfo.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").parse(reqBO.getInvoice_date()));
        }
        catch (ParseException e) {
            logger.error("\u5f00\u7968\u65e5\u671f[" + reqBO.getInvoice_date() + "]\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u5165\u53c2=" + reqBO, (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u65e5\u671f[" + reqBO.getInvoice_date() + "]\u7684\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        saleInvoiceInfo.setApplyNo(applyNo);
        saleInvoiceInfo.setUntaxAmt(new BigDecimal(reqBO.getInvoice_amount()));
        saleInvoiceInfo.setTaxAmt(new BigDecimal(reqBO.getInvoice_tax()));
        saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
        saleInvoiceInfo.setInvoiceStatus(invoiceStatus);
        this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
        SaleInvoiceInfoVO saleInvoiceData = new SaleInvoiceInfoVO();
        saleInvoiceData.setApplyNo(applyNo);
        saleInvoiceData.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
        SaleInvoiceInfo saleInvoiceSumInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceData);
        if (saleInvoiceSumInfo.getAmt().abs().compareTo(billApplyInfo.getAmt().abs()) > 0) {
            logger.error("\u56de\u4f20\u7684\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d,\u8bf7\u5148\u4f5c\u5e9f\u65e0\u6548\u53d1\u7968[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18000", "\u56de\u4f20\u7684\u53d1\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d,\u8bf7\u5148\u4f5c\u5e9f\u65e0\u6548\u53d1\u7968");
        }
        List<InvoiceReturnDetail> invoiceReturnDetails = null;
        if (RedBlue.RED.getCode().equals(billApplyInfo.getRedBlue())) {
            vo = new InvoiceReturnDetailVO();
            ((InvoiceReturnDetail)vo).setBillNo(returnBillNo);
            ((InvoiceReturnDetail)vo).setApplyNo2(applyNo);
            invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
        } else if (RedBlue.BLUE.getCode().equals(billApplyInfo.getRedBlue())) {
            vo = new InvoiceReturnDetailVO();
            ((InvoiceReturnDetail)vo).setBillNo(returnBillNo);
            ((InvoiceReturnDetail)vo).setApplyNo3(applyNo);
            invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList((InvoiceReturnDetailVO)vo);
        }
        for (BusiBackInvoiceDetailReqBO detailBO : reqBO.getDetail()) {
            Long inspectionId = Long.valueOf(detailBO.getOrder_no());
            Long itemNo = detailBO.getLines_number();
            BigDecimal taxAmt = detailBO.getTax();
            BigDecimal untaxAmt = detailBO.getAmount();
            BigDecimal amount = taxAmt.add(untaxAmt);
            SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
            saleInvoiceDetail.setItemName(detailBO.getMateriel_name());
            saleInvoiceDetail.setSpecModel(detailBO.getMateriel_standard());
            saleInvoiceDetail.setUnitName(detailBO.getMateriel_unit());
            saleInvoiceDetail.setQuantity(detailBO.getQuantity());
            saleInvoiceDetail.setUntaxAmt(untaxAmt);
            saleInvoiceDetail.setTaxAmt(taxAmt);
            saleInvoiceDetail.setAmount(amount);
            saleInvoiceDetail.setTaxRate(detailBO.getTax_rate());
            saleInvoiceDetail.setTaxClassCode(detailBO.getTax_class_code());
            saleInvoiceDetail.setInspectionId(inspectionId);
            saleInvoiceDetail.setItemNo(itemNo);
            saleInvoiceDetail.setInvoiceNo(invoiceNo);
            try {
                BigDecimal saleUnitPrice = saleInvoiceDetail.getAmount().divide(saleInvoiceDetail.getQuantity(), 2, 4);
                saleInvoiceDetail.setSaleUnitPrice(saleUnitPrice);
            }
            catch (Exception e) {
                logger.error("\u8ba1\u7b97\u5355\u4ef7\u51fa\u9519[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO, (Throwable)e);
            }
            this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
        }
        if (saleInvoiceSumInfo.getAmt().abs().compareTo(billApplyInfo.getAmt().abs()) >= 0) {
            BillApplyInfo apply3 = new BillApplyInfo();
            apply3.setApplyNo(applyNo);
            apply3.setBillStatus(BillStatus.SEND_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(apply3);
        }
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
        List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        if (RedBlue.RED.getCode().equals(billApplyInfo.getRedBlue())) {
            int index = 0;
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                if (saleInvoiceInfos.size() > index) {
                    detail = new InvoiceReturnDetail();
                    detail.setSeq(invoiceReturnDetail.getSeq());
                    detail.setInvoiceNo2(saleInvoiceInfos.get(index).getInvoiceNo());
                    this.invoiceReturnDetailMapper.updateByPrimaryKeySelective(detail);
                }
                ++index;
            }
            invoiceReturnVO = new InvoiceReturnVO();
            ((InvoiceReturn)invoiceReturnVO).setBillNo(returnBillNo);
            ((InvoiceReturn)invoiceReturnVO).setStatus(InvoiceReturnStatus.RETURNED.getCode());
            ((InvoiceReturnVO)invoiceReturnVO).setInvoiceReturnChannel("2");
            this.invoiceReturnDzcsAtomService.updateStatus((InvoiceReturnVO)invoiceReturnVO);
        } else if (RedBlue.BLUE.getCode().equals(billApplyInfo.getRedBlue())) {
            int index = 0;
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                if (saleInvoiceInfos.size() > index) {
                    detail = new InvoiceReturnDetail();
                    detail.setSeq(invoiceReturnDetail.getSeq());
                    detail.setInvoiceNo3(saleInvoiceInfos.get(index).getInvoiceNo());
                    this.invoiceReturnDetailMapper.updateByPrimaryKeySelective(detail);
                }
                ++index;
            }
            invoiceReturnVO = new InvoiceReturnVO();
            ((InvoiceReturn)invoiceReturnVO).setBillNo(returnBillNo);
            ((InvoiceReturn)invoiceReturnVO).setStatus(InvoiceReturnStatus.BILLED.getCode());
            this.invoiceReturnDzcsAtomService.updateStatus((InvoiceReturnVO)invoiceReturnVO);
        }
        return new PfscExtRspBaseBO();
    }
}

