/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourReqBO;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.PayOrderInfoPO;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.atour.api.BillInfoUploadExternalService;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtReqBO;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtRspBO;
import com.tydic.pfsc.external.atour.api.bo.MessageBO;
import com.tydic.pfsc.external.atour.api.bo.SalesBillDetailsBO;
import com.tydic.pfsc.external.atour.api.bo.SalesBillMainBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.umcext.ability.org.UmcACompanyInfoDetailAbilityService;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceReqBO;
import com.tydic.umcext.ability.org.bo.UmcACompanyInfoDetailAbilityServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService"})
public class BusiInvoiceIssueAtourServiceImpl
implements BusiInvoiceIssueAtourService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceIssueAtourServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillInfoUploadExternalService billInfoUploadExternalService;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private UmcACompanyInfoDetailAbilityService umcACompanyInfoDetailAbilityService;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"invoiceIssue"})
    public BusiInvoiceIssueAtourRspBO invoiceIssue(@RequestBody BusiInvoiceIssueAtourReqBO busiInvoiceIssueAtourReqBO) {
        if (null == busiInvoiceIssueAtourReqBO.getApplyNoList() || busiInvoiceIssueAtourReqBO.getApplyNoList().size() == 0) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiInvoiceIssueAtourRspBO rspBO = new BusiInvoiceIssueAtourRspBO();
        List applyNoList = busiInvoiceIssueAtourReqBO.getApplyNoList();
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            throw new PfscExtBusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4");
        }
        if (busiInvoiceIssueAtourReqBO.getRejectionContent() != null && busiInvoiceIssueAtourReqBO.getRejectionContent() != "") {
            billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setApplyNoList(applyNoList);
            billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setBillStatus(BillStatus.REJECTION_APPLY.getCode());
            billApplyInfo.setAuthDate(new Date());
            billApplyInfo.setAuthRemark(busiInvoiceIssueAtourReqBO.getRejectionContent());
            billApplyInfo.setAuthUser(busiInvoiceIssueAtourReqBO.getUsername());
            this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNoList(applyNoList);
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setOrderStatus("00");
            this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, saleOrderInfo);
            return rspBO;
        }
        for (String applyNo : applyNoList) {
            Integer applyStatus = busiInvoiceIssueAtourReqBO.getApplyStatus();
            BusiQueryDetailBillApplyInfoReqBO reqBO = new BusiQueryDetailBillApplyInfoReqBO();
            reqBO.setApplyNo(applyNo);
            BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO = this.queryApply(reqBO);
            UmcACompanyInfoDetailAbilityServiceReqBO umcACompanyInfoDetailAbilityServiceReqBO = new UmcACompanyInfoDetailAbilityServiceReqBO();
            if (!"2".equals(applyRspBO.getPayFeeType())) {
                log.error("########## \u67e5\u8be2\u5230\u9500\u65b9\u53d1\u7968\u4fe1\u606f CompanyId ###########:" + ((BusiQueryDetailBillApplyInfoOrderRspBO)applyRspBO.getRows().get(0)).getSaleCompanyId());
                umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(((BusiQueryDetailBillApplyInfoOrderRspBO)applyRspBO.getRows().get(0)).getSaleCompanyId());
            } else {
                umcACompanyInfoDetailAbilityServiceReqBO.setCompanyId(applyRspBO.getOperUnitNo());
            }
            UmcACompanyInfoDetailAbilityServiceRspBO umcACompanyInfoDetailAbilityServiceRspBO = this.umcACompanyInfoDetailAbilityService.getDetailACompanyInfo(umcACompanyInfoDetailAbilityServiceReqBO);
            if (null == umcACompanyInfoDetailAbilityServiceRspBO || !"0000".equals(umcACompanyInfoDetailAbilityServiceRspBO.getRespCode())) {
                throw new PfscExtBusinessException("0001", "\u672a\u67e5\u8be2\u5230\u9500\u65b9\u53d1\u7968\u4fe1\u606f");
            }
            String taxNo = umcACompanyInfoDetailAbilityServiceRspBO.getTaxpayerId();
            log.error("########## \u67e5\u8be2\u5230\u9500\u65b9\u53d1\u7968\u4fe1\u606f umcACompanyInfoDetailAbilityServiceRspBO ###########:" + umcACompanyInfoDetailAbilityServiceRspBO.toString());
            BillInfoUploadExtReqBO uploadExtReqBO = new BillInfoUploadExtReqBO();
            uploadExtReqBO.setBusinessBillType("AR");
            uploadExtReqBO.setSystemOrig("YD");
            uploadExtReqBO.setStatus(applyStatus);
            ArrayList<MessageBO> message = new ArrayList<MessageBO>();
            MessageBO messageBO = new MessageBO();
            SalesBillMainBO billMainBO = new SalesBillMainBO();
            billMainBO.setSalesbillNo(applyNo);
            billMainBO.setSalesbillType("AR\u5355");
            billMainBO.setSellerNo(taxNo);
            billMainBO.setPurchaserName(applyRspBO.getInvoceName());
            billMainBO.setPurchaserTaxNo(applyRspBO.getTaxNo());
            billMainBO.setPriceMethod(Integer.valueOf(1));
            if ("1".equals(applyRspBO.getInvoiceType())) {
                billMainBO.setInvoiceType("c");
            } else {
                billMainBO.setInvoiceType("s");
                billMainBO.setPurchaserAddress(applyRspBO.getAddr());
                billMainBO.setPurchaserBankAccount(applyRspBO.getBankAcctNo());
                billMainBO.setPurchaserBankName(applyRspBO.getBankName());
                billMainBO.setPurchaserTel(applyRspBO.getPhone());
            }
            BigDecimal taxAmt = applyRspBO.getAmt().divide(BigDecimal.ONE.add(new BigDecimal("0.13")), 5, 4).multiply(new BigDecimal("0.13")).setScale(2, 4);
            if (busiInvoiceIssueAtourReqBO.getApplyStatus() == 2) {
                InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
                detailVO.setApplyNo2(applyNo);
                List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(detailVO);
                List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectByApplyNo(invoiceReturnDetails.get(0).getApplyNo1());
                uploadExtReqBO.setStatus(Integer.valueOf(1));
                billMainBO.setOriginInvoiceNo(saleInvoiceInfos.get(0).getInvoiceNo());
                billMainBO.setOriginInvoiceCode(saleInvoiceInfos.get(0).getInvoiceCode());
                billMainBO.setRedNotification(saleInvoiceInfos.get(0).getRedOrderNo());
            }
            ArrayList<SalesBillDetailsBO> salesBillDetails = new ArrayList<SalesBillDetailsBO>();
            BigDecimal taxAmountTotal = new BigDecimal(0);
            BigDecimal amountWithoutTaxTotal = new BigDecimal(0);
            BigDecimal amountWithTaxTotal = new BigDecimal(0);
            if (!"2".equals(applyRspBO.getPayFeeType())) {
                if (applyRspBO.getRows() != null && applyRspBO.getRows().size() > 0) {
                    for (BusiQueryDetailBillApplyInfoOrderRspBO infoOrderRspBO : applyRspBO.getRows()) {
                        if (infoOrderRspBO.getItemList() == null || infoOrderRspBO.getItemList().size() <= 0) continue;
                        for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : infoOrderRspBO.getItemList()) {
                            log.error("########## infoItemRspBO ###########:" + infoItemRspBO.toString());
                            SalesBillDetailsBO billDetailsBO = new SalesBillDetailsBO();
                            billDetailsBO.setSalesbillItemNo(infoItemRspBO.getItemNo().toString());
                            billDetailsBO.setItemName(infoItemRspBO.getSkuName());
                            billDetailsBO.setItemSpec(infoItemRspBO.getSpec() + infoItemRspBO.getModel());
                            billDetailsBO.setQuantityUnit(infoItemRspBO.getUnitName());
                            billDetailsBO.setQuantity(infoItemRspBO.getQuantity());
                            if (infoItemRspBO.getTaxCatCode() != null) {
                                billDetailsBO.setGoodsTaxNo(infoItemRspBO.getTaxCatCode().toString());
                            } else {
                                billDetailsBO.setGoodsTaxNo("1010101030000000000");
                            }
                            billDetailsBO.setAmountWithoutTax(infoItemRspBO.getUntaxAmt());
                            billDetailsBO.setAmountWithTax(infoItemRspBO.getAmount());
                            billDetailsBO.setTaxAmount(infoItemRspBO.getTaxAmt());
                            billDetailsBO.setTaxRate(infoItemRspBO.getTaxRate());
                            billDetailsBO.setUnitPriceWithTax(infoItemRspBO.getSaleUnitPrice());
                            billDetailsBO.setUnitPrice(infoItemRspBO.getSaleUnitPrice().divide(BigDecimal.ONE.add(infoItemRspBO.getTaxRate()), 6, 4));
                            if (busiInvoiceIssueAtourReqBO.getApplyStatus() == 2) {
                                billDetailsBO.setAmountWithoutTax(infoItemRspBO.getUntaxAmt().negate());
                                billDetailsBO.setAmountWithTax(infoItemRspBO.getAmount().negate());
                                billDetailsBO.setTaxAmount(infoItemRspBO.getTaxAmt().negate());
                                billDetailsBO.setTaxRate(infoItemRspBO.getTaxRate());
                                billDetailsBO.setUnitPriceWithTax(infoItemRspBO.getSaleUnitPrice());
                                billDetailsBO.setUnitPrice(infoItemRspBO.getSaleUnitPrice().divide(BigDecimal.ONE.add(infoItemRspBO.getTaxRate()), 6, 4));
                                billDetailsBO.setQuantity(infoItemRspBO.getQuantity().negate());
                                log.error("###### billDetailsBO ########" + billDetailsBO.toString());
                            }
                            taxAmountTotal = taxAmountTotal.add(billDetailsBO.getTaxAmount());
                            amountWithoutTaxTotal = amountWithoutTaxTotal.add(billDetailsBO.getAmountWithoutTax());
                            amountWithTaxTotal = amountWithTaxTotal.add(billDetailsBO.getAmountWithTax());
                            salesBillDetails.add(billDetailsBO);
                        }
                    }
                }
            } else {
                SalesBillDetailsBO billDetailsBO = new SalesBillDetailsBO();
                billDetailsBO.setSalesbillItemNo(applyRspBO.getApplyNo().substring(4));
                billDetailsBO.setItemName("\u670d\u52a1\u8d39+" + applyRspBO.getAmt().toString());
                billDetailsBO.setQuantityUnit("\u4e2a");
                billDetailsBO.setQuantity(BigDecimal.ONE);
                billDetailsBO.setGoodsTaxNo("3079900000000000000");
                billDetailsBO.setAmountWithoutTax(applyRspBO.getAmt().subtract(taxAmt));
                billDetailsBO.setAmountWithTax(applyRspBO.getAmt());
                billDetailsBO.setTaxAmount(taxAmt);
                billDetailsBO.setTaxRate(new BigDecimal("0.13"));
                billDetailsBO.setUnitPriceWithTax(applyRspBO.getAmt());
                billDetailsBO.setUnitPrice(applyRspBO.getAmt().subtract(taxAmt));
                salesBillDetails.add(billDetailsBO);
            }
            if (!"2".equals(applyRspBO.getPayFeeType())) {
                billMainBO.setTaxAmount(taxAmountTotal);
                billMainBO.setAmountWithoutTax(amountWithoutTaxTotal);
                billMainBO.setAmountWithTax(amountWithTaxTotal);
            } else {
                billMainBO.setTaxAmount(taxAmt);
                billMainBO.setAmountWithoutTax(applyRspBO.getAmt().subtract(taxAmt));
                billMainBO.setAmountWithTax(applyRspBO.getAmt());
            }
            messageBO.setSalesBillMain(billMainBO);
            messageBO.setSalesBillDetails(salesBillDetails);
            message.add(messageBO);
            uploadExtReqBO.setMessage(message);
            BillInfoUploadExtRspBO billInfoUploadExtRspBO = this.billInfoUploadExternalService.billInfoUpload(uploadExtReqBO);
            if ("1".equals(billInfoUploadExtRspBO.getRespCode())) {
                BillApplyInfo billApply;
                if (!"2".equals(applyRspBO.getPayFeeType())) {
                    billApply = new BillApplyInfo();
                    billApply.setApplyNo(applyNo);
                    billApply.setBillStatus("02");
                    billApply.setAuthDate(new Date());
                    billApply.setAuthUser(busiInvoiceIssueAtourReqBO.getUsername());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                    this.saleOrderInfoMapper.updateStatusByApplyNo(applyNo, "01");
                    continue;
                }
                billApply = new BillApplyInfo();
                billApply.setApplyNo(applyNo);
                billApply.setAuthDate(new Date());
                billApply.setAuthRemark("\u901a\u8fc7");
                billApply.setAuthUser(busiInvoiceIssueAtourReqBO.getUsername());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                continue;
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63a8\u9001\u7a0e\u63a7\u5931\u8d25");
        }
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        if (billApplyInfo != null && billApplyInfo.getAmt().longValue() < 0L) {
            InvoiceReturnDetailVO detailVO = new InvoiceReturnDetailVO();
            detailVO.setApplyNo2(applyNo);
            List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(detailVO);
            if (invoiceReturnDetails != null && invoiceReturnDetails.size() > 0 && invoiceReturnDetails.get(0).getApplyNo3() != null) {
                log.error("###### invoiceReturnDetails applyNo3 ########:" + invoiceReturnDetails.get(0).getApplyNo3());
                saleOrderInfoVO.setApplyNo(invoiceReturnDetails.get(0).getApplyNo3());
            }
        }
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (!"2".equals(billApplyInfo.getPayFeeType())) {
            if (saleOrderInfoList != null) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                    SaleItemInfoVO condition = new SaleItemInfoVO();
                    condition.setInspectionId(saleOrderInfo.getInspectionId());
                    condition.setApplyNo(billApplyInfo.getApplyNo());
                    List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(condition);
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                        skuIds.add(saleItemInfo.getSkuId());
                    }
                    ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                    for (SaleItemInfo saleItemInfo3 : saleItemInfoList) {
                        BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                        BeanUtils.copyProperties((Object)saleItemInfo3, (Object)item);
                        if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                            item.setAmountApply(saleItemInfo3.getAmountApplied());
                            item.setQuantityApply(saleItemInfo3.getQuantityApplied());
                        } else {
                            item.setAmountApply(saleItemInfo3.getAmount());
                            item.setQuantityApply(saleItemInfo3.getQuantity());
                        }
                        itemList.add(item);
                    }
                    BusiQueryDetailBillApplyInfoOrderRspBO busiQueryDetailBillApplyInfoOrderRspBO = new BusiQueryDetailBillApplyInfoOrderRspBO();
                    BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQueryDetailBillApplyInfoOrderRspBO);
                    busiQueryDetailBillApplyInfoOrderRspBO.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                    busiQueryDetailBillApplyInfoOrderRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                    busiQueryDetailBillApplyInfoOrderRspBO.setItemList(itemList);
                    orderList.add(busiQueryDetailBillApplyInfoOrderRspBO);
                }
            }
        } else {
            Long payOrderId;
            List<PayPurchaseOrderInfo> pays;
            List<PayOrderInfoPO> listPay = this.payOrderInfoMapper.selectByApplyNo(billApplyInfo.getApplyNo());
            if (null != listPay && !listPay.isEmpty() && null != (pays = this.payPurchaseOrderInfoMapper.getOrderListByPayOrderId(payOrderId = listPay.get(0).getPayOrderId())) && !pays.isEmpty()) {
                billApplyInfo.setOperUnitNo(pays.get(0).getPurchaseCompanyId());
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

