/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.FscOfflinePaySubmitService;
import com.tydic.pfsc.api.busi.bo.FscOfflinePaySubmitReqBO;
import com.tydic.pfsc.api.busi.bo.FscOfflinePaySubmitRspBO;
import com.tydic.pfsc.dao.ApplyPayInfoMapper;
import com.tydic.pfsc.dao.po.ApplyPayInfoPO;
import com.tydic.pfsc.enums.ApplyPayStatus2;
import com.tydic.pfsc.enums.PayMode;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.FscOfflinePaySubmitService"})
public class FscOfflinePaySubmitServiceImpl
implements FscOfflinePaySubmitService {
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;

    @PostMapping(value={"submit"})
    public FscOfflinePaySubmitRspBO submit(@RequestBody FscOfflinePaySubmitReqBO reqBO) {
        FscOfflinePaySubmitRspBO rspBO = new FscOfflinePaySubmitRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayNo())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u652f\u4ed8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayVoucher())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u4ed8\u6b3e\u51ed\u8bc1URL\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayVoucherName())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u4ed8\u6b3e\u51ed\u8bc1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ApplyPayInfoPO applyPayInfoPOResult = this.applyPayInfoMapper.getModelById(reqBO.getPayNo());
        if (applyPayInfoPOResult == null) {
            rspBO.setRespCode("18001");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u5355\u53f7\u4e3a[" + reqBO.getPayNo() + "]\u7684\u8bb0\u5f55");
            return rspBO;
        }
        if (!ApplyPayStatus2.NOPAID.getCode().equals(applyPayInfoPOResult.getPayStatus())) {
            rspBO.setRespCode("18003");
            rspBO.setRespDesc("\u652f\u4ed8\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u652f\u4ed8");
            return rspBO;
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayno(reqBO.getPayNo());
        applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
        applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
        applyPayInfoPO.setRemark(reqBO.getRemark());
        applyPayInfoPO.setRecAcctName(reqBO.getRecAcctName());
        applyPayInfoPO.setOpenBankName(reqBO.getOpenBankName());
        applyPayInfoPO.setReceiptAcctNo(reqBO.getReceiptAcctNo());
        applyPayInfoPO.setPayMode(PayMode.OFFLINE_PAY.getCode());
        applyPayInfoPO.setPayStatus(ApplyPayStatus2.OUTPAID.getCode());
        applyPayInfoPO.setPayType("07");
        applyPayInfoPO.setPayInitTime(new Date());
        int updateStatus = this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        if (updateStatus < 1) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91c7\u8d2d\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7ebf\u4e0b\u652f\u4ed8\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }
}

