/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.deal.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfsc.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayPurchaseOrderInfoRspBO;
import com.tydic.pfsc.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfsc.api.deal.QueryPayPurchaseOrderInfoListService;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfsc.enums.BaseEnums;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.OrderStatus2;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.deal.QueryPayPurchaseOrderInfoListService"})
public class QueryPayPurchaseOrderInfoListServiceImpl
implements QueryPayPurchaseOrderInfoListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayPurchaseOrderInfoListServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    @PostMapping(value={"queryPayPurchaseOrderInfoList"})
    public QueryPayPurchaseOrderInfoRspBO queryPayPurchaseOrderInfoList(@RequestBody QueryPayPurchaseOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayPurchaseOrderInfoRspBO rapPage = new QueryPayPurchaseOrderInfoRspBO();
        try {
            PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)payPurchaseOrderInfoVO);
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            String orderBy = "t.ORDER_DATE DESC";
            payPurchaseOrderInfoVO.setOrderBy(orderBy);
            if (null != reqBO.getFlag() && reqBO.getFlag().booleanValue()) {
                payPurchaseOrderInfoVO.setIsPayFlag("0");
            }
            if (null == payPurchaseOrderInfoVO.getOrderCodes() || payPurchaseOrderInfoVO.getOrderCodes().isEmpty()) {
                payPurchaseOrderInfoVO.setOrderCodes(null);
            }
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListForDealServiceFeePage(payPurchaseOrderInfoVO, (Page<Map<String, Object>>)page);
            ArrayList<PayPurchaseOrderInfoBO> boList = new ArrayList<PayPurchaseOrderInfoBO>();
            for (PayPurchaseOrderInfo singlePO : payPurchaseOrderInfoPOs) {
                PayPurchaseOrderInfoBO singleBO = new PayPurchaseOrderInfoBO();
                BeanUtils.copyProperties((Object)singlePO, (Object)singleBO);
                singleBO.setParentOrderId(String.valueOf(singlePO.getParentOrderId()));
                singleBO.setOrderId(String.valueOf(singlePO.getOrderId()));
                singleBO.setInspectionId(String.valueOf(singlePO.getInspectionId()));
                LinkedList<PayItemInfoExtVO> itemVOList = new LinkedList<PayItemInfoExtVO>();
                List<PayItemInfo> itemList = this.payItemInfoMapper.selectDealServiceByOrderAndInspector(singlePO.getOrderId(), singlePO.getInspectionId());
                for (PayItemInfo singleItem : itemList) {
                    PayItemInfoExtVO sinleItemVO = new PayItemInfoExtVO();
                    BeanUtils.copyProperties((Object)singleItem, (Object)sinleItemVO);
                    sinleItemVO.setSeq(String.valueOf(singleItem.getSeq()));
                    StringBuilder specModelFigureNo = new StringBuilder();
                    if (StringUtils.hasText((String)singleItem.getSpec())) {
                        specModelFigureNo.append(singleItem.getSpec()).append("\\");
                    }
                    if (StringUtils.hasText((String)singleItem.getModel())) {
                        specModelFigureNo.append(singleItem.getModel()).append("\\");
                    }
                    if (StringUtils.hasText((String)singleItem.getFigureNo())) {
                        specModelFigureNo.append(singleItem.getFigureNo()).append("\\");
                    }
                    if (specModelFigureNo.length() >= 1) {
                        sinleItemVO.setSpecModelFigureNo(specModelFigureNo.toString().substring(0, specModelFigureNo.length() - 1));
                    }
                    if (null != singleItem.getPurchaseUnitPrice()) {
                        String purchaseUnitPriceStr = singleItem.getPurchaseUnitPrice().setScale(2, RoundingMode.HALF_UP).toString();
                        LOGGER.debug("\u91c7\u8d2d\u5355\u4ef7====" + purchaseUnitPriceStr);
                        sinleItemVO.setPurchaseUnitPriceStr(purchaseUnitPriceStr);
                    } else {
                        sinleItemVO.setPurchaseUnitPriceStr("0.00");
                    }
                    itemVOList.add(sinleItemVO);
                }
                singleBO.setItemInfos(itemVOList);
                OrderStatus orderStatusEnum = OrderStatus.getInstance(singleBO.getOrderStatus());
                singleBO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
                singleBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)singleBO.getSource())));
                singleBO.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(singleBO.getProfessionalDepartId()));
                singleBO.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(singleBO.getServiceDepartId()));
                OrderStatus2 orderStatus2Enum = OrderStatus2.getInstance(singlePO.getOrderStatus2());
                singleBO.setOrderStatus2Descr(this.enumsService.getDescr(orderStatus2Enum));
                singleBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(singlePO.getBranchCompany()));
                boList.add(singleBO);
            }
            rapPage.setRows(boList);
            rapPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rapPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rapPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
        return rapPage;
    }
}

