/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.bo;

import java.util.List;
import java.util.Map;

public class CacheInfo {
    private Object ob;
    private Long tick;
    private Integer timeoutMinutes;

    public CacheInfo(Object ob) {
        this.ob = ob;
        this.tick = System.currentTimeMillis();
        this.timeoutMinutes = 30;
    }

    public CacheInfo(Object ob, int timeoutMinutes) {
        this.ob = ob;
        this.tick = System.currentTimeMillis();
        this.timeoutMinutes = timeoutMinutes >= 0 ? Integer.valueOf(timeoutMinutes) : Integer.valueOf(30);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.tick >= (long)(this.timeoutMinutes * 60000);
    }

    public <T> T getOb() {
        return (T)this.ob;
    }

    public void setOb(Object ob) {
        this.ob = ob;
    }

    public void resetTime() {
        this.tick = System.currentTimeMillis();
    }

    public static <K> CacheInfo getInCache(Map<K, CacheInfo> cacheMap, K indexKey) {
        CacheInfo inf = cacheMap.get(indexKey);
        if (null != inf && inf.isExpired()) {
            return null;
        }
        return inf;
    }

    public static <K, T> CacheInfo putToCache(Map<K, CacheInfo> cacheMap, K indexKey, T valueOb, int timeoutMinute) {
        T ob;
        if (null == indexKey) {
            return null;
        }
        CacheInfo inf = cacheMap.get(indexKey);
        if (null != inf && null != (ob = inf.getOb())) {
            if (ob instanceof List) {
                ((List)ob).clear();
            }
            inf.setOb(null);
        }
        inf = new CacheInfo(valueOb, timeoutMinute);
        cacheMap.put(indexKey, inf);
        return inf;
    }
}

