/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.FinanceConfigMapper;
import com.tydic.pfsc.dao.IncomeCalcMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.WFEventResult;
import com.tydic.pfsc.enums.InquiryPayFeeType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.api.BusiOutStockIncomeCalcService;
import com.tydic.pfsc.external.api.bo.BusiOutStockIncomeCalcDetailReqBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.QueryDictKeyValueService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.service.atom.WorkFlowFinishEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="supplierPayIncomeCalcWorkFlowFinishEventImpl")
public class SupplierPayIncomeCalcWorkFlowFinishEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(SupplierPayIncomeCalcWorkFlowFinishEventImpl.class);
    private FinanceConfigMapper financeConfigMapper;
    private BillApplyInfoMapper billApplyInfoMapper;
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    private BusiOutStockIncomeCalcService busiOutStockIncomeCalcService;
    private QueryDictKeyValueService queryDictKeyValueService;
    private OrganizationInfoService organizationInfoService;
    private EnumsService enumsService;
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    private IncomeCalcMapper incomeCalcMapper;
    private UserInfoService userInfoService;

    @Autowired
    public SupplierPayIncomeCalcWorkFlowFinishEventImpl(FinanceConfigMapper financeConfigMapper, BillApplyInfoMapper billApplyInfoMapper, InquiryPayOrderMapper inquiryPayOrderMapper, BusiOutStockIncomeCalcService busiOutStockIncomeCalcService, QueryDictKeyValueService queryDictKeyValueService, OrganizationInfoService organizationInfoService, EnumsService enumsService, SaleInvoiceInfoMapper saleInvoiceInfoMapper, IncomeCalcMapper incomeCalcMapper, UserInfoService userInfoService) {
        this.financeConfigMapper = financeConfigMapper;
        this.billApplyInfoMapper = billApplyInfoMapper;
        this.inquiryPayOrderMapper = inquiryPayOrderMapper;
        this.busiOutStockIncomeCalcService = busiOutStockIncomeCalcService;
        this.queryDictKeyValueService = queryDictKeyValueService;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
        this.saleInvoiceInfoMapper = saleInvoiceInfoMapper;
        this.incomeCalcMapper = incomeCalcMapper;
        this.userInfoService = userInfoService;
    }

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isInfoEnabled()) {
            logger.debug("\u4f9b\u5e94\u5546\u7f34\u8d39\u6536\u5165\u8ba1\u7b97\u5355\u5ba1\u6279\u6d41\u7ed3\u675f\u5904\u7406\u5165\u53c2\uff1aworkFlowDataInfo=" + workFlowDataInfo + ",billType=" + billType + ",billNo=" + billNo);
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WFEventResult wfEventResult = null;
        if (billNo.startsWith("KPSQ")) {
            wfEventResult = this.processNormalKpsq(workFlowDataInfo, billType, billNo);
        } else if (billNo.startsWith("SRJS")) {
            wfEventResult = this.processSummaryKpsq(billNo);
        }
        return wfEventResult;
    }

    private WFEventResult processNormalKpsq(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        return null;
    }

    private WFEventResult processSummaryKpsq(String billNo) {
        return null;
    }

    private List<BusiOutStockIncomeCalcDetailReqBO> getItemsByInvoice(BillApplyInfo eachBillApplyInfo, Map<String, String> financeMap) {
        LinkedList<BusiOutStockIncomeCalcDetailReqBO> items = new LinkedList<BusiOutStockIncomeCalcDetailReqBO>();
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(eachBillApplyInfo.getApplyNo());
        List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        for (SaleInvoiceInfo saleInvoiceInfo : invoices) {
            BusiOutStockIncomeCalcDetailReqBO calcDetailReqBO = new BusiOutStockIncomeCalcDetailReqBO();
            String xshtbh = this.enumsService.querySupplierPaySaleContactNo();
            calcDetailReqBO.setXshtbh(xshtbh);
            String supplierName = this.organizationInfoService.querySupplierName(eachBillApplyInfo.getSupplierNo());
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(eachBillApplyInfo.getPayFeeType())) {
                calcDetailReqBO.setJjnr(cal.get(1) + "\u5e74" + (cal.get(2) + 1) + "\u6708\u8be2\u6bd4\u4ef7\u7ed3\u7b97");
            } else {
                calcDetailReqBO.setJjnr("\u8be2\u6bd4\u4ef7\u7ed3\u7b97");
            }
            calcDetailReqBO.setWldw(supplierName);
            calcDetailReqBO.setKhyh(eachBillApplyInfo.getBankName() == null ? "" : eachBillApplyInfo.getBankName());
            calcDetailReqBO.setYhzh(eachBillApplyInfo.getBankAcctNo() == null ? "" : eachBillApplyInfo.getBankAcctNo());
            calcDetailReqBO.setNsrsbh(eachBillApplyInfo.getTaxNo() == null ? "" : eachBillApplyInfo.getTaxNo());
            calcDetailReqBO.setLxdz(eachBillApplyInfo.getAddr() == null ? "" : eachBillApplyInfo.getAddr());
            calcDetailReqBO.setYszkje(BigDecimal.ZERO);
            calcDetailReqBO.setBccxyszk(BigDecimal.ZERO);
            calcDetailReqBO.setBzjkk(saleInvoiceInfo.getAmt());
            calcDetailReqBO.setSpfl(financeMap.get("\u5546\u54c1\u5206\u7c7b"));
            calcDetailReqBO.setYwsx(financeMap.get("\u4e1a\u52a1\u4e8b\u9879"));
            calcDetailReqBO.setSpzl(financeMap.get("\u5546\u54c1\u79cd\u7c7b"));
            calcDetailReqBO.setJldw(financeMap.get("\u8ba1\u91cf\u5355\u4f4d"));
            calcDetailReqBO.setAmount(BigDecimal.ZERO);
            calcDetailReqBO.setHsdj(BigDecimal.ZERO);
            calcDetailReqBO.setHsje(saleInvoiceInfo.getAmt());
            calcDetailReqBO.setTaxRate(this.enumsService.queryDefaultServiceFeeTaxRate());
            calcDetailReqBO.setSe(saleInvoiceInfo.getTaxAmt());
            calcDetailReqBO.setBhsje(saleInvoiceInfo.getUntaxAmt());
            calcDetailReqBO.setYsje(BigDecimal.ZERO);
            items.add(calcDetailReqBO);
        }
        return items;
    }

    private List<BusiOutStockIncomeCalcDetailReqBO> getItemsByOrder(BillApplyInfo eachBillApplyInfo, Map<String, String> financeMap) {
        LinkedList<BusiOutStockIncomeCalcDetailReqBO> items = new LinkedList<BusiOutStockIncomeCalcDetailReqBO>();
        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
        inquiryPayOrderExt.setApplyNo(eachBillApplyInfo.getApplyNo());
        List<InquiryPayOrder> orderList = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
        for (InquiryPayOrder order : orderList) {
            BusiOutStockIncomeCalcDetailReqBO calcDetailReqBO = new BusiOutStockIncomeCalcDetailReqBO();
            String xshtbh = this.enumsService.querySupplierPaySaleContactNo();
            calcDetailReqBO.setXshtbh(xshtbh);
            String supplierName = this.organizationInfoService.querySupplierName(order.getSupplierId());
            Calendar cal = Calendar.getInstance();
            if (null != order.getPayFinshTime()) {
                cal.setTime(order.getPayFinshTime());
            } else if (null != order.getPayStartTime()) {
                cal.setTime(order.getPayStartTime());
            }
            if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(order.getPayFeeType())) {
                calcDetailReqBO.setJjnr(cal.get(1) + "\u5e74" + (cal.get(2) + 1) + "\u6708\u8be2\u6bd4\u4ef7\u7ed3\u7b97");
            } else {
                calcDetailReqBO.setJjnr("\u8be2\u6bd4\u4ef7\u7ed3\u7b97");
            }
            calcDetailReqBO.setWldw(supplierName);
            calcDetailReqBO.setKhyh(eachBillApplyInfo.getBankName() == null ? "" : eachBillApplyInfo.getBankName());
            calcDetailReqBO.setYhzh(eachBillApplyInfo.getBankAcctNo() == null ? "" : eachBillApplyInfo.getBankAcctNo());
            calcDetailReqBO.setNsrsbh(eachBillApplyInfo.getTaxNo() == null ? "" : eachBillApplyInfo.getTaxNo());
            calcDetailReqBO.setLxdz(eachBillApplyInfo.getAddr() == null ? "" : eachBillApplyInfo.getAddr());
            calcDetailReqBO.setYszkje(BigDecimal.ZERO);
            calcDetailReqBO.setBccxyszk(BigDecimal.ZERO);
            calcDetailReqBO.setBzjkk(order.getPayMoney());
            calcDetailReqBO.setSpfl(financeMap.get("\u5546\u54c1\u5206\u7c7b"));
            calcDetailReqBO.setYwsx(financeMap.get("\u4e1a\u52a1\u4e8b\u9879"));
            calcDetailReqBO.setSpzl(financeMap.get("\u5546\u54c1\u79cd\u7c7b"));
            calcDetailReqBO.setJldw(financeMap.get("\u8ba1\u91cf\u5355\u4f4d"));
            calcDetailReqBO.setAmount(BigDecimal.ZERO);
            calcDetailReqBO.setHsdj(BigDecimal.ZERO);
            calcDetailReqBO.setHsje(order.getPayMoney());
            calcDetailReqBO.setTaxRate(this.enumsService.queryDefaultServiceFeeTaxRate());
            calcDetailReqBO.setSe(order.getTaxAmt());
            calcDetailReqBO.setBhsje(order.getUntaxAmt());
            calcDetailReqBO.setYsje(BigDecimal.ZERO);
            items.add(calcDetailReqBO);
        }
        return items;
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            v = BeanUtils.getProperty((Object)bean, (String)name);
            return v;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
            return null;
        }
    }
}

