/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.api.busi.RegisterReturnSubmitBusiService;
import com.tydic.pfsc.api.busi.bo.PayInvoiceInfoBO;
import com.tydic.pfsc.api.busi.bo.RegisterReturnSubmitBusiReqBO;
import com.tydic.pfsc.api.busi.bo.RegisterReturnSubmitBusiRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.RegisterReturnDetailMapper;
import com.tydic.pfsc.dao.RegisterReturnMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SupplierInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.RegisterReturnDetailPO;
import com.tydic.pfsc.dao.po.RegisterReturnPO;
import com.tydic.pfsc.dao.po.SupplierInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.BillNotificationInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.RegisterReturnStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.RegisterReturnSubmitBusiService"})
public class RegisterReturnSubmitBusiServiceImpl
implements RegisterReturnSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(RegisterReturnSubmitBusiServiceImpl.class);
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private RegisterReturnMapper registerReturnMapper;
    @Autowired
    private RegisterReturnDetailMapper registerReturnDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Resource(name="billNotificationBatchNoSeq")
    private OrderSequence billNotificationBatchNoSeq;

    @PostMapping(value={"dealRegReturnSubmit"})
    public RegisterReturnSubmitBusiRspBO dealRegReturnSubmit(@RequestBody RegisterReturnSubmitBusiReqBO reqBO) {
        BillNotificationInfo billNotificationInfo;
        RegisterReturnSubmitBusiRspBO rspBO = new RegisterReturnSubmitBusiRspBO();
        this.validParam(reqBO);
        List invoiceList = reqBO.getInvoiceList();
        ArrayList<String> invoiceNoList = new ArrayList<String>();
        for (PayInvoiceInfoBO payInvoiceInfoBO : invoiceList) {
            invoiceNoList.add(payInvoiceInfoBO.getInvoiceNo());
        }
        SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
        saleItemApplyInfoVO.setInvoiceList(invoiceNoList);
        List<SaleItemApplyInfoVO> saleItemApplyInfoVOS = this.saleItemApplyInfoMapper.selectApplyNoJoinByConditions(saleItemApplyInfoVO);
        ArrayList<String> applyNoList = new ArrayList<String>();
        if (saleItemApplyInfoVOS != null && saleItemApplyInfoVOS.size() > 0) {
            for (SaleItemApplyInfoVO vo : saleItemApplyInfoVOS) {
                applyNoList.add(vo.getApplyNo());
            }
        }
        if (applyNoList.size() > 0) {
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setApplyNoList(applyNoList);
            billApplyInfoVO.setBillStatus(BillStatus.SEND_BILL.getCode());
            int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
            if (count > 0) {
                throw new PfscExtBusinessException("18003", "\u4e0b\u6e38\u6709\u672a\u5904\u7406\u5b8c\u6210\u53d1\u7968\u4e1a\u52a1\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u9000\u7968\u767b\u8bb0\u64cd\u4f5c\uff01");
            }
        }
        if ((billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo())) == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u539f\u5f00\u7968\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        String billNo = this.billSNService.getSnAsString(BillType.INVOICE_RETURN_REGISTER);
        log.info("\u9000\u7968\u767b\u8bb0\u5355\u53f7billNo=" + billNo);
        BillNotificationInfoVO oldBillNotificationInfo = new BillNotificationInfoVO();
        oldBillNotificationInfo.setNotificationNo(reqBO.getNotificationNo());
        oldBillNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED_BACKING.getCode());
        this.billNotificationInfoMapper.update(oldBillNotificationInfo);
        SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(reqBO.getSupplierNo());
        if (supplierInfo == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u8bb0\u5f55");
        }
        String redType = supplierInfo.getRedType();
        HashMap<String, RegisterReturnDetailPO> registerReturnDetailPOMap = new HashMap<String, RegisterReturnDetailPO>();
        for (PayInvoiceInfoBO payInvoiceInfoBO : invoiceList) {
            BillNotificationInfo redBillNotifyInfo = this.assemableRedBillNotifyInfo(billNotificationInfo);
            redBillNotifyInfo.setUserId(reqBO.getUserId());
            redBillNotifyInfo.setDrawerName(reqBO.getUsername());
            if ("1".equals(redType)) {
                redBillNotifyInfo.setAmt(payInvoiceInfoBO.getAmt().negate());
            }
            RegisterReturnDetailPO tmpRegReturnDetail = new RegisterReturnDetailPO();
            tmpRegReturnDetail.setBillNo(billNo);
            tmpRegReturnDetail.setNotifyNo1(reqBO.getNotificationNo());
            tmpRegReturnDetail.setInvoiceCode1(payInvoiceInfoBO.getInvoiceCode());
            tmpRegReturnDetail.setInvoiceNo1(payInvoiceInfoBO.getInvoiceNo());
            tmpRegReturnDetail.setNotifyNo2(redBillNotifyInfo.getNotificationNo());
            registerReturnDetailPOMap.put(payInvoiceInfoBO.getInvoiceNo(), tmpRegReturnDetail);
            this.billNotificationInfoMapper.insert(redBillNotifyInfo);
        }
        RegisterReturnPO registerReturnPO = new RegisterReturnPO();
        registerReturnPO.setBillNo(billNo);
        registerReturnPO.setNotificationNo(reqBO.getNotificationNo());
        registerReturnPO.setReturnType(reqBO.getReturnType());
        registerReturnPO.setRemark(reqBO.getRemark());
        registerReturnPO.setStatus(RegisterReturnStatus.RETURN_STATUS_UNCOMMITED.getCode());
        registerReturnPO.setSupplierNo(reqBO.getSupplierNo());
        registerReturnPO.setOperUnitNo(reqBO.getOrgId());
        registerReturnPO.setCreateUser(reqBO.getUsername());
        registerReturnPO.setCreateUserId(reqBO.getUserId());
        registerReturnPO.setCreateDate(new Date());
        this.registerReturnMapper.insert(registerReturnPO);
        ArrayList<RegisterReturnDetailPO> registerReturnDetailPOS = new ArrayList<RegisterReturnDetailPO>();
        for (String invoiceNo : registerReturnDetailPOMap.keySet()) {
            RegisterReturnDetailPO registerReturnDetailPO = (RegisterReturnDetailPO)registerReturnDetailPOMap.get(invoiceNo);
            registerReturnDetailPOS.add(registerReturnDetailPO);
        }
        this.registerReturnDetailMapper.insertBatch(registerReturnDetailPOS);
        return rspBO;
    }

    private void validParam(RegisterReturnSubmitBusiReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getReturnType()) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u9000\u7968\u539f\u56e0[returnType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getRemark()) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u9000\u7968\u8bf4\u660e[remark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierNo()) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u7f16\u53f7[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceList())) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u767b\u8bb0\u63d0\u4ea4\u4e1a\u52a1\u670d\u52a1-\u52fe\u9009\u7684\u53d1\u7968\u96c6\u5408[invoiceList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private BillNotificationInfo assemableRedBillNotifyInfo(BillNotificationInfo billNotificationInfo) {
        BillNotificationInfo retRedBillNotifyInfo = new BillNotificationInfo();
        retRedBillNotifyInfo.setNotificationNo(this.billSNService.getSnAsString(BillType.INVOICE_NOTIFYCATION));
        retRedBillNotifyInfo.setBatchNo(this.generateSeqNoFormated(new SimpleDateFormat("yyyyMMdd").format(new Date())));
        retRedBillNotifyInfo.setApplyDate(new Date());
        retRedBillNotifyInfo.setSupplierNo(billNotificationInfo.getSupplierNo());
        retRedBillNotifyInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        retRedBillNotifyInfo.setPurchaseSaleType(billNotificationInfo.getPurchaseSaleType());
        retRedBillNotifyInfo.setInvoceType(billNotificationInfo.getInvoceType());
        retRedBillNotifyInfo.setInvoceName(billNotificationInfo.getInvoceName());
        retRedBillNotifyInfo.setTaxNo(billNotificationInfo.getTaxNo());
        retRedBillNotifyInfo.setAddr(billNotificationInfo.getAddr());
        retRedBillNotifyInfo.setPhone(billNotificationInfo.getPhone());
        retRedBillNotifyInfo.setBankName(billNotificationInfo.getBankName());
        retRedBillNotifyInfo.setBankAccNo(billNotificationInfo.getBankAccNo());
        retRedBillNotifyInfo.setOperNo(billNotificationInfo.getOperNo());
        retRedBillNotifyInfo.setSource(billNotificationInfo.getSource());
        retRedBillNotifyInfo.setCompany(billNotificationInfo.getCompany());
        retRedBillNotifyInfo.setName(billNotificationInfo.getName());
        retRedBillNotifyInfo.setProvince(billNotificationInfo.getProvince());
        retRedBillNotifyInfo.setCity(billNotificationInfo.getCity());
        retRedBillNotifyInfo.setCounty(billNotificationInfo.getCounty());
        retRedBillNotifyInfo.setTown(billNotificationInfo.getTown());
        retRedBillNotifyInfo.setProvId(billNotificationInfo.getProvId());
        retRedBillNotifyInfo.setCityId(billNotificationInfo.getCityId());
        retRedBillNotifyInfo.setCountyId(billNotificationInfo.getCountyId());
        retRedBillNotifyInfo.setTownId(billNotificationInfo.getTownId());
        retRedBillNotifyInfo.setAddrDesc(billNotificationInfo.getAddrDesc());
        retRedBillNotifyInfo.setPostCode(billNotificationInfo.getPostCode());
        retRedBillNotifyInfo.setMobile(billNotificationInfo.getMobile());
        retRedBillNotifyInfo.setTel(billNotificationInfo.getTel());
        return retRedBillNotifyInfo;
    }

    private String generateSeqNoFormated(String prefix) {
        String withoutPrefix;
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = 12 - prefix.length();
        try {
            withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", this.billNotificationBatchNoSeq.nextId());
        }
        catch (SQLException e) {
            log.debug("\u751f\u6210\u5e8f\u5217\u53f7\u5f02\u5e38" + e);
            throw new PfscExtBusinessException("18000", "\u751f\u6210\u6279\u6b21\u53f7\u5f02\u5e38");
        }
        return prefix + withoutPrefix;
    }
}

