/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FscDuplicateCommitLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(FscDuplicateCommitLimitAspect.class);
    @Resource
    private CacheClient cacheService;

    @Pointcut(value="@annotation(com.tydic.pfsc.aop.annotation.FscDuplicateCommitLimit)")
    public void fscDuplicateCommitLimit() {
    }

    @Around(value="fscDuplicateCommitLimit()&&@annotation(limit)")
    public Object around(ProceedingJoinPoint joinPoint, FscDuplicateCommitLimit limit) throws Throwable {
        String reqMd = null;
        String message = "\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4";
        Object[] args = joinPoint.getArgs();
        String clazzName = joinPoint.getSignature().getDeclaringTypeName();
        String methodName = joinPoint.getSignature().getName();
        log.debug("\u63d0\u4ea4\u6b21\u6570\u9650\u5236\u6ce8\u89e3-------------------:{}.--{}", (Object)limit, (Object)limit.toast());
        log.debug("\u63d0\u4ea4\u6b21\u6570\u9650\u5236\u6ce8\u89e3:{}.{}-args:{}", new Object[]{clazzName, methodName, JSON.toJSONString((Object)args)});
        if (null != args && args.length > 0) {
            block11: {
                message = limit.toast();
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    reqMd = Hex.encodeHexString((byte[])md.digest(JSON.toJSONString((Object)args[0]).getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
                    Long userIdIn = (Long)jsonObject.get((Object)"userId");
                    if (null == userIdIn || 0L == userIdIn) break block11;
                    reqMd = userIdIn + joinPoint.toShortString();
                }
            }
            if (null != reqMd) {
                Object o = null;
                try {
                    o = this.cacheService.get(reqMd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reqMd = null;
                }
                if (null != o) {
                    log.debug("\u63d0\u4ea4\u6b21\u6570\u9650\u5236--\u63d0\u793a\u6d88\u606f:{}.", (Object)message);
                    throw new PfscExtBusinessException("18000", message);
                }
                if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)"", 5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Object result = joinPoint.proceed(args);
        log.debug("\u63d0\u4ea4\u6b21\u6570\u9650\u5236\u6ce8\u89e3:{}.{}-result:{}", new Object[]{clazzName, methodName, result});
        if (null != reqMd) {
            this.cacheService.delete(reqMd);
        }
        return result;
    }
}

