/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.enums;

import com.tydic.pfsc.enums.BaseEnums;

public enum PayablePayType implements BaseEnums
{
    PREPAY("01", "\u7ebf\u4e0b\u652f\u4ed8"),
    PAY("02", "\u5e94\u4ed8\u6b3e"),
    WARRANTY("03", "\u8d28\u4fdd\u91d1");

    private String groupName;
    private String code;
    private String codeDescr;

    private PayablePayType(String code, String codeDescr) {
        this.code = code;
        this.codeDescr = codeDescr;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeDescr() {
        return this.codeDescr;
    }

    public static PayablePayType getInstance(String code) {
        for (PayablePayType o : PayablePayType.values()) {
            if (!o.getCode().equals(code)) continue;
            return o;
        }
        return null;
    }

    public String getCodeAsString() {
        return this.code;
    }

    public String getDescr() {
        return this.codeDescr;
    }
}

