/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.FinanceConfigMapper;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.OutstockTotalMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.FinanceConfig;
import com.tydic.pfsc.dao.po.OutstockDetail;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.OutstockTotal;
import com.tydic.pfsc.dao.po.PurchaseUnitInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.OutstockInfoVO;
import com.tydic.pfsc.dao.vo.WFEventResult;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.FinancialStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.YuanGuangBillType;
import com.tydic.pfsc.enums.YuanGuangType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.api.BusiOutStockGoodsTraService;
import com.tydic.pfsc.external.api.BusiOutStockIncomeCalcService;
import com.tydic.pfsc.external.api.bo.BusiOutStockGoodsTraDetailReqBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockGoodsTraFileReqBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockGoodsTraReqBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockGoodsTraRspBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockIncomeCalcDetailReqBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockIncomeCalcReqBO;
import com.tydic.pfsc.external.api.bo.BusiOutStockIncomeCalcRspBO;
import com.tydic.pfsc.external.api.bo.BusiTransferPayIncomeCalcPdfAttachReqBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.InvokePaycenterService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.QueryDictKeyValueService;
import com.tydic.pfsc.service.atom.SourceMappingService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.service.atom.WorkFlowFinishEvent;
import com.tydic.pfsc.utils.ContactUtils;
import com.tydic.pfsc.utils.FileUtils;
import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="outstockTotalWorkFlowFinishEventImpl")
public class OutstockTotalWorkFlowFinishEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(OutstockTotalWorkFlowFinishEventImpl.class);
    private OutstockTotalMapper outstockTotalMapper;
    private OutstockInfoMapper outstockInfoMapper;
    private OutstockDetailMapper outstockDetailMapper;
    private StocksDetailMapper stocksDetailMapper;
    private SaleOrderInfoMapper saleOrderInfoMapper;
    private SaleItemInfoMapper saleItemInfoMapper;
    private FinanceConfigMapper financeConfigMapper;
    private BillApplyInfoMapper billApplyInfoMapper;
    private BusiOutStockIncomeCalcService busiOutStockIncomeCalcService;
    private BusiOutStockGoodsTraService busiOutStockGoodsTraService;
    private QueryDictKeyValueService queryDictKeyValueService;
    private OrganizationInfoService organizationInfoService;
    private SourceMappingService sourceMappingService;
    private EnumsService enumsService;
    private InvokePaycenterService invokePaycenterService;
    private UserInfoService userInfoService;

    @Autowired
    public OutstockTotalWorkFlowFinishEventImpl(OutstockDetailMapper outstockDetailMapper, OutstockTotalMapper outstockTotalMapper, OutstockInfoMapper outstockInfoMapper, StocksDetailMapper stocksDetailMapper, SaleOrderInfoMapper saleOrderInfoMapper, SaleItemInfoMapper saleItemInfoMapper, FinanceConfigMapper financeConfigMapper, BillApplyInfoMapper billApplyInfoMapper, EnumsService enumsService, UserInfoService userInfoService, OrganizationInfoService organizationInfoService, SourceMappingService sourceMappingService, InvokePaycenterService invokePaycenterService, BusiOutStockIncomeCalcService busiOutStockIncomeCalcService, BusiOutStockGoodsTraService busiOutStockGoodsTraService, QueryDictKeyValueService queryDictKeyValueService) {
        this.outstockDetailMapper = outstockDetailMapper;
        this.outstockTotalMapper = outstockTotalMapper;
        this.outstockInfoMapper = outstockInfoMapper;
        this.stocksDetailMapper = stocksDetailMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
        this.saleItemInfoMapper = saleItemInfoMapper;
        this.financeConfigMapper = financeConfigMapper;
        this.billApplyInfoMapper = billApplyInfoMapper;
        this.enumsService = enumsService;
        this.userInfoService = userInfoService;
        this.organizationInfoService = organizationInfoService;
        this.sourceMappingService = sourceMappingService;
        this.invokePaycenterService = invokePaycenterService;
        this.busiOutStockIncomeCalcService = busiOutStockIncomeCalcService;
        this.busiOutStockGoodsTraService = busiOutStockGoodsTraService;
        this.queryDictKeyValueService = queryDictKeyValueService;
    }

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isInfoEnabled()) {
            logger.debug("\u51fa\u5e93\u6c47\u603b\u5355\u5ba1\u6279\u6d41\u7ed3\u675f\u5904\u7406\u5165\u53c2\uff0cworkFlowDataInfo:" + workFlowDataInfo + ",billType:" + billType + ",billNo:" + billNo);
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new PfscExtBusinessException("0001", "\u51fa\u5e93\u6c47\u603b\u5355\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String financialStatus = workFlowDataInfo.getFinancialStatus();
        String refNo = workFlowDataInfo.getRefNo();
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectByPrimaryKey(billNo);
        if (outstockTotal == null) {
            logger.error("\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + billNo + "\u627e\u4e0d\u5230\u51fa\u5e93\u6c47\u603b\u5355\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + billNo + "\u627e\u4e0d\u5230\u51fa\u5e93\u6c47\u603b\u5355");
        }
        String source = outstockTotal.getSource();
        String targetSource = this.sourceMappingService.queryYuanguangTargetSource(source);
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        outstockInfoVO.setTotalNo(billNo);
        List<OutstockInfo> list = this.outstockInfoMapper.selectByCondition(outstockInfoVO);
        if (list == null || list.size() == 0) {
            logger.error("\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + billNo + "\u627e\u4e0d\u5230\u51fa\u5e93\u5355\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u51fa\u5e93\u6c47\u603b\u5355\u53f7\uff1a" + billNo + "\u627e\u4e0d\u5230\u51fa\u5e93\u5355");
        }
        HashSet<Long> purchaseProjectIds = new HashSet<Long>();
        StringBuilder purchaseProjectNames = new StringBuilder();
        for (OutstockInfo lists : list) {
            purchaseProjectIds.add(lists.getPurchaseProjectId());
        }
        for (Long purchaseProjectId : purchaseProjectIds) {
            String purcharseProjectName = this.organizationInfoService.queryOrgName(purchaseProjectId);
            if (purchaseProjectNames.length() == 0) {
                purchaseProjectNames.append(purcharseProjectName);
                continue;
            }
            purchaseProjectNames.append(",").append(purcharseProjectName);
        }
        WFEventResult wfEventResult1 = new WFEventResult();
        BusiOutStockGoodsTraRspBO traRspBO = new BusiOutStockGoodsTraRspBO();
        traRspBO.setRspcode("1");
        if (FinancialStatus.NO_SEND.getCode().equals(financialStatus) || FinancialStatus.SEND_FAIL.getCode().equals(financialStatus) || FinancialStatus.SEND_SUCCESS_2.getCode().equals(financialStatus)) {
            BusiOutStockGoodsTraReqBO traReqBO = new BusiOutStockGoodsTraReqBO();
            FinanceConfig financeConfig = this.financeConfigMapper.selectByPrimaryKey(targetSource, outstockTotal.getOrgId(), YuanGuangType.OUT_INVENTORY_STATEMENT.getCode());
            if (financeConfig == null) {
                logger.error("\u6839\u636e\u6765\u6e90\uff1a" + source + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + outstockTotal.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.OUT_INVENTORY_STATEMENT.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                throw new PfscExtBusinessException("18001", "\u6839\u636e\u6765\u6e90\uff1a" + source + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + outstockTotal.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.OUT_INVENTORY_STATEMENT.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f");
            }
            Map<String, String> map = this.queryDictKeyValueService.queryDictKeyValue(targetSource, YuanGuangType.OUT_INVENTORY_STATEMENT.getCode(), outstockTotal.getOrgId());
            traReqBO.setSeqid("PAY" + YuanGuangType.OUT_INVENTORY_STATEMENT.getCode() + billNo);
            traReqBO.setSsdw(financeConfig.getUnitName());
            traReqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(source, financeConfig, outstockTotal.getUserId()));
            traReqBO.setFlowid(financeConfig.getProcessId());
            HashMap<String, String> saleOrderCodes = new HashMap<String, String>();
            LinkedList<BusiOutStockGoodsTraDetailReqBO> items = new LinkedList<BusiOutStockGoodsTraDetailReqBO>();
            for (OutstockInfo outstockInfo : list) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(outstockInfo.getApplyNo());
                if (billApplyInfo == null) {
                    logger.error("\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7\uff1a" + outstockInfo.getApplyNo() + "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                    throw new PfscExtBusinessException("18001", "\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7\uff1a" + outstockInfo.getApplyNo() + "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355");
                }
                List<OutstockDetail> list2 = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
                if (list2.isEmpty()) {
                    logger.error("\u6839\u636e\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo() + "\u627e\u4e0d\u5230\u51fa\u5e93\u660e\u7ec6\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                    throw new PfscExtBusinessException("18001", "\u6839\u636e\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo() + "\u627e\u4e0d\u5230\u51fa\u5e93\u660e\u7ec6");
                }
                PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(outstockInfo.getPurchaseProjectId());
                if (purchaseUnitInfo == null) {
                    String string = this.organizationInfoService.queryProjectName(outstockInfo.getPurchaseProjectId()).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + string + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                    throw new PfscExtBusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + string + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                }
                for (OutstockDetail outstockDetail : list2) {
                    BusiOutStockGoodsTraDetailReqBO traDetailReqBO = new BusiOutStockGoodsTraDetailReqBO();
                    SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
                    saleOrderInfo1.setInspectionId(outstockDetail.getInspectionId());
                    SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo1);
                    if (saleOrderInfo == null) {
                        logger.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                        throw new PfscExtBusinessException("18001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
                    }
                    if (!saleOrderCodes.containsKey(saleOrderInfo.getSaleOrderCode())) {
                        String projectName = this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName();
                        saleOrderCodes.put(saleOrderInfo.getSaleOrderCode(), projectName);
                    }
                    String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                    traDetailReqBO.setHtbh(xshtbh);
                    traDetailReqBO.setJjnr("\u7ed3\u8f6c" + purchaseUnitInfo.getPurchaseProjectName() + "\u300a\u9500\u552e\u5408\u540c\u300b" + traDetailReqBO.getHtbh() + "\u7269\u8d44\u6210\u672c");
                    traDetailReqBO.setWldw(purchaseUnitInfo.getPurchaseProjectName());
                    traDetailReqBO.setSpzl(map.get("\u5546\u54c1\u79cd\u7c7b"));
                    traDetailReqBO.setCk(map.get("\u4ed3\u5e93"));
                    traDetailReqBO.setSpfl(map.get("\u5546\u54c1\u5206\u7c7b"));
                    traDetailReqBO.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                    traDetailReqBO.setJldw(outstockDetail.getUnitName() == null ? "" : outstockDetail.getUnitName());
                    traDetailReqBO.setSl(outstockDetail.getQuantity() == null ? BigDecimal.ZERO : outstockDetail.getQuantity());
                    if (outstockDetail.getUntaxAmt() != null && outstockDetail.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        traDetailReqBO.setDwcb(outstockDetail.getUntaxAmt().divide(outstockDetail.getQuantity(), 2, 4));
                    } else {
                        traDetailReqBO.setDwcb(BigDecimal.ZERO);
                    }
                    StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
                    if (stocksDetail == null) {
                        logger.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u548c\u5546\u54c1\u884c\u53f7\uff1a" + outstockDetail.getPurchaseItemNo() + "\u627e\u4e0d\u5230\u5e93\u5b58\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                        throw new PfscExtBusinessException("18001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u548c\u5546\u54c1\u884c\u53f7\uff1a" + outstockDetail.getPurchaseItemNo() + "\u627e\u4e0d\u5230\u5e93\u5b58");
                    }
                    BigDecimal spcb = stocksDetail.getUntaxAmt();
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        SaleItemInfo saleItemInfo = this.saleItemInfoMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getItemNo());
                        spcb = spcb.multiply(outstockDetail.getQuantity()).divide(saleItemInfo.getQuantity(), 2, 4);
                    }
                    traDetailReqBO.setSpcb(spcb);
                    items.add(traDetailReqBO);
                }
            }
            traReqBO.setItems(items);
            StringBuilder summary = new StringBuilder();
            if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entry : saleOrderCodes.entrySet()) {
                    stringBuilder.append((String)entry.getKey()).append("\u3010").append((String)entry.getValue()).append("\u3011");
                }
                summary.append("\u7ed3\u8f6c\u7269\u8d44\u6210\u672c(").append((CharSequence)stringBuilder).append(")");
            } else {
                summary.append(financeConfig.getBillName()).append(traReqBO.getSeqid());
                if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                    summary.append("[").append((CharSequence)purchaseProjectNames).append("]");
                }
            }
            String summaryStr = summary.toString();
            summaryStr = FscStringUtils.cutStringByByte(summaryStr, "UTF-8", 200);
            traReqBO.setSummary(summaryStr);
            LinkedList attachItems = new LinkedList();
            if ("1".equals(this.enumsService.querFileTransmitYuanGuangSwitch(source))) {
                double d = 0.0;
                String string = "/rest/download/busiExportOutstockTotalController";
                HashMap<String, Object> urlParam = new HashMap<String, Object>(4);
                urlParam.put("totalNo", billNo);
                urlParam.put("companyId", outstockTotal.getOrgId());
                urlParam.put("yuanGuangType", YuanGuangType.OUT_INVENTORY_STATEMENT.getCode());
                Map<String, Object> fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.OUTSTOCK_TOTAL_GOODS_FORWARD.getCode(), billNo, outstockTotal.getOrgId(), ".pdf", string, urlParam, d);
                if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                    d = (Double)fileInfoMap.get("bytesTotalLen");
                    BusiOutStockGoodsTraFileReqBO fjxx = new BusiOutStockGoodsTraFileReqBO();
                    fjxx.setName((String)fileInfoMap.get("name"));
                    fjxx.setContent((String)fileInfoMap.get("content"));
                    attachItems.add(fjxx);
                }
                logger.debug("\u4f20\u9001\u6587\u4ef6\u5b57\u8282\u957f\u5ea6:" + d);
            }
            if (CollectionUtils.isEmpty((Collection)attachItems)) {
                BusiOutStockGoodsTraFileReqBO busiOutStockGoodsTraFileReqBO = new BusiOutStockGoodsTraFileReqBO();
                busiOutStockGoodsTraFileReqBO.setName("");
                busiOutStockGoodsTraFileReqBO.setContent("");
                attachItems.add(busiOutStockGoodsTraFileReqBO);
            }
            traReqBO.setAttachItems((List)attachItems);
            traRspBO = null;
            try {
                traRspBO = this.busiOutStockGoodsTraService.receiveStockGoodsTransfer(traReqBO);
                wfEventResult1.setSsn(traRspBO.getCwdjid());
                if ("1".equals(traRspBO.getRspcode())) {
                    wfEventResult1.setSuccess(true);
                } else {
                    wfEventResult1.setSuccess(false);
                }
                wfEventResult1.setRespDesc(traRspBO.getRspmsg());
                wfEventResult1.setRespCode(traRspBO.getRspcode());
            }
            catch (Exception exception) {
                logger.error("\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo, (Throwable)exception);
                wfEventResult1.setSuccess(false);
                wfEventResult1.setRespDesc("\u9519\u8bef\u4fe1\u606f:" + exception);
            }
        }
        WFEventResult wfEventResult2 = new WFEventResult();
        BusiOutStockIncomeCalcRspBO calcRspBO = new BusiOutStockIncomeCalcRspBO();
        calcRspBO.setRspcode("1");
        if (FinancialStatus.NO_SEND.getCode().equals(financialStatus) || FinancialStatus.SEND_FAIL.getCode().equals(financialStatus) || FinancialStatus.SEND_SUCCESS_1.getCode().equals(financialStatus)) {
            BusiOutStockIncomeCalcReqBO calcReqBO = new BusiOutStockIncomeCalcReqBO();
            FinanceConfig financeConfig = this.financeConfigMapper.selectByPrimaryKey(targetSource, outstockTotal.getOrgId(), YuanGuangType.OUT_REVENUE_SHEET.getCode());
            if (financeConfig == null) {
                logger.error("\u6839\u636e\u6765\u6e90\uff1a" + source + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + outstockTotal.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.OUT_REVENUE_SHEET.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                throw new PfscExtBusinessException("18001", "\u6839\u636e\u6765\u6e90\uff1a" + source + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + outstockTotal.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.OUT_REVENUE_SHEET.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f");
            }
            Map<String, String> map = this.queryDictKeyValueService.queryDictKeyValue(targetSource, YuanGuangType.OUT_REVENUE_SHEET.getCode(), outstockTotal.getOrgId());
            calcReqBO.setSeqid("PAY" + YuanGuangType.OUT_REVENUE_SHEET.getCode() + billNo);
            calcReqBO.setSsdw(financeConfig.getUnitName());
            calcReqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(source, financeConfig, outstockTotal.getUserId()));
            calcReqBO.setFlowid(financeConfig.getProcessId());
            HashMap<String, String> saleOrderCodes = new HashMap<String, String>(16);
            LinkedList<Object> itemS = new LinkedList<Object>();
            for (OutstockInfo outstockInfo : list) {
                BusiOutStockIncomeCalcDetailReqBO calcDetailReqBO = new BusiOutStockIncomeCalcDetailReqBO();
                PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(outstockInfo.getPurchaseProjectId());
                if (purchaseUnitInfo == null) {
                    String projectName = this.organizationInfoService.queryProjectName(outstockInfo.getPurchaseProjectId()).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                    throw new PfscExtBusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + outstockInfo.getPurchaseProjectId() + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                }
                String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                calcDetailReqBO.setXshtbh(xshtbh);
                calcDetailReqBO.setJjnr("\u5e94\u6536" + purchaseUnitInfo.getPurchaseProjectName() + "\u300a\u9500\u552e\u5408\u540c\u300b" + calcDetailReqBO.getXshtbh() + "\u7269\u8d44\u6b3e");
                calcDetailReqBO.setWldw(purchaseUnitInfo.getPurchaseProjectName());
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(outstockInfo.getApplyNo());
                if (billApplyInfo == null) {
                    logger.error("\u6839\u636e\u5f00\u7968\u7533\u8bf7\u7f16\u53f7\uff1a" + outstockInfo.getApplyNo() + "\u5728\u91c7\u8d2d\u5355\u4f4d\u5f00\u7968\u7533\u8bf7\u8868d_bill_apply_info\u67e5\u4e0d\u5230\u6570\u636e\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo);
                    throw new PfscExtBusinessException("18001", "\u6839\u636e\u5f00\u7968\u7533\u8bf7\u7f16\u53f7\uff1a" + outstockInfo.getApplyNo() + "\u5728\u91c7\u8d2d\u5355\u4f4d\u5f00\u7968\u7533\u8bf7\u8868d_bill_apply_info\u67e5\u4e0d\u5230\u6570\u636e");
                }
                calcDetailReqBO.setKhyh(billApplyInfo.getBankName() == null ? "" : billApplyInfo.getBankName());
                calcDetailReqBO.setYhzh(billApplyInfo.getBankAcctNo() == null ? "" : billApplyInfo.getBankAcctNo());
                calcDetailReqBO.setNsrsbh(billApplyInfo.getTaxNo() == null ? "" : billApplyInfo.getTaxNo());
                calcDetailReqBO.setLxdz(billApplyInfo.getAddr() == null ? "" : billApplyInfo.getAddr());
                calcDetailReqBO.setYszkje(BigDecimal.ZERO);
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    calcDetailReqBO.setBccxyszk(outstockInfo.getAmount());
                } else {
                    calcDetailReqBO.setBccxyszk(BigDecimal.ZERO);
                }
                calcDetailReqBO.setSpfl(map.get("\u5546\u54c1\u5206\u7c7b"));
                calcDetailReqBO.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
                calcDetailReqBO.setSpzl(map.get("\u5546\u54c1\u79cd\u7c7b"));
                calcDetailReqBO.setJldw(map.get("\u8ba1\u91cf\u5355\u4f4d"));
                calcDetailReqBO.setAmount(BigDecimal.ZERO);
                calcDetailReqBO.setHsdj(BigDecimal.ZERO);
                calcDetailReqBO.setHsje(outstockInfo.getAmount());
                calcDetailReqBO.setTaxRate(this.enumsService.queryDefaultTaxRate());
                calcDetailReqBO.setSe(outstockInfo.getTaxAmt());
                calcDetailReqBO.setBhsje(outstockInfo.getUntaxAmt());
                HashSet<Long> inspectionIds = new HashSet<Long>();
                List<OutstockDetail> list1 = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
                if (list1.isEmpty()) {
                    logger.error("\u672a\u627e\u5230\u51fa\u5e93\u660e\u7ec6\u3002\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo());
                    throw new PfscExtBusinessException("18001", "\u672a\u627e\u5230\u51fa\u5e93\u660e\u7ec6\u3002\u51fa\u5e93\u5355\u53f7\uff1a" + outstockInfo.getOutstockNo());
                }
                for (OutstockDetail outstockDetail : list1) {
                    inspectionIds.add(outstockDetail.getInspectionId());
                    SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
                    saleOrderInfo1.setInspectionId(outstockDetail.getInspectionId());
                    SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo1);
                    if (saleOrderInfo == null) {
                        logger.error("\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
                        throw new PfscExtBusinessException("18001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + outstockDetail.getInspectionId() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
                    }
                    if (saleOrderCodes.containsKey(saleOrderInfo.getSaleOrderCode())) continue;
                    String projectName = this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName();
                    saleOrderCodes.put(saleOrderInfo.getSaleOrderCode(), projectName);
                }
                BigDecimal bzjkk = BigDecimal.ZERO;
                BigDecimal ysje = null;
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    ysje = BigDecimal.ZERO;
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    Map<Long, BigDecimal> warrantyAmts = this.invokePaycenterService.obtainWarrantyAmt4SaleInspection(new ArrayList<Long>(inspectionIds));
                    for (BigDecimal warrantyAmt : warrantyAmts.values()) {
                        bzjkk = bzjkk.add(warrantyAmt);
                    }
                    ysje = outstockInfo.getAmount().subtract(bzjkk);
                } else {
                    ysje = outstockInfo.getAmount().subtract(outstockInfo.getWriteoffAmt());
                }
                calcDetailReqBO.setBzjkk(bzjkk);
                calcDetailReqBO.setYsje(ysje);
                itemS.add(calcDetailReqBO);
            }
            calcReqBO.setItems(itemS);
            StringBuilder summary = new StringBuilder();
            if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entry : saleOrderCodes.entrySet()) {
                    stringBuilder.append((String)entry.getKey()).append("\u3010").append((String)entry.getValue()).append("\u3011");
                }
                summary.append("\u9500\u552e\u7269\u8d44\u6b3e(").append((CharSequence)stringBuilder).append(")");
            } else {
                summary.append(financeConfig.getBillName()).append(calcReqBO.getSeqid());
                if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                    summary.append("[").append((CharSequence)purchaseProjectNames).append("]");
                }
            }
            String string2 = summary.toString();
            string2 = FscStringUtils.cutStringByByte(string2, "UTF-8", 200);
            calcReqBO.setSummary(string2);
            ArrayList excelAttachItems = new ArrayList();
            calcReqBO.setExcelAttachItems(excelAttachItems);
            LinkedList<BusiTransferPayIncomeCalcPdfAttachReqBO> linkedList = new LinkedList<BusiTransferPayIncomeCalcPdfAttachReqBO>();
            calcReqBO.setPdfAttachItems(linkedList);
            if ("1".equals(this.enumsService.querFileTransmitYuanGuangSwitch(source))) {
                BusiTransferPayIncomeCalcPdfAttachReqBO fjxx;
                double bytesTotalLen = 0.0;
                String subUrl = "/rest/download/busiExportOutstockTotalController";
                HashMap<String, Object> urlParam = new HashMap<String, Object>(4);
                urlParam.put("totalNo", billNo);
                urlParam.put("companyId", outstockTotal.getOrgId());
                urlParam.put("yuanGuangType", YuanGuangType.OUT_REVENUE_SHEET.getCode());
                Map<String, Object> fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.OUTSTOCK_TOTAL_GOODS_SALES.getCode(), billNo, outstockTotal.getOrgId(), ".pdf", subUrl, urlParam, bytesTotalLen);
                if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                    bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                    BusiTransferPayIncomeCalcPdfAttachReqBO fjxx2 = new BusiTransferPayIncomeCalcPdfAttachReqBO();
                    fjxx2.setName((String)fileInfoMap.get("name"));
                    fjxx2.setContent((String)fileInfoMap.get("content"));
                    linkedList.add(fjxx2);
                }
                subUrl = "/rest/download/busiExportOutInvoicePdfController";
                urlParam = new HashMap(4);
                urlParam.put("totalNo", billNo);
                String companyName = this.organizationInfoService.queryOrgName(outstockTotal.getOrgId());
                urlParam.put("companyName", companyName);
                String suffixName = ".pdf";
                fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.OUTSTOCK_TOTAL_OUTBOUND_INVOICE.getCode(), billNo, outstockTotal.getOrgId(), suffixName, subUrl, urlParam, bytesTotalLen);
                if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                    bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                    fjxx = new BusiTransferPayIncomeCalcPdfAttachReqBO();
                    fjxx.setName((String)fileInfoMap.get("name"));
                    fjxx.setContent((String)fileInfoMap.get("content"));
                    linkedList.add(fjxx);
                }
                subUrl = "/rest/download/busiExportListOutstockInfoController";
                urlParam = new HashMap(2);
                urlParam.put("totalNo", billNo);
                fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.OUTSTOCK_TOTAL_OUTBOUND_DETAIL.getCode(), billNo, outstockTotal.getOrgId(), ".pdf", subUrl, urlParam, bytesTotalLen);
                if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                    bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                    fjxx = new BusiTransferPayIncomeCalcPdfAttachReqBO();
                    fjxx.setName((String)fileInfoMap.get("name"));
                    fjxx.setContent((String)fileInfoMap.get("content"));
                    linkedList.add(fjxx);
                }
                logger.debug("\u4f20\u9001\u6587\u4ef6\u5b57\u8282\u957f\u5ea6:" + bytesTotalLen);
            }
            calcRspBO = null;
            try {
                calcRspBO = this.busiOutStockIncomeCalcService.receiveIncomeCalc(calcReqBO);
                wfEventResult2.setSsn(calcRspBO.getCwdjid());
                if ("1".equals(calcRspBO.getRspcode())) {
                    wfEventResult2.setSuccess(true);
                } else {
                    wfEventResult2.setSuccess(false);
                }
                wfEventResult2.setRespDesc(calcRspBO.getRspmsg());
                wfEventResult2.setRespCode(calcRspBO.getRspcode());
            }
            catch (Exception e) {
                logger.error("\u6536\u5165\u8ba1\u7b97\u5355\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\u3002\u4e1a\u52a1\u6d41\u6c34\u53f7=" + billNo, (Throwable)e);
                wfEventResult2.setSuccess(false);
                wfEventResult2.setRespDesc("\u9519\u8bef\u4fe1\u606f:" + e);
            }
        }
        WFEventResult wfEventResult = new WFEventResult();
        wfEventResult.setSuccess(false);
        if (traRspBO != null && "1".equals(traRspBO.getRspcode()) && calcRspBO != null && "1".equals(calcRspBO.getRspcode())) {
            wfEventResult.setFinancialStatus(FinancialStatus.SEND_SUCCESS.getCode());
            wfEventResult.setSuccess(true);
        } else if (traRspBO != null && "1".equals(traRspBO.getRspcode()) && (calcRspBO == null || !"1".equals(calcRspBO.getRspcode()))) {
            wfEventResult.setFinancialStatus(FinancialStatus.SEND_SUCCESS_1.getCode());
        } else if ((traRspBO == null || !"1".equals(traRspBO.getRspcode())) && calcRspBO != null && "1".equals(calcRspBO.getRspcode())) {
            wfEventResult.setFinancialStatus(FinancialStatus.SEND_SUCCESS_2.getCode());
        } else {
            wfEventResult.setFinancialStatus(FinancialStatus.SEND_FAIL.getCode());
        }
        ArrayList<String> refNos = new ArrayList<String>();
        if (StringUtils.hasText((String)wfEventResult1.getSsn())) {
            refNos.add(wfEventResult1.getSsn());
        }
        if (StringUtils.hasText((String)refNo)) {
            refNos.add(refNo);
        }
        if (StringUtils.hasText((String)wfEventResult2.getSsn())) {
            refNos.add(wfEventResult2.getSsn());
        }
        refNo = FscStringUtils.list2String(refNos, ",");
        String returnMsg = "";
        if (StringUtils.hasText((String)wfEventResult1.getRespDesc())) {
            returnMsg = "\u5e93\u5b58\u5546\u54c1\u7ed3\u8f6c\u5355:" + wfEventResult1.getRespDesc() + "\u3002";
        }
        if (StringUtils.hasText((String)wfEventResult2.getRespDesc())) {
            returnMsg = returnMsg + "\u6536\u5165\u8ba1\u7b97\u5355:" + wfEventResult2.getRespDesc() + "\u3002";
        }
        wfEventResult.setSsn(refNo);
        wfEventResult.setRespDesc(returnMsg);
        return wfEventResult;
    }
}

