/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfsc.dao.MainAcctInfoMapper;
import com.tydic.pfsc.dao.PurchaseUnitInfoMapper;
import com.tydic.pfsc.dao.SubAcctInfoMapper;
import com.tydic.pfsc.dao.po.MainAcctInfo;
import com.tydic.pfsc.dao.po.SubAcctInfo;
import com.tydic.pfsc.enums.SubAccountServiceType;
import com.tydic.pfsc.enums.SubAccountStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.AccountTransferService;
import com.tydic.pfsc.service.atom.CurrencyService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.PingAnBankService;
import com.tydic.pfsc.service.atom.SubAccountService;
import com.tydic.pfsc.service.atom.bo.CacheInfo;
import com.tydic.pfsc.service.atom.bo.PingAnResult;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="subAccountServiceImpl")
public class SubAccountServiceImpl
implements SubAccountService {
    private static final Log logger = LogFactory.getLog(SubAccountServiceImpl.class);
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private MainAcctInfoMapper mainAcctMapper;
    @Autowired
    private PingAnBankService pinganBankService;
    @Autowired
    private AccountTransferService accountTransferService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PurchaseUnitInfoMapper purchaseUnitInfoMapper;
    private Map<String, CacheInfo> acctNamesCache = new HashMap<String, CacheInfo>();

    @Override
    public SubAcctInfo addSubAccount(SubAcctInfo subAcctInfo) {
        PingAnResult result;
        String mainAcctNo = subAcctInfo.getMainAcctNo();
        if (mainAcctNo == null || mainAcctNo.length() == 0) {
            throw new PfscExtBusinessException("0001", "\u4e3b\u8d26\u53f7\u5fc5\u987b\u8f93\u5165(mainAcctNo)");
        }
        Long orgId = subAcctInfo.getOrgId();
        if (orgId == null || orgId == 0L) {
            throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u6240\u5c5e\u7684\u673a\u6784\u53f7\u65e0\u6548(orgId)");
        }
        SubAcctInfo checkCount = new SubAcctInfo();
        checkCount.setOrgId(subAcctInfo.getOrgId());
        checkCount.setServiceType(subAcctInfo.getServiceType());
        checkCount.setMainAcctNo(mainAcctNo);
        checkCount.setProjectId(subAcctInfo.getProjectId());
        int existsCnt = this.subAcctInfoMapper.selectForCount(checkCount);
        if (existsCnt > 0) {
            throw new PfscExtBusinessException("18002", "\u8be5\u5355\u4f4d\u5bf9\u5e94\u7684\u4e13\u4e1a\u516c\u53f8\u4e1a\u52a1\u677f\u5757\u5df2\u5b58\u5728\u8d44\u91d1\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8d26\u6237");
        }
        MainAcctInfo mainAcctInfo = this.mainAcctMapper.selectByMainAcc(mainAcctNo);
        if (mainAcctInfo == null) {
            throw new PfscExtBusinessException("18001", "\u4e3b\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        Long mainOrgId = mainAcctInfo.getOrgId();
        SubAccountServiceType srvType = SubAccountServiceType.convert(subAcctInfo.getServiceType());
        if (mainOrgId.equals(orgId) && SubAccountServiceType.DEFAULT == srvType) {
            logger.info((Object)("\u521b\u5efa\u5b50\u8d26\u53f7\u5931\u8d25,\u5b50\u8d26\u53f7\u7684\u6240\u5c5e\u673a\u6784(" + orgId + ")\u4e0e\u4e3b\u8d26\u53f7\u7684(" + mainOrgId + ")\u76f8\u540c,\u4e0d\u5141\u8bb8\u521b\u5efa10\u670d\u52a1\u7c7b\u578b\u7684\u5b50\u8d26\u53f7"));
            throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u7684\u6240\u5c5e\u673a\u6784\u4e0e\u4e3b\u8d26\u53f7\u7684\u76f8\u540c,\u4e0d\u5141\u8bb8\u521b\u5efa\u91c7\u8d2d\u670d\u52a1\u7c7b\u578b\u7684\u5b50\u8d26\u53f7.");
        }
        BigDecimal overDraft = subAcctInfo.getOverdraft();
        if (overDraft == null || overDraft.compareTo(BigDecimal.ZERO) < 0) {
            overDraft = new BigDecimal("0");
        }
        boolean allowOverdraft = false;
        if (overDraft.compareTo(BigDecimal.ZERO) > 0) {
            allowOverdraft = true;
        }
        if (!(result = this.pinganBankService.createSubAccount(mainAcctNo, subAcctInfo.getSubAcctName(), allowOverdraft)).isSuccess()) {
            throw new PfscExtBusinessException("18000", "\u4ea7\u751f\u5b50\u8d26\u53f7\u5931\u8d25," + result.getReturnMsg());
        }
        String subAcctNo = result.getSubAcctNo();
        if (subAcctNo == null || subAcctNo.length() == 0) {
            throw new PfscExtBusinessException("18000", "\u672a\u8fd4\u56de\u6709\u6548\u5b50\u8d26\u53f7" + result.getReturnMsg());
        }
        subAcctInfo.setCcy(CurrencyService.getCcy(subAcctInfo.getCcy()));
        subAcctInfo.setSubAcctNo(subAcctNo);
        subAcctInfo.setStatus(subAcctInfo.getStatus());
        subAcctInfo.setBalance(BigDecimal.ZERO);
        subAcctInfo.setUsedOverdraft(BigDecimal.ZERO);
        subAcctInfo.setCreateDate(new Date());
        try {
            this.subAcctInfoMapper.insert(subAcctInfo);
            logger.debug((Object)("\u6210\u529f\u521b\u5efa\u5b50\u8d26\u53f7,acctNo=" + subAcctNo + " \u670d\u52a1\u7c7b\u578b=" + subAcctInfo.getServiceType() + " \u673a\u6784=" + subAcctInfo.getOrgId() + " \u8d26\u5957=" + subAcctInfo.getProjectId() + " \u900f\u652f\u989d=" + overDraft));
        }
        catch (Exception e) {
            logger.error((Object)("\u65b0\u5efa\u5b50\u8d26\u53f7\u5931\u8d25\r\n" + subAcctInfo.toString()), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u65b0\u5efa\u5b50\u8d26\u53f7\u5931\u8d25," + e.getMessage());
        }
        subAcctInfo.setRespCode("0000");
        subAcctInfo.setRespDesc("\u6210\u529f");
        return subAcctInfo;
    }

    @Override
    public SubAcctInfo loadSubAccount(String subAcctNo) {
        if (subAcctNo == null || subAcctNo.length() == 0) {
            return null;
        }
        return this.subAcctInfoMapper.selectByPrimaryKey(subAcctNo);
    }

    @Override
    public SubAcctInfo modifySubAccount(SubAcctInfo subAcctInfo) {
        String subAcctNo = subAcctInfo.getSubAcctNo();
        if (subAcctNo == null || subAcctNo.length() == 0) {
            throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        SubAcctInfo acInfo = this.loadSubAccount(subAcctNo);
        if (acInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        String sta = subAcctInfo.getStatus();
        SubAccountStatus status = SubAccountStatus.getCode(sta);
        if (status == null) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u53ef\u8bc6\u522b\u7684\u72b6\u6001\u503c");
        }
        BigDecimal overdraft = subAcctInfo.getOverdraft();
        if (overdraft != null && overdraft.compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("0001", "\u900f\u652f\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        BigDecimal balance = acInfo.getBalance();
        if (overdraft != null && balance != null && balance.compareTo(BigDecimal.ZERO) < 0 && balance.abs().compareTo(overdraft) > 0) {
            throw new PfscExtBusinessException("0001", "\u6b64\u8d26\u6237\u53f7\u900f\u652f\u7684\u91d1\u989d\u5df2\u8d85\u8fc7\u6b64\u989d\u5ea6");
        }
        SubAcctInfoExt withMainAccount = this.getWithMainAccount(subAcctNo);
        if (withMainAccount == null) {
            throw new PfscExtBusinessException("18001", "\u6ca1\u6709\u627e\u5230\u5b50\u8d26\u6237");
        }
        SubAcctInfo forUpdate = new SubAcctInfo();
        forUpdate.setSubAcctNo(subAcctNo);
        forUpdate.setOverdraft(overdraft);
        forUpdate.setStatus(subAcctInfo.getStatus());
        forUpdate.setUpdateOrgId(subAcctInfo.getUpdateOrgId());
        forUpdate.setUpdateId(subAcctInfo.getUpdateId());
        forUpdate.setUpdateDate(new Date());
        if (balance == null) {
            forUpdate.setBalance(BigDecimal.ZERO);
        }
        this.subAcctInfoMapper.updateByPrimaryKeySelective(forUpdate);
        acInfo.setStatus(forUpdate.getStatus());
        acInfo.setOverdraft(forUpdate.getOverdraft());
        acInfo.setUpdateDate(forUpdate.getUpdateDate());
        acInfo.setUpdateId(forUpdate.getUpdateId());
        acInfo.setUpdateOrgId(forUpdate.getUpdateOrgId());
        return acInfo;
    }

    @Override
    public List<SubAcctInfo> listSubAccount(SubAcctInfo subAcctInfo) {
        return this.subAcctInfoMapper.selectSelective(subAcctInfo);
    }

    @Override
    public SubAcctInfoExt getWithMainAccount(String subAcctNo) {
        SubAcctInfoExt infoExt = new SubAcctInfoExt();
        infoExt.setSubAcctNo(subAcctNo);
        List<SubAcctInfoExt> ls = this.subAcctInfoMapper.selectWihtMainAcct(infoExt);
        if (CollectionUtils.isEmpty(ls)) {
            return null;
        }
        logger.info((Object)("\u5b50\u8d26\u53f7\u8054\u52a8\u4e3b\u8d26\u53f7\u67e5\u8be2,\u8bb0\u5f55\u6570:" + ls.size() + ",subAcctNo=" + subAcctNo));
        return ls.get(0);
    }

    @Override
    public SubAcctInfoExt getWithMainAccount(Long mainOrgId, String source, Long subOrgId, Long projectId, Integer serviceType) {
        if (serviceType == null) {
            serviceType = SubAccountServiceType.DEFAULT.getCode();
        }
        if (mainOrgId == null || mainOrgId < 1L) {
            throw new PfscExtBusinessException("0001", "\u4e3b\u8d26\u53f7\u7684\u673a\u6784\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!StringUtils.hasText((String)source)) {
            throw new PfscExtBusinessException("0001", "\u4e3b\u8d26\u53f7\u7684\u6765\u6e90\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SubAcctInfoExt infoExt = new SubAcctInfoExt();
        infoExt.setSuperiorOrgId(mainOrgId);
        infoExt.setSource(source);
        infoExt.setOrgId(subOrgId);
        infoExt.setProjectId(projectId);
        infoExt.setServiceType(serviceType);
        infoExt.setStatus(SubAccountStatus.ACTIVED.getCode());
        List<SubAcctInfoExt> ls = this.subAcctInfoMapper.selectWihtMainAcct(infoExt);
        int size = ls.size();
        if (size == 0) {
            logger.info((Object)("\u5b50\u8d26\u53f7\u8054\u52a8\u4e3b\u8d26\u53f7\u67e5\u8be2,\u5b50\u8d26\u53f7\u4e0d\u5b58\u5728:mainOrgId=" + mainOrgId + ",source=" + source + ",subOrgId=" + subOrgId + ",projectId=" + projectId + ",serviceType=" + serviceType));
            return null;
        }
        if (size > 1) {
            logger.info((Object)("\u5b50\u8d26\u53f7\u8054\u52a8\u4e3b\u8d26\u53f7\u67e5\u8be2,\u8bb0\u5f55\u6570:" + size + ",mainOrgId=" + mainOrgId + ",source=" + source + ",subOrgId=" + subOrgId + ",projectId=" + projectId + ",serviceType=" + serviceType));
        }
        return ls.get(0);
    }

    @Override
    public String accountTransfer(String fromAcctNo, String toAcctNo, BigDecimal amount, long busiTxnNo, String remark, boolean canOverDraft, boolean needInformBank, boolean needChangeSubAcct) {
        if (fromAcctNo == null || toAcctNo == null || fromAcctNo.length() == 0 || toAcctNo.length() == 0) {
            throw new PfscExtBusinessException("0001", "\u8f6c\u51fa\u6216\u8f6c\u5165\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (fromAcctNo.equals(toAcctNo)) {
            throw new PfscExtBusinessException("0001", "\u8f6c\u51fa\u548c\u8f6c\u5165\u8d26\u53f7\u4e0d\u5141\u8bb8\u76f8\u540c");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u4ea4\u6613\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        SubAcctInfoExt fromAcctInfo = this.getWithMainAccount(fromAcctNo);
        if (fromAcctInfo == null) {
            throw new PfscExtBusinessException("0001", "\u8f6c\u51fa\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        SubAcctInfoExt toAcctInfo = this.getWithMainAccount(toAcctNo);
        if (toAcctInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!fromAcctInfo.getMainAcctNo().equals(toAcctInfo.getMainAcctNo())) {
            throw new PfscExtBusinessException("18000", "\u5206\u5c5e\u4e0d\u540c\u4e3b\u8d26\u53f7\u7684\u5b50\u8d26\u53f7\u4e0d\u5141\u8bb8\u5212\u8f6c");
        }
        if (!StringUtils.hasText((String)remark)) {
            remark = "\u5b50\u8d26\u53f7\u8f6c\u8d26";
        }
        PingAnResult result = null;
        if (needInformBank) {
            result = this.pinganBankService.accountTransfer(fromAcctInfo.getMainAcctNo(), fromAcctInfo.getMainAcctName(), null, fromAcctNo, fromAcctInfo.getSubAcctName(), toAcctNo, toAcctInfo.getSubAcctName(), amount, remark);
            if (!result.isSuccess()) {
                throw new PfscExtBusinessException("18005", "\u8c03\u7528\u8f6c\u8d26\u63a5\u53e3\u5931\u8d25," + result.getReturnMsg());
            }
            if (needChangeSubAcct) {
                this.accountTransferService.tranProcessWithoutTransactional(fromAcctNo, toAcctNo, amount, busiTxnNo, canOverDraft);
            }
        } else if (needChangeSubAcct) {
            this.accountTransferService.tranProcessWithoutTransactional(fromAcctNo, toAcctNo, amount, busiTxnNo, canOverDraft);
        }
        if (result != null) {
            return result.getResSn();
        }
        return null;
    }

    @Override
    public String getAcctName(String subAcctNo) {
        String name = "";
        if (subAcctNo == null || subAcctNo.length() == 0) {
            return name;
        }
        CacheInfo inf = CacheInfo.getInCache(this.acctNamesCache, subAcctNo);
        if (inf != null) {
            if (inf.getOb() == null) {
                return name;
            }
            name = (String)inf.getOb();
            return name;
        }
        SubAcctInfo subInfo = this.loadSubAccount(subAcctNo);
        if (subInfo != null) {
            name = subInfo.getSubAcctName();
            CacheInfo.putToCache(this.acctNamesCache, subAcctNo, name, 120);
        }
        return name;
    }
}

