/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService;
import com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourReqBO;
import com.tydic.pfsc.api.busi.bo.BusiBackInvoiceAtourRspBO;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourReqBO;
import com.tydic.pfsc.api.busi.bo.InvoiceDetailsBO;
import com.tydic.pfsc.api.busi.bo.RelationListBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.PayOrderInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemApplyInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.InvoiceReturnStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiBackInvoiceAtourService"})
public class BusiBackInvoiceAtourServiceImpl
implements BusiBackInvoiceAtourService {
    private static final Logger log = LoggerFactory.getLogger(BusiBackInvoiceAtourServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleItemApplyInfoMapper saleItemApplyInfoMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private BusiInvoiceIssueAtourService busiInvoiceIssueAtourService;

    @PostMapping(value={"busiBackInvoiceAtour"})
    public BusiBackInvoiceAtourRspBO busiBackInvoiceAtour(@RequestBody BusiBackInvoiceAtourReqBO reqBO) {
        BusiBackInvoiceAtourRspBO rspBO = new BusiBackInvoiceAtourRspBO();
        if (reqBO == null || reqBO.getInvoiceMain() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getInvoiceMain().getSalesbillNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[bill_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getInvoiceMain().getInvoiceCode())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4ee3\u7801[invoiceCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String invoiceNo = reqBO.getInvoiceMain().getInvoiceNo();
        if (!StringUtils.hasText((String)invoiceNo)) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u53f7\u7801[invoiceNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getPaperDrewDate() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u65e5\u671f[paperDrewDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getAmountWithoutTax() == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09[amountWithoutTax]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getTaxRate() == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7a0e\u989d[taxRate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceMain().getStatus() == null) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u72b6\u6001[status]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvoiceDetails() == null || reqBO.getInvoiceDetails().size() == 0) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u660e\u7ec6[invoiceDetails]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getRelationList() == null || reqBO.getRelationList().size() == 0) {
            throw new PfscExtBusinessException("0001", "\u660e\u7ec6\u5173\u7cfb[relationList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String invoiceStatus = reqBO.getInvoiceMain().getStatus().toString();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            log.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]");
        }
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
        if ("0".equals(invoiceStatus)) {
            InvoiceReturn invoiceReturn;
            if (saleInvoiceInfo == null) {
                log.error("\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                throw new PfscExtBusinessException("18000", "\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u4e0d\u5b58\u5728\u3002");
            }
            String returnBillNo = billApplyInfo.getReturnBillNo();
            SaleInvoiceInfo saleInvoiceInfo1 = new SaleInvoiceInfo();
            saleInvoiceInfo1.setInvoiceNo(invoiceNo);
            saleInvoiceInfo1.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.CANCEL.getCode());
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(saleInvoiceInfo1);
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNo(applyNo);
            List<SaleOrderInfo> list = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
            for (SaleOrderInfo saleOrderInfo : list) {
                SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
                saleOrderInfo1.setInspectionId(saleOrderInfo.getInspectionId());
                saleOrderInfo1.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo1);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setInspectionId(saleOrderInfo.getInspectionId());
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setItemStatus("00");
                this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
            }
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            List<SaleInvoiceInfo> invoice1s = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            int count = 0;
            for (SaleInvoiceInfo invoice1 : invoice1s) {
                if (!SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(invoice1.getInvoiceStatus())) continue;
                ++count;
            }
            if (count > 0) {
                String billStatus = count == invoice1s.size() ? BillStatus.INVOICE_RETURN.getCode() : BillStatus.INVOICE_RETURN_PART.getCode();
                BillApplyInfo apply1 = new BillApplyInfo();
                apply1.setApplyNo(applyNo);
                apply1.setBillStatus(billStatus);
                this.billApplyInfoMapper.updateByPrimaryKeySelective(apply1);
            }
            InvoiceReturnDetail invoiceReturnDetail = new InvoiceReturnDetail();
            invoiceReturnDetail.setBillNo(returnBillNo);
            List<InvoiceReturnDetail> list1 = this.invoiceReturnDetailMapper.getList(invoiceReturnDetail);
            boolean flag = true;
            for (InvoiceReturnDetail returnDetail : list1) {
                SaleInvoiceInfo saleInvoiceInfo2 = this.saleInvoiceInfoMapper.selectByInvId(returnDetail.getInvoiceNo1());
                if (SaleInvoiceInfoInvoiceStatus.CANCEL.getCode().equals(saleInvoiceInfo2.getInvoiceStatus())) {
                    flag = true;
                    continue;
                }
                flag = false;
            }
            if (flag) {
                InvoiceReturnVO vo = new InvoiceReturnVO();
                vo.setBillNo(returnBillNo);
                vo.setStatus(InvoiceReturnStatus.RETURNED.getCode());
                this.invoiceReturnMapper.updateByPrimaryKeySelective(vo);
            }
            if ((invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(returnBillNo)) != null && invoiceReturn.getRepeatApplyNo() != null) {
                BusiInvoiceIssueAtourReqBO atourReqBO = new BusiInvoiceIssueAtourReqBO();
                ArrayList<String> applyNoList = new ArrayList<String>();
                applyNoList.add(invoiceReturn.getRepeatApplyNo());
                atourReqBO.setApplyNoList(applyNoList);
                this.busiInvoiceIssueAtourService.invoiceIssue(atourReqBO);
                BillApplyInfo billApply = new BillApplyInfo();
                billApply.setApplyNo(invoiceReturn.getRepeatApplyNo());
                billApply.setBillStatus("02");
                billApply.setBillApplyType("2");
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
            }
            return rspBO;
        }
        if (saleInvoiceInfo != null) {
            log.error("\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18000", "\u8be5\u53d1\u7968[\u53d1\u7968\u53f7\u7801=" + invoiceNo + "]\u5728\u5546\u57ce\u7cfb\u7edf\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u63a8\u9001\u3002");
        }
        BigDecimal sumUntaxAmt = BigDecimal.ZERO;
        BigDecimal sumTaxAmt = BigDecimal.ZERO;
        for (InvoiceDetailsBO detailReqBO : reqBO.getInvoiceDetails()) {
            if (null == detailReqBO.getAmountWithoutTax()) {
                throw new PfscExtBusinessException("0001", "\u91d1\u989d(\u4e0d\u542b\u7a0e) [amountWithoutTax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTaxAmount()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u989d [taxAmount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == detailReqBO.getTaxRate()) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u7387 [taxRate]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)detailReqBO.getGoodsTaxNo())) {
                throw new PfscExtBusinessException("0001", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801 [goodsTaxNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sumUntaxAmt = sumUntaxAmt.add(detailReqBO.getAmountWithoutTax());
            sumTaxAmt = sumTaxAmt.add(detailReqBO.getTaxAmount());
        }
        if (sumUntaxAmt.compareTo(reqBO.getInvoiceMain().getAmountWithoutTax()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u4e0d\u542b\u7a0e\u91d1\u989d\u603b\u548c\u4e0e\u53d1\u7968\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (sumTaxAmt.compareTo(reqBO.getInvoiceMain().getTaxAmount()) != 0) {
            log.error("\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u5165\u53c2=" + reqBO);
            throw new PfscExtBusinessException("18005", "\u53d1\u7968\u660e\u7ec6\u7a0e\u989d\u603b\u548c\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        saleInvoiceInfo = new SaleInvoiceInfo();
        saleInvoiceInfo.setInvoiceNo(invoiceNo);
        saleInvoiceInfo.setInvoiceCode(reqBO.getInvoiceMain().getInvoiceCode());
        log.error("\u7a0e\u63a7\u5f00\u7968\u65e5\u671f\uff1a" + reqBO.getInvoiceMain().getPaperDrewDate());
        saleInvoiceInfo.setInvoiceDate(reqBO.getInvoiceMain().getPaperDrewDate());
        log.error("\u53d1\u7968\u8868\u5f00\u7968\u65e5\u671f\uff1a" + saleInvoiceInfo.getInvoiceDate());
        saleInvoiceInfo.setApplyNo(applyNo);
        saleInvoiceInfo.setUntaxAmt(reqBO.getInvoiceMain().getAmountWithoutTax());
        saleInvoiceInfo.setTaxAmt(reqBO.getInvoiceMain().getTaxAmount());
        saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
        saleInvoiceInfo.setInvoiceStatus("1");
        if ("s".equals(reqBO.getInvoiceMain().getInvoiceType())) {
            saleInvoiceInfo.setInvoiceType(2);
        } else {
            saleInvoiceInfo.setInvoiceType(1);
        }
        saleInvoiceInfo.setMailStatus("01");
        saleInvoiceInfo.setName(reqBO.getInvoiceMain().getSellerName());
        saleInvoiceInfo.setTaxNo(reqBO.getInvoiceMain().getSellerTaxNo());
        saleInvoiceInfo.setAddress(reqBO.getInvoiceMain().getSellerAddress());
        saleInvoiceInfo.setPhone(reqBO.getInvoiceMain().getSellerTel());
        saleInvoiceInfo.setBankName(reqBO.getInvoiceMain().getSellerBankName());
        saleInvoiceInfo.setBankAcNo(reqBO.getInvoiceMain().getSellerBankAccount());
        saleInvoiceInfo.setOrderId(reqBO.getInvoiceMain().getId().intValue());
        this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
        for (InvoiceDetailsBO detailBO : reqBO.getInvoiceDetails()) {
            Long itemNo = 1L;
            for (RelationListBO relationListBO : reqBO.getRelationList()) {
                if (relationListBO.getInvoiceItemId().longValue() != detailBO.getId().longValue()) continue;
                itemNo = Long.parseLong(relationListBO.getSalesbillItemNo());
            }
            BigDecimal taxAmt = detailBO.getTaxAmount();
            BigDecimal untaxAmt = detailBO.getAmountWithoutTax();
            BigDecimal amount = taxAmt.add(untaxAmt);
            SaleItemInfoVO saleItemInfoVO = null;
            if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNo(applyNo);
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
            } else {
                saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setItemNo(itemNo);
                saleItemInfoVO = this.saleItemInfoMapper.selectVOLimit(saleItemInfoVO);
            }
            SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
            saleInvoiceDetail.setItemName(detailBO.getCargoName());
            saleInvoiceDetail.setSpecModel(detailBO.getItemSpec());
            saleInvoiceDetail.setUnitName(detailBO.getQuantityUnit());
            saleInvoiceDetail.setQuantity(detailBO.getQuantity());
            saleInvoiceDetail.setUntaxAmt(untaxAmt);
            saleInvoiceDetail.setTaxAmt(taxAmt);
            saleInvoiceDetail.setAmount(amount);
            saleInvoiceDetail.setTaxRate(detailBO.getTaxRate());
            saleInvoiceDetail.setTaxClassCode(detailBO.getGoodsTaxNo());
            saleInvoiceDetail.setItemNo(itemNo);
            saleInvoiceDetail.setInvoiceNo(invoiceNo);
            if (!"2".equals(billApplyInfo.getPayFeeType())) {
                saleInvoiceDetail.setSaleUnitPrice(saleItemInfoVO.getSaleUnitPrice());
            }
            this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
            if ("2".equals(billApplyInfo.getPayFeeType())) continue;
            SaleInvoiceDetailVO saleInvoiceDetailVO = new SaleInvoiceDetailVO();
            saleInvoiceDetailVO.setApplyNo(applyNo);
            saleInvoiceDetailVO.setItemNo(itemNo);
            saleInvoiceDetail = this.saleInvoiceDetailMapper.selectSumOfItem(saleInvoiceDetailVO);
            if (!ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) continue;
            SaleItemApplyInfoVO saleItemApplyInfoVO = new SaleItemApplyInfoVO();
            saleItemApplyInfoVO.setApplyNo(applyNo);
            saleItemApplyInfoVO.setSeq(saleItemInfoVO.getSeq());
            saleItemApplyInfoVO.setTaxAmt(saleInvoiceDetail.getTaxAmt());
            saleItemApplyInfoVO.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
            this.saleItemApplyInfoMapper.updateByVO(saleItemApplyInfoVO);
        }
        if (BillStatus.SENDING_BILL.getCode().equals(billApplyInfo.getBillStatus())) {
            List<InvoiceReturnDetail> invoiceReturnDetails;
            InvoiceReturnDetailVO vo;
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
            saleInvoiceInfo = this.saleInvoiceInfoMapper.selectSum(saleInvoiceInfoVO);
            if (saleInvoiceInfo.getAmt().compareTo(billApplyInfo.getAmt()) >= 0) {
                BillApplyInfo billApplyInfo1 = new BillApplyInfo();
                billApplyInfo1.setApplyNo(applyNo);
                billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
            }
            if (billApplyInfo.getAmt().longValue() < 0L) {
                vo = new InvoiceReturnDetailVO();
                vo.setApplyNo2(applyNo);
                vo.setInvoiceNo2IsNull("1");
                invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
                InvoiceReturn invoiceReturn = new InvoiceReturn();
                invoiceReturn.setBillNo(invoiceReturnDetails.get(0).getBillNo());
                invoiceReturn.setStatus(InvoiceReturnStatus.RETURNED.getCode());
                this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
                InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                whereRecord.setBillNo(invoiceReturnDetails.get(0).getBillNo());
                InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                valueRecord.setInvoiceNo2(invoiceNo);
                this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
                InvoiceReturn invoiceReturnPO = this.invoiceReturnMapper.selectByPrimaryKey(invoiceReturnDetails.get(0).getBillNo());
                if (invoiceReturnPO != null && invoiceReturnPO.getRepeatApplyNo() != null) {
                    BusiInvoiceIssueAtourReqBO atourReqBO = new BusiInvoiceIssueAtourReqBO();
                    ArrayList<String> applyNoList = new ArrayList<String>();
                    applyNoList.add(invoiceReturnPO.getRepeatApplyNo());
                    atourReqBO.setApplyNoList(applyNoList);
                    this.busiInvoiceIssueAtourService.invoiceIssue(atourReqBO);
                    BillApplyInfo billApply = new BillApplyInfo();
                    billApply.setApplyNo(invoiceReturnPO.getRepeatApplyNo());
                    billApply.setBillStatus("02");
                    billApply.setBillApplyType("2");
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                }
            }
            if ("2".equals(billApplyInfo.getRedBlue()) && "2".equals(billApplyInfo.getBillApplyType())) {
                vo = new InvoiceReturnDetailVO();
                vo.setApplyNo3(applyNo);
                vo.setInvoiceNo3IsNull("1");
                invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
                InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
                whereRecord.setBillNo(invoiceReturnDetails.get(0).getBillNo());
                whereRecord.setInvoiceNo1(invoiceReturnDetails.get(0).getInvoiceNo1());
                InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
                valueRecord.setInvoiceNo3(invoiceNo);
                this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            }
        }
        if ("2".equals(billApplyInfo.getPayFeeType())) {
            this.payOrderInfoMapper.updateBillStatus("6", applyNo, new Date());
            BillApplyInfo billApplyInfo1 = new BillApplyInfo();
            billApplyInfo1.setApplyNo(applyNo);
            billApplyInfo1.setBillStatus(BillStatus.SEND_BILL.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo1);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

