/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.pfsc.api.busi.BusiApplyCreateNotificationService;
import com.tydic.pfsc.api.busi.BusiBillApplyInfoService;
import com.tydic.pfsc.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfsc.api.busi.ReconciliationHisService;
import com.tydic.pfsc.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfsc.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfsc.api.busi.bo.ReconciliationReqBo;
import com.tydic.pfsc.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfsc.api.busi.vo.ReconciliationHisVo;
import com.tydic.pfsc.api.busi.vo.ReconciliationRspVo;
import com.tydic.pfsc.api.zm.bo.AddBillApplyInfoReqBO;
import com.tydic.pfsc.api.zm.bo.AddBillApplyInfoRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.AccountantEngineService;
import com.tydic.pfsc.service.atom.PayableService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiBillApplyInfoService"})
public class BusiBillApplyInfoServiceImpl
implements BusiBillApplyInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillApplyInfoServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BusiCreateOutstockInfoService busiCreateOutstockInfoService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private ReconciliationHisService reconciliationHisService;
    @Autowired
    private BusiApplyCreateNotificationService busiApplyCreateNotificationService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;

    @PostMapping(value={"addBillApplyInfo"})
    public AddBillApplyInfoRspBO addBillApplyInfo(@RequestBody AddBillApplyInfoReqBO addBillApplyInfoReqBO) {
        Integer invType;
        log.info("\u95e8\u5e97\u5f00\u7968\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addBillApplyInfoReqBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        AddBillApplyInfoRspBO pfscExtRspBaseBO = new AddBillApplyInfoRspBO();
        if (addBillApplyInfoReqBO == null) {
            throw new PfscExtBusinessException("18000", "\u751f\u4ea7\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addBillApplyInfoReqBO.getMailAddrInfo() == null) {
            throw new PfscExtBusinessException("18000", "\u90ae\u5bc4\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addBillApplyInfoReqBO.getInvoiceInfo() == null) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addBillApplyInfoReqBO.getPurchaseNo() == null || addBillApplyInfoReqBO.getPurchaseNo() == 0L) {
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u53f7\u4e3a\u7a7a:{}", (Object)addBillApplyInfoReqBO.getPurchaseNo());
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u53f7\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)addBillApplyInfoReqBO.getPurchaseName())) {
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a:{}", (Object)addBillApplyInfoReqBO.getPurchaseName());
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u540d\u79f0\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)addBillApplyInfoReqBO.getPurchaseCode())) {
            log.debug("\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a:{}", (Object)addBillApplyInfoReqBO.getPurchaseCode());
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53d1\u8d77\u5931\u8d25\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        }
        if (!"2".equals(addBillApplyInfoReqBO.getBillApplyType())) {
            if (CollectionUtils.isEmpty((Collection)addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs())) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            }
            ArrayList<Long> inspectionIds = new ArrayList<Long>();
            addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs().forEach(queryPayPurchaseOrderInfoReqBO -> inspectionIds.add(queryPayPurchaseOrderInfoReqBO.getInspectionId()));
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionIds(inspectionIds);
            List<SaleOrderInfo> saleOrderInfoS = this.saleOrderInfoMapper.selectByInspectionIds(saleOrderInfo);
            if (CollectionUtils.isEmpty(saleOrderInfoS)) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            }
            for (SaleOrderInfo orderInfo : saleOrderInfoS) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orderInfo.getApplyNo())) continue;
                throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355[" + orderInfo.getInspectionCode() + "]\u5df2\u5f00\u7968");
            }
        }
        BillApplyInfoVO infoVO = new BillApplyInfoVO();
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        String applyNo = this.getBillApplyNo();
        BeanUtils.copyProperties((Object)addBillApplyInfoReqBO, (Object)billApplyInfo);
        billApplyInfo.setPurchaseName(addBillApplyInfoReqBO.getPurchaseName());
        billApplyInfo.setPurchaseNo(addBillApplyInfoReqBO.getPurchaseNo());
        billApplyInfo.setPurchaseCode(addBillApplyInfoReqBO.getPurchaseCode());
        BeanUtils.copyProperties((Object)addBillApplyInfoReqBO.getMailAddrInfo(), (Object)billApplyInfo);
        billApplyInfo.setMobile(billApplyInfo.getTel());
        billApplyInfo.setBillApplyType(addBillApplyInfoReqBO.getBillApplyType());
        if ("2".equals(addBillApplyInfoReqBO.getBillApplyType())) {
            log.error("### billApplyType ###" + addBillApplyInfoReqBO.getBillApplyType());
            infoVO = this.billApplyInfoMapper.selectByReturnBillNo(addBillApplyInfoReqBO.getBillNo());
            billApplyInfo.setAmt(infoVO.getAmt());
            billApplyInfo.setSource(infoVO.getSource());
            billApplyInfo.setSupplierName(infoVO.getSupplierName());
            billApplyInfo.setSupplierNo(infoVO.getSupplierNo());
            billApplyInfo.setPurchaseProjectId(infoVO.getPurchaseProjectId());
            billApplyInfo.setPurchaseNo(infoVO.getPurchaseNo());
            billApplyInfo.setPurchaseName(infoVO.getPurchaseName());
            billApplyInfo.setSaleCompanyId(infoVO.getSaleCompanyId());
            billApplyInfo.setSaleCompanyName(infoVO.getSaleCompanyName());
            billApplyInfo.setPurchaseCode(infoVO.getPurchaseCode());
            billApplyInfo.setTaxRate(infoVO.getTaxRate());
            billApplyInfo.setBillApplyType("3");
        }
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setSubUserName(addBillApplyInfoReqBO.getName());
        billApplyInfo.setApplyType("00");
        billApplyInfo.setBillStatus("00");
        billApplyInfo.setOperUnitNo(addBillApplyInfoReqBO.getCompanyId());
        billApplyInfo.setOperUnitName(addBillApplyInfoReqBO.getCompanyName());
        billApplyInfo.setPayFeeType("1");
        billApplyInfo.setRemark(null);
        billApplyInfo.setRedBlue("2");
        InvoiceHeaderVO invoiceInfo = addBillApplyInfoReqBO.getInvoiceInfo();
        billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
        log.error("invType" + invoiceInfo.getInvoiceType());
        Integer n = invType = invoiceInfo.getInvoiceType() == 2 ? InvoiceType.SPECIAL.getCode() : InvoiceType.NORMAL.getCode();
        if (invType != null) {
            billApplyInfo.setInvoiceType(invType.toString());
        }
        log.error("### invClass ###" + invoiceInfo.getInvoiceClass());
        String invClass = invoiceInfo.getInvoiceClass() == 1 ? InvoiceClasses.ELECTRONIC_INVOICE.getCode() : InvoiceClasses.PAPER_INVOICE.getCode();
        billApplyInfo.setInvoiceClasses(invClass);
        billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
        billApplyInfo.setPhone(invoiceInfo.getPhone());
        billApplyInfo.setBankName(invoiceInfo.getBank());
        billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
        billApplyInfo.setAddr(org.apache.commons.lang3.StringUtils.substring((String)invoiceInfo.getAddress(), (int)0, (int)80));
        if (addBillApplyInfoReqBO.getTaxRate() != null) {
            billApplyInfo.setTaxRate(addBillApplyInfoReqBO.getTaxRate());
        }
        log.debug(" insertSelective \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)billApplyInfo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        this.billApplyInfoMapper.insertSelective(billApplyInfo);
        ArrayList<String> orderCodes = new ArrayList<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (addBillApplyInfoReqBO.getBatchNo() != null) {
            log.error("#######BatchNo#######:" + addBillApplyInfoReqBO.getBatchNo());
            ReconciliationReqBo condition = new ReconciliationReqBo();
            condition.setVersionNo(addBillApplyInfoReqBO.getBatchNo());
            condition.setTabId(Integer.valueOf(1));
            condition.setSupplierNo(Integer.valueOf(addBillApplyInfoReqBO.getSupplierNo().intValue()));
            ReconciliationRspVo reconciliationRspVo = this.reconciliationHisService.getReceiptInfoByTabId(condition);
            if (reconciliationRspVo != null && reconciliationRspVo.getRows() != null && reconciliationRspVo.getRows().size() > 0) {
                ReconciliationHisVo reconciliationHisVo2;
                for (ReconciliationHisVo reconciliationHisVo2 : reconciliationRspVo.getRows()) {
                    orderCodes.add(reconciliationHisVo2.getOrderId());
                }
                BusiNotificationReqBO busiNotificationReqBO = new BusiNotificationReqBO();
                BeanUtils.copyProperties((Object)addBillApplyInfoReqBO, (Object)busiNotificationReqBO);
                busiNotificationReqBO.setOrderCodes(orderCodes);
                busiNotificationReqBO.setOperUnitNo(((ReconciliationHisVo)reconciliationRspVo.getRows().get(0)).getOperUnitNo());
                busiNotificationReqBO.setSupplierNo(addBillApplyInfoReqBO.getSupplierNo());
                busiNotificationReqBO.setSource(addBillApplyInfoReqBO.getSource().toString());
                reconciliationHisVo2 = this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBO);
            }
        } else {
            log.error("#######getQueryPayPurchaseOrderInfoReqBOs#######:" + addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs().size());
            if (addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs() != null && addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs().size() > 0) {
                for (QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO2 : addBillApplyInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs()) {
                    ids.add(queryPayPurchaseOrderInfoReqBO2.getInspectionId());
                }
            }
        }
        log.error("####### billApplyType #######:" + addBillApplyInfoReqBO.getBillApplyType());
        if ("2".equals(addBillApplyInfoReqBO.getBillApplyType())) {
            InvoiceReturn invoiceReturn = new InvoiceReturn();
            invoiceReturn.setBillNo(addBillApplyInfoReqBO.getBillNo());
            invoiceReturn.setRepeatApplyNo(applyNo);
            log.error("####### \u91cd\u5f00\u7533\u8bf7\u5355\u53f7 #######:" + applyNo);
            log.debug("updateByPrimaryKeySelective \u66f4\u65b0\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)invoiceReturn, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
            this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
            InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
            whereRecord.setBillNo(addBillApplyInfoReqBO.getBillNo());
            InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
            valueRecord.setApplyNo3(applyNo);
            log.debug("invoiceReturnDetailMapper.updateBy \u66f4\u65b0\u5165\u53c2whereRecord\uff1a{}, valueRecord:{}", (Object)JSON.toJSONString((Object)whereRecord, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), (Object)JSON.toJSONString((Object)valueRecord, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
            this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            List<SaleOrderInfo> orderInfos = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(infoVO.getApplyNo());
            log.error("####### orderInfos #######:" + orderInfos.size());
            for (SaleOrderInfo saleOrderInfo : orderInfos) {
                ids.add(saleOrderInfo.getInspectionId());
            }
        }
        if (ids.size() <= 0 && orderCodes.size() <= 0) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.error("####### ids #######:" + ids.size());
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfoVO.setInspectionIdList(ids);
        saleOrderInfoVO.setSaleOrderCodeList(orderCodes);
        saleOrderInfo.setOrderStatus("01");
        saleOrderInfo.setApplyNo(applyNo);
        this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, saleOrderInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        saleItemInfo.setApplyNo(applyNo);
        saleItemInfoVO.setInspectionIdList(ids);
        saleItemInfoVO.setSaleOrderCodeList(orderCodes);
        this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
        pfscExtRspBaseBO.setApplyNo(applyNo);
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        log.debug("\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pfscExtRspBaseBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        return pfscExtRspBaseBO;
    }

    private String getBillApplyNo() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "KPSQ";
        String maxNum = this.billApplyInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "000001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }
}

